"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttributesFromSuggestion = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLensAttributesFromSuggestion = ({
  filters,
  query,
  suggestion,
  dataView
}) => {
  var _suggestion$title;
  const suggestionDatasourceState = Object.assign({}, suggestion === null || suggestion === void 0 ? void 0 : suggestion.datasourceState);
  const suggestionVisualizationState = Object.assign({}, suggestion === null || suggestion === void 0 ? void 0 : suggestion.visualizationState);
  const datasourceStates = suggestion && suggestion.datasourceState ? {
    [suggestion.datasourceId]: {
      ...suggestionDatasourceState
    }
  } : {
    formBased: {}
  };
  const visualization = suggestionVisualizationState;
  const attributes = {
    title: (_suggestion$title = suggestion === null || suggestion === void 0 ? void 0 : suggestion.title) !== null && _suggestion$title !== void 0 ? _suggestion$title : _i18n.i18n.translate('visualizationUtils.config.suggestion.title', {
      defaultMessage: 'New suggestion'
    }),
    references: [],
    state: {
      datasourceStates,
      filters,
      query,
      visualization,
      ...(dataView && dataView.id && !dataView.isPersisted() && {
        adHocDataViews: {
          [dataView.id]: dataView.toMinimalSpec()
        }
      })
    },
    visualizationType: suggestion ? suggestion.visualizationId : 'lnsXY',
    version: 1
  };
  return attributes;
};
exports.getLensAttributesFromSuggestion = getLensAttributesFromSuggestion;