"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToPercentileRankParams = exports.convertToPercentileRankColumn = void 0;
var _common = require("@kbn/data-plugin/common");
var _ = require("../..");
var _utils = require("../utils");
var _column = require("./column");
var _supported_metrics = require("./supported_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertToPercentileRankParams = value => ({
  value: Number(value)
});
exports.convertToPercentileRankParams = convertToPercentileRankParams;
const isSinglePercentileRank = agg => {
  if (agg.aggType === _common.METRIC_TYPES.SINGLE_PERCENTILE_RANK) {
    return true;
  }
  return false;
};
const getPercent = agg => {
  if (isSinglePercentileRank(agg)) {
    var _agg$aggParams;
    return (_agg$aggParams = agg.aggParams) === null || _agg$aggParams === void 0 ? void 0 : _agg$aggParams.value;
  }
  const {
    aggParams,
    aggId
  } = agg;
  if (!aggParams || !aggId) {
    return null;
  }
  const {
    values
  } = aggParams;
  const [, percentStr] = aggId.split('.');
  const percent = Number(percentStr);
  if (!values || !values.length || percentStr === '' || isNaN(percent)) {
    return null;
  }
  return percent;
};
const convertToPercentileRankColumn = ({
  visType,
  agg,
  dataView
}, {
  index,
  reducedTimeRange
} = {}) => {
  const {
    aggParams
  } = agg;
  const percent = getPercent(agg);
  if (percent === null || percent === undefined) {
    return null;
  }
  const params = convertToPercentileRankParams(percent);
  const fieldName = (0, _utils.getFieldNameFromField)(aggParams.field);
  if (!fieldName) {
    return null;
  }
  const field = dataView.getFieldByName(fieldName);
  if (!(0, _.isFieldValid)(visType, field, _supported_metrics.SUPPORTED_METRICS[agg.aggType])) {
    return null;
  }
  return {
    operationType: 'percentile_rank',
    sourceField: field.name,
    ...(0, _column.createColumn)(agg, field, {
      reducedTimeRange
    }),
    params: {
      ...params,
      ...(0, _column.getFormat)()
    },
    label: (0, _utils.getLabelForPercentile)(agg),
    timeShift: aggParams === null || aggParams === void 0 ? void 0 : aggParams.timeShift
  };
};
exports.convertToPercentileRankColumn = convertToPercentileRankColumn;