"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformOut = getTransformOut;
var _constants = require("../../constants");
var _get_transform_in = require("./get_transform_in");
var _inject_vis_references = require("../../references/inject_vis_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTransformOut(transformEnhancementsOut) {
  function transformOut(state, references) {
    const enhancementsState = state.enhancements ? transformEnhancementsOut(state.enhancements, references !== null && references !== void 0 ? references : []) : undefined;

    // by ref
    const savedObjectRef = (references !== null && references !== void 0 ? references : []).find(ref => _constants.VISUALIZE_SAVED_OBJECT_TYPE === ref.type && ref.name === _get_transform_in.VIS_SAVED_OBJECT_REF_NAME);
    if (savedObjectRef) {
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        savedObjectId: savedObjectRef.id
      };
    }

    // by value
    if (state.savedVis) {
      const savedVis = (0, _inject_vis_references.injectVisReferences)(state.savedVis, references !== null && references !== void 0 ? references : []);
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        savedVis
      };
    }
    return {
      ...state,
      ...(enhancementsState ? {
        enhancements: enhancementsState
      } : {})
    };
  }
  return transformOut;
}