"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStopsWithColorsFromRanges = void 0;
var _common = require("@kbn/charts-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TRANSPARENT = 'rgba(0, 0, 0, 0)';
const getColor = (index, elementsCount, colorSchema, invertColors = false) => {
  const divider = Math.max(elementsCount - 1, 1);
  const value = invertColors ? 1 - index / divider : index / divider;
  return (0, _common.getHeatmapColors)(value, colorSchema);
};
const getStopsWithColorsFromRanges = (ranges, colorSchema, invertColors = false) => {
  return ranges.reduce((acc, range, index, rangesArr) => {
    if (index && range.from !== rangesArr[index - 1].to || index === 0) {
      acc.color.push(TRANSPARENT);
      acc.stop.push(range.from);
    }
    acc.color.push(getColor(index, rangesArr.length, colorSchema, invertColors));
    acc.stop.push(range.to);
    return acc;
  }, {
    color: [],
    stop: []
  });
};
exports.getStopsWithColorsFromRanges = getStopsWithColorsFromRanges;