"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareLogTable = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isLayerDimensions = dimensions => dimensions[0].length === 3;
const isColumnEqualToAccessor = (column, columnIndex, accessor) => {
  if (typeof accessor === 'string') {
    return accessor === column.id;
  }
  if (typeof accessor === 'number') {
    return accessor === columnIndex;
  }
  return accessor.id === column.id;
};
const getAccessorFromDimension = dimension => {
  if (typeof dimension === 'string') {
    return dimension;
  }
  return dimension.accessor;
};
const getDimensionName = (column, columnIndex, dimensions) => {
  for (const dimension of dimensions) {
    var _dimension$;
    if ((_dimension$ = dimension[0]) !== null && _dimension$ !== void 0 && _dimension$.find(d => isColumnEqualToAccessor(column, columnIndex, getAccessorFromDimension(d)))) {
      return dimension[1];
    }
  }
};
const getDimensionType = (column, columnIndex, dimensions) => {
  for (const dimension of dimensions) {
    var _dimension$2;
    if ((_dimension$2 = dimension[0]) !== null && _dimension$2 !== void 0 && _dimension$2.find(d => isColumnEqualToAccessor(column, columnIndex, getAccessorFromDimension(d)))) {
      return dimension[2];
    }
  }
};
const prepareLogTable = (datatable, dimensions, removeUnmappedColumns = false) => {
  const hasLayerDimensions = isLayerDimensions(dimensions);
  return {
    ...datatable,
    columns: datatable.columns.map((column, columnIndex) => {
      return {
        ...column,
        meta: {
          ...column.meta,
          dimensionName: getDimensionName(column, columnIndex, dimensions),
          ...(hasLayerDimensions ? {
            dimensionType: getDimensionType(column, columnIndex, dimensions)
          } : {})
        }
      };
    }).filter(column => !removeUnmappedColumns || column.meta.dimensionName)
  };
};
exports.prepareLogTable = prepareLogTable;