"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVisInstance = void 0;
var _vis_async = require("../vis_async");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createVisInstance = async serializedVis => {
  const vis = await (0, _vis_async.createVisAsync)(serializedVis.type, serializedVis);
  if (serializedVis.data.savedSearchId) {
    const savedSearch = await (0, _services.getSavedSearch)().get(serializedVis.data.savedSearchId);
    const indexPattern = savedSearch.searchSource.getField('index');
    if (indexPattern) {
      var _vis$data$searchSourc;
      vis.data.indexPattern = indexPattern;
      (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.setField('index', indexPattern);
    }
  }
  return vis;
};
exports.createVisInstance = createVisInstance;