"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpressionRendererProps = void 0;
var _to_ast = require("./to_ast");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getExpressionRendererProps = async ({
  unifiedSearch: {
    query,
    filters
  },
  settings: {
    syncColors = true,
    syncCursor = true,
    syncTooltips = false
  },
  disableTriggers = false,
  parentExecutionContext,
  searchSessionId,
  vis,
  abortController,
  timeRange,
  onRender,
  onEvent,
  onData
}) => {
  var _vis$id, _vis$type$getExpressi, _vis$type;
  const parentContext = parentExecutionContext !== null && parentExecutionContext !== void 0 ? parentExecutionContext : (0, _services.getExecutionContext)().get();
  const childContext = {
    type: 'agg_based',
    name: vis.type.name,
    id: (_vis$id = vis.id) !== null && _vis$id !== void 0 ? _vis$id : 'new',
    description: vis.title
  };
  const executionContext = {
    ...parentContext,
    childContext
  };
  const timefilter = (0, _services.getTimeFilter)();
  const expressionVariables = await ((_vis$type$getExpressi = (_vis$type = vis.type).getExpressionVariables) === null || _vis$type$getExpressi === void 0 ? void 0 : _vis$type$getExpressi.call(_vis$type, vis, timefilter));
  const inspectorAdapters = vis.type.inspectorAdapters ? typeof vis.type.inspectorAdapters === 'function' ? vis.type.inspectorAdapters() : vis.type.inspectorAdapters : undefined;
  const loaderParams = {
    searchContext: {
      timeRange,
      query,
      filters,
      disableWarningToasts: true
    },
    variables: {
      embeddableTitle: vis.title,
      ...expressionVariables
    },
    searchSessionId,
    syncColors,
    syncTooltips,
    syncCursor,
    uiState: vis.uiState,
    interactive: !disableTriggers,
    inspectorAdapters,
    executionContext,
    onRender$: onRender,
    onData$: onData,
    onEvent
  };
  if (abortController) {
    abortController.abort();
  }
  const newAbortController = new AbortController();
  const expression = await (0, _to_ast.toExpressionAst)(vis, {
    timefilter,
    timeRange,
    abortSignal: newAbortController.signal
  });
  if (!newAbortController.signal.aborted) {
    return {
      params: {
        expression,
        ...loaderParams
      },
      abortController: newAbortController
    };
  }
  return {
    params: null,
    abortController: newAbortController
  };
};
exports.getExpressionRendererProps = getExpressionRendererProps;