"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVisEmbeddableFromObject = void 0;
var _services = require("../../services");
var _ = require("../..");
var _visualize_embeddable_async = require("./visualize_embeddable_async");
var _error_embeddable = require("./error_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @deprecated
 * VisualizeEmbeddable is no longer registered with the legacy embeddable system and is only
 * used within the visualize editor.
 */
const createVisEmbeddableFromObject = deps => async (vis, input, attributeService) => {
  try {
    var _getCapabilities$dash, _getCapabilities$visu;
    const visId = vis.id;
    const editPath = visId ? (0, _.urlFor)(visId) : '#/edit_by_value';
    const editUrl = visId ? (0, _services.getHttp)().basePath.prepend(`/app/visualize${(0, _.urlFor)(visId)}`) : '';
    let indexPatterns = [];
    if (vis.type.getUsedIndexPattern) {
      try {
        indexPatterns = await vis.type.getUsedIndexPattern(vis.params);
      } catch (e) {
        // nothing to be here
      }
    } else if (vis.data.indexPattern) {
      indexPatterns = [vis.data.indexPattern];
    }
    const capabilities = {
      visualizeSave: Boolean((0, _services.getCapabilities)().visualize_v2.save),
      dashboardSave: Boolean((_getCapabilities$dash = (0, _services.getCapabilities)().dashboard_v2) === null || _getCapabilities$dash === void 0 ? void 0 : _getCapabilities$dash.showWriteControls),
      visualizeOpen: Boolean((_getCapabilities$visu = (0, _services.getCapabilities)().visualize_v2) === null || _getCapabilities$visu === void 0 ? void 0 : _getCapabilities$visu.show)
    };
    return (0, _visualize_embeddable_async.createVisualizeEmbeddableAsync)((0, _services.getTimeFilter)(), {
      vis,
      indexPatterns,
      editPath,
      editUrl,
      deps,
      capabilities
    }, input, attributeService);
  } catch (e) {
    console.error(e); // eslint-disable-line no-console
    return new _error_embeddable.ErrorEmbeddable(e, input);
  }
};
exports.createVisEmbeddableFromObject = createVisEmbeddableFromObject;