"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _history = require("history");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _css = require("@emotion/css");
var _triggers = require("./triggers");
var _vis_editors_registry = require("./vis_editors_registry");
var _wizard = require("./wizard");
var _locator = require("../common/locator");
var _xy_dimension = require("../common/expression_functions/xy_dimension");
var _vis_dimension = require("../common/expression_functions/vis_dimension");
var _range = require("../common/expression_functions/range");
var _types_service = require("./vis_types/types_service");
var _services = require("./services");
var _constants = require("../common/constants");
var _content_management = require("../common/content_management");
var _register_actions = require("./actions/register_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Interface for this plugin's returned setup/start contracts.
 *
 * @public
 */

const styles = {
  visAppWrapper: (0, _css.css)({
    display: 'flex',
    flexDirection: 'column',
    flexGrow: 1
  }),
  globalScreenshotMode: (0, _css.css)`
    kbn-top-nav,
    filter-bar,
    .kbnTopNavMenu__wrapper,
    ::-webkit-scrollbar,
    .euiNavDrawer {
      display: none !important;
    }
  `,
  visEditorScreenshotMode: (0, _css.css)`
    /* hide unusable controls !important is required to override resizable panel inline display */
    .visEditor__content .visEditor--default > :not(.visEditor__visualization__wrapper) {
      display: none !important;
    }

    /** THIS IS FOR TSVB UNTIL REFACTOR **/
    .tvbEditorVisualization {
      position: static !important;
    }
    .visualize .tvbVisTimeSeries__legendToggle {
      /* all non-content rows in interface */
      display: none;
    }

    .tvbEditor--hideForReporting {
      /* all non-content rows in interface */
      display: none;
    }
    /**  END TSVB BAD BAD HACKS **/

    /* remove left padding from visualizations so that map lines up with .leaflet-container and
    *  setting the position to be fixed and to take up the entire screen, because some zoom levels/viewports
    *  are triggering the media breakpoints that cause the .visEditor__canvas to take up more room than the viewport */

    .visEditor .visEditor__canvas {
      padding-left: 0;
      position: fixed;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
    }

    /** Visualization tweaks */

    /* hide unusable controls */
    .visualize .visLegend__toggle,
    .visualize .kbnAggTable__controls,
    .visualize .leaflet-container .leaflet-top.leaflet-left,
    .visualize paginate-controls /* page numbers */ {
      display: none;
    }

    /* Ensure the min-height of the small breakpoint isn't used */
    .vis-editor visualization {
      min-height: 0 !important;
    }
  `
};

/**
 * Visualizations Plugin - public
 *
 * This plugin's stateful contracts are returned from the `setup` and `start` methods
 * below. The interfaces for these contracts are provided above.
 *
 * @internal
 */
class VisualizationsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "types", new _types_service.TypesService());
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "stopUrlTracking", undefined);
    (0, _defineProperty2.default)(this, "currentHistory", undefined);
    (0, _defineProperty2.default)(this, "isLinkedToOriginatingApp", undefined);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    embeddable,
    data,
    home,
    urlForwarding,
    share,
    uiActions,
    contentManagement
  }) {
    const {
      appMounted,
      appUnMounted,
      stop: stopUrlTracker,
      setActiveUrl,
      restorePreviousUrl
    } = (0, _public2.createKbnUrlTracker)({
      baseUrl: core.http.basePath.prepend(_constants.VisualizeConstants.VISUALIZE_BASE_PATH),
      defaultSubUrl: '#/',
      storageKey: `lastUrl:${core.http.basePath.get()}:visualize`,
      navLinkUpdater$: this.appStateUpdater,
      toastNotifications: core.notifications.toasts,
      stateParams: [{
        kbnUrlKey: '_g',
        stateUpdate$: data.query.state$.pipe((0, _rxjs.filter)(({
          changes
        }) => !!(changes.globalFilters || changes.time || changes.refreshInterval)), (0, _rxjs.map)(({
          state
        }) => ({
          ...state,
          filters: data.query.filterManager.getGlobalFilters()
        })))
      }],
      getHistory: () => this.currentHistory,
      onBeforeNavLinkSaved: urlToSave => {
        var _this$isLinkedToOrigi;
        if ((_this$isLinkedToOrigi = this.isLinkedToOriginatingApp) !== null && _this$isLinkedToOrigi !== void 0 && _this$isLinkedToOrigi.call(this)) {
          return core.http.basePath.prepend(_constants.VisualizeConstants.VISUALIZE_BASE_PATH);
        }
        const tableListUrlState = ['s', 'title', 'sort', 'sortdir'];
        return (0, _common.replaceUrlHashQuery)(urlToSave, query => {
          tableListUrlState.forEach(param => {
            delete query[param];
          });
          return query;
        });
      }
    });
    this.stopUrlTracking = () => {
      stopUrlTracker();
    };
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const listingViewRegistry = new Set();
    const visEditorsRegistry = (0, _vis_editors_registry.createVisEditorsRegistry)();
    core.application.register({
      id: _constants.VisualizeConstants.APP_ID,
      title: 'Visualize library',
      order: 8000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appStateUpdater.asObservable(),
      // remove all references to visualize
      mount: async params => {
        var _pluginsStart$savedOb;
        const [coreStart, pluginsStart] = await core.getStartServices();
        this.currentHistory = params.history;

        // allows the urlTracker to only save URLs that are not linked to an originatingApp
        this.isLinkedToOriginatingApp = () => {
          var _pluginsStart$embedda;
          return Boolean((_pluginsStart$embedda = pluginsStart.embeddable.getStateTransfer().getIncomingEditorState(_constants.VisualizeConstants.APP_ID)) === null || _pluginsStart$embedda === void 0 ? void 0 : _pluginsStart$embedda.originatingApp);
        };

        // make sure the index pattern list is up to date
        pluginsStart.dataViews.clearCache();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = params.history.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        /**
         * current implementation uses 2 history objects:
         * 1. the hash history (used for the react hash router)
         * 2. and the scoped history (used for url tracking)
         * this should be replaced to use only scoped history after moving legacy apps to browser routing
         */
        const history = (0, _history.createHashHistory)();
        const [{
          createVisEmbeddableFromObject
        }, {
          renderApp
        }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./legacy/embeddable'))), Promise.resolve().then(() => _interopRequireWildcard(require('./visualize_app')))]);
        const services = {
          ...coreStart,
          history,
          kbnUrlStateStorage: (0, _public2.createKbnUrlStateStorage)({
            history,
            useHash: coreStart.uiSettings.get('state:storeInSessionStorage'),
            ...(0, _public2.withNotifyOnErrors)(coreStart.notifications.toasts)
          }),
          urlForwarding: pluginsStart.urlForwarding,
          pluginInitializerContext: this.initializerContext,
          chrome: coreStart.chrome,
          data: pluginsStart.data,
          core: coreStart,
          dataViewEditor: pluginsStart.dataViewEditor,
          dataViews: pluginsStart.dataViews,
          localStorage: new _public2.Storage(localStorage),
          navigation: pluginsStart.navigation,
          share: pluginsStart.share,
          toastNotifications: coreStart.notifications.toasts,
          visualizeCapabilities: coreStart.application.capabilities.visualize_v2,
          dashboardCapabilities: coreStart.application.capabilities.dashboard_v2,
          embeddable: pluginsStart.embeddable,
          stateTransferService: pluginsStart.embeddable.getStateTransfer(),
          setActiveUrl,
          /** @deprecated */
          createVisEmbeddableFromObject: createVisEmbeddableFromObject({
            start
          }),
          scopedHistory: params.history,
          restorePreviousUrl,
          setHeaderActionMenu: params.setHeaderActionMenu,
          savedObjectsTagging: (_pluginsStart$savedOb = pluginsStart.savedObjectsTaggingOss) === null || _pluginsStart$savedOb === void 0 ? void 0 : _pluginsStart$savedOb.getTaggingApi(),
          savedSearch: pluginsStart.savedSearch,
          presentationUtil: pluginsStart.presentationUtil,
          getKibanaVersion: () => this.initializerContext.env.packageInfo.version,
          spaces: pluginsStart.spaces,
          visEditorsRegistry,
          listingViewRegistry,
          unifiedSearch: pluginsStart.unifiedSearch,
          serverless: pluginsStart.serverless,
          noDataPage: pluginsStart.noDataPage,
          contentManagement: pluginsStart.contentManagement
        };
        params.element.classList.add(styles.visAppWrapper);
        if (pluginsStart.screenshotMode.isScreenshotMode()) {
          params.element.classList.add(styles.visEditorScreenshotMode);
          (0, _css.injectGlobal)(styles.globalScreenshotMode);
        }
        const unmount = renderApp(params, services);
        return () => {
          data.search.session.clear();
          params.element.classList.remove(styles.visAppWrapper);
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    urlForwarding.forwardApp('visualize', 'visualize');
    if (home) {
      home.featureCatalogue.register({
        id: 'visualize',
        title: 'Visualize library',
        description: _i18n.i18n.translate('visualizations.visualizeDescription', {
          defaultMessage: 'Create visualizations and aggregate data stores in your Elasticsearch indices.'
        }),
        icon: 'visualizeApp',
        path: `/app/visualize#${_constants.VisualizeConstants.LANDING_PAGE_PATH}`,
        showOnHomePage: false,
        category: 'data'
      });
    }
    if (share) {
      share.url.locators.create(new _locator.VisualizeLocatorDefinition());
    }
    (0, _services.setUISettings)(core.uiSettings);
    (0, _services.setAnalytics)(core.analytics);
    (0, _services.setTheme)(core.theme);
    expressions.registerFunction(_range.range);
    expressions.registerFunction(_vis_dimension.visDimension);
    expressions.registerFunction(_xy_dimension.xyDimension);
    uiActions.registerTrigger(_triggers.aggBasedVisualizationTrigger);
    uiActions.registerTrigger(_triggers.visualizeEditorTrigger);
    uiActions.registerTrigger(_triggers.dashboardVisualizationPanelTrigger);
    embeddable.registerReactEmbeddableFactory(_constants.VISUALIZE_EMBEDDABLE_TYPE, async () => {
      const {
        plugins: {
          embeddable: embeddableStart,
          embeddableEnhanced: embeddableEnhancedStart
        }
      } = start();
      const {
        getVisualizeEmbeddableFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/embeddable_module')));
      return getVisualizeEmbeddableFactory({
        embeddableStart,
        embeddableEnhancedStart
      });
    });
    embeddable.registerAddFromLibraryType({
      onAdd: async (container, savedObject) => {
        container.addNewPanel({
          panelType: _constants.VISUALIZE_EMBEDDABLE_TYPE,
          serializedState: {
            rawState: {
              savedObjectId: savedObject.id
            },
            references: []
          }
        }, true);
      },
      savedObjectType: _constants.VISUALIZE_EMBEDDABLE_TYPE,
      savedObjectName: _i18n.i18n.translate('visualizations.visualizeSavedObjectName', {
        defaultMessage: 'Visualization'
      }),
      getIconForSavedObject: savedObject => {
        var _savedObject$attribut, _getTypes$get$icon, _getTypes$get;
        const visState = JSON.parse((_savedObject$attribut = savedObject.attributes.visState) !== null && _savedObject$attribut !== void 0 ? _savedObject$attribut : '{}');
        return (_getTypes$get$icon = (_getTypes$get = (0, _services.getTypes)().get(visState.type)) === null || _getTypes$get === void 0 ? void 0 : _getTypes$get.icon) !== null && _getTypes$get$icon !== void 0 ? _getTypes$get$icon : '';
      }
    });
    embeddable.registerTransforms(_constants.VISUALIZE_EMBEDDABLE_TYPE, async () => {
      const {
        getTransforms
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/embeddable_module')));
      return getTransforms(embeddable.transformEnhancementsIn, embeddable.transformEnhancementsOut);
    });
    contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: 'Visualize library'
    });
    return {
      ...this.types.setup(),
      visEditorsRegistry,
      listingViewRegistry
    };
  }
  start(core, {
    data,
    expressions,
    uiActions,
    embeddable,
    spaces,
    savedObjectsTaggingOss,
    fieldFormats,
    usageCollection,
    savedObjectsManagement,
    contentManagement,
    savedSearch,
    dataViews,
    inspector
  }) {
    const types = this.types.start();
    (0, _services.setTypes)(types);
    (0, _services.setI18n)(core.i18n);
    (0, _services.setUserProfile)(core.userProfile);
    (0, _services.setEmbeddable)(embeddable);
    (0, _services.setApplication)(core.application);
    (0, _services.setCapabilities)(core.application.capabilities);
    (0, _services.setHttp)(core.http);
    (0, _services.setDocLinks)(core.docLinks);
    (0, _services.setSearch)(data.search);
    (0, _services.setExpressions)(expressions);
    (0, _services.setUiActions)(uiActions);
    (0, _services.setTimeFilter)(data.query.timefilter.timefilter);
    (0, _services.setAggs)(data.search.aggs);
    (0, _services.setOverlays)(core.overlays);
    (0, _services.setExecutionContext)(core.executionContext);
    (0, _services.setChrome)(core.chrome);
    (0, _services.setFieldFormats)(fieldFormats);
    (0, _services.setUsageCollection)(usageCollection);
    (0, _services.setSavedObjectsManagement)(savedObjectsManagement);
    (0, _services.setContentManagement)(contentManagement);
    (0, _services.setSavedSearch)(savedSearch);
    (0, _services.setDataViews)(dataViews);
    (0, _services.setInspector)(inspector);
    (0, _services.setNotifications)(core.notifications);
    if (spaces) {
      (0, _services.setSpaces)(spaces);
    }
    if (savedObjectsTaggingOss) {
      (0, _services.setSavedObjectTagging)(savedObjectsTaggingOss);
    }
    (0, _register_actions.registerActions)(uiActions, data, types);
    return {
      ...types,
      showNewVisModal: _wizard.showNewVisModal
    };
  }
  stop() {
    this.types.stop();
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
}
exports.VisualizationsPlugin = VisualizationsPlugin;