"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateBasicSoAttributes = exports.deleteSOByType = exports.deleteListItems = void 0;
var _saved_visualization_references = require("../saved_visualization_references");
var _content_management = require("../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getClientForType(type, typesService, contentManagement, http) {
  var _visAliases$find, _visAliases$find$appE;
  const visAliases = typesService.getAliases();
  return ((_visAliases$find = visAliases.find(v => {
    var _v$appExtensions;
    return (_v$appExtensions = v.appExtensions) === null || _v$appExtensions === void 0 ? void 0 : _v$appExtensions.visualizations.docTypes.includes(type);
  })) === null || _visAliases$find === void 0 ? void 0 : (_visAliases$find$appE = _visAliases$find.appExtensions) === null || _visAliases$find$appE === void 0 ? void 0 : _visAliases$find$appE.visualizations.client(contentManagement, http)) || _content_management.visualizationsClient;
}
function getAdditionalOptionsForUpdate(type, typesService, method) {
  var _aliasType$appExtensi, _aliasType$appExtensi2, _aliasType$appExtensi3;
  const visAliases = typesService.getAliases();
  const aliasType = visAliases.find(v => {
    var _v$appExtensions2;
    return (_v$appExtensions2 = v.appExtensions) === null || _v$appExtensions2 === void 0 ? void 0 : _v$appExtensions2.visualizations.docTypes.includes(type);
  });
  if (!aliasType) {
    return {
      overwrite: true
    };
  }
  return aliasType === null || aliasType === void 0 ? void 0 : (_aliasType$appExtensi = aliasType.appExtensions) === null || _aliasType$appExtensi === void 0 ? void 0 : (_aliasType$appExtensi2 = _aliasType$appExtensi.visualizations) === null || _aliasType$appExtensi2 === void 0 ? void 0 : (_aliasType$appExtensi3 = _aliasType$appExtensi2.clientOptions) === null || _aliasType$appExtensi3 === void 0 ? void 0 : _aliasType$appExtensi3[method];
}
const updateBasicSoAttributes = async (id, type, newAttributes, dependencies) => {
  const client = getClientForType(type, dependencies.typesService, dependencies.contentManagement, dependencies.http);
  const so = await client.get(id);
  const extractedReferences = (0, _saved_visualization_references.extractReferences)({
    attributes: so.item.attributes,
    references: so.item.references
  });
  let {
    references
  } = extractedReferences;
  const attributes = {
    ...extractedReferences.attributes,
    title: newAttributes.title,
    description: newAttributes.description
  };
  if (dependencies.savedObjectsTagging) {
    references = dependencies.savedObjectsTagging.ui.updateTagsReferences(references, newAttributes.tags || []);
  }
  return await client.update({
    id,
    data: {
      ...attributes
    },
    options: {
      references,
      ...getAdditionalOptionsForUpdate(type, dependencies.typesService, 'update')
    }
  });
};
exports.updateBasicSoAttributes = updateBasicSoAttributes;
const deleteSOByType = async (id, type, dependencies) => {
  const client = getClientForType(type, dependencies.typesService, dependencies.contentManagement, dependencies.http);
  const {
    success
  } = await client.delete(id);
  if (!success) throw new Error();
};
exports.deleteSOByType = deleteSOByType;
const deleteListItems = async (items, dependencies) => {
  return Promise.all(items.map(async item => {
    await deleteSOByType(item.id, item.savedObjectType, dependencies);
  }));
};
exports.deleteListItems = deleteListItems;