"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSavedObjectAttributesToReferences = convertSavedObjectAttributesToReferences;
exports.extractReferences = extractReferences;
exports.injectReferences = injectReferences;
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _controls_references = require("../../../common/references/controls_references");
var _timeseries_references = require("../../../common/references/timeseries_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function convertSavedObjectAttributesToReferences(attributes) {
  var _attributes$kibanaSav;
  const references = [];
  if ((_attributes$kibanaSav = attributes.kibanaSavedObjectMeta) !== null && _attributes$kibanaSav !== void 0 && _attributes$kibanaSav.searchSourceJSON) {
    const searchSource = JSON.parse(attributes.kibanaSavedObjectMeta.searchSourceJSON);
    const indexId = searchSource.index.id;
    const refName = 'kibanaSavedObjectMeta.searchSourceJSON.index';
    references.push({
      name: refName,
      type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
      id: indexId
    });
  }
  if (attributes.savedSearchId) {
    references.push({
      name: 'search_0',
      type: 'search',
      id: attributes.savedSearchId
    });
  }
  return references;
}
function extractReferences({
  attributes,
  references = []
}) {
  const updatedAttributes = {
    ...attributes
  };
  const updatedReferences = [...references];
  if (updatedAttributes.searchSourceFields) {
    const [searchSource, searchSourceReferences] = (0, _public.extractSearchSourceReferences)(updatedAttributes.searchSourceFields);
    updatedAttributes.searchSourceFields = searchSource;
    searchSourceReferences.forEach(r => updatedReferences.push(r));
  }

  // Extract saved search
  if (updatedAttributes.savedSearchId) {
    updatedReferences.push({
      name: 'search_0',
      type: 'search',
      id: String(updatedAttributes.savedSearchId)
    });
    delete updatedAttributes.savedSearchId;
    updatedAttributes.savedSearchRefName = 'search_0';
  }

  // Extract index patterns from controls
  if (updatedAttributes.visState) {
    const visState = JSON.parse(String(updatedAttributes.visState));
    if (visState.type && visState.params) {
      (0, _controls_references.extractControlsReferences)(visState.type, visState.params, updatedReferences);
      (0, _timeseries_references.extractTimeSeriesReferences)(visState.type, visState.params, updatedReferences);
    }
    updatedAttributes.visState = JSON.stringify(visState);
  }
  return {
    references: updatedReferences,
    attributes: updatedAttributes
  };
}
function injectReferences(savedObject, references) {
  var _savedObject$visState;
  if (savedObject.searchSourceFields) {
    savedObject.searchSourceFields = (0, _public.injectSearchSourceReferences)(savedObject.searchSourceFields, references);
  }
  if (savedObject.savedSearchRefName) {
    const savedSearchReference = references.find(reference => reference.name === savedObject.savedSearchRefName);
    if (!savedSearchReference) {
      throw new Error(`Could not find saved search reference "${savedObject.savedSearchRefName}"`);
    }
    savedObject.savedSearchId = savedSearchReference.id;
    delete savedObject.savedSearchRefName;
  }
  const {
    type,
    params
  } = (_savedObject$visState = savedObject.visState) !== null && _savedObject$visState !== void 0 ? _savedObject$visState : {};
  if (type && params) {
    (0, _controls_references.injectControlsReferences)(type, params, references);
    (0, _timeseries_references.injectTimeSeriesReferences)(type, params, references);
  }
}