"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Schemas = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireWildcard(require("lodash"));
var _public = require("@kbn/data-plugin/public");
let _AggGroupNames$Bucket, _AggGroupNames$Metric;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
_AggGroupNames$Bucket = _public.AggGroupNames.Buckets;
_AggGroupNames$Metric = _public.AggGroupNames.Metrics;
/** @internal **/
class Schemas {
  constructor(schemas) {
    (0, _defineProperty2.default)(this, "all", []);
    (0, _defineProperty2.default)(this, _AggGroupNames$Bucket, []);
    (0, _defineProperty2.default)(this, _AggGroupNames$Metric, []);
    (0, _lodash.default)(schemas || []).chain().map(schema => {
      if (!schema.name) throw new Error('all schema must have a unique name');
      if (schema.name === 'split') {
        schema.params = [{
          name: 'row',
          default: true
        }];
      }
      (0, _lodash.defaults)(schema, {
        min: 0,
        max: Infinity,
        group: _public.AggGroupNames.Buckets,
        title: schema.name,
        aggFilter: '*',
        params: []
      });
      return schema;
    }).tap(fullSchemas => {
      this.all = fullSchemas;
    }).groupBy('group').forOwn((group, groupName) => {
      // @ts-ignore
      this[groupName] = group;
    }).commit();
  }
}
exports.Schemas = Schemas;