"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeByValueEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _events = require("events");
var _public = require("@kbn/kibana-react-plugin/public");
var _utils = require("../utils");
var _visualize_editor_common = require("./visualize_editor_common");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/components/visualize_byvalue_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VisualizeByValueEditor = ({
  onAppLeave
}) => {
  const [originatingApp, setOriginatingApp] = (0, _react.useState)();
  const [originatingPath, setOriginatingPath] = (0, _react.useState)();
  const {
    services
  } = (0, _public.useKibana)();
  const [eventEmitter] = (0, _react.useState)(new _events.EventEmitter());
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(false);
  const [embeddableId, setEmbeddableId] = (0, _react.useState)();
  const [valueInput, setValueInput] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const {
      stateTransferService,
      history,
      data
    } = services;
    const {
      originatingApp: value,
      embeddableId: embeddableIdValue,
      valueInput: valueInputValue,
      searchSessionId,
      originatingPath: pathValue
    } = stateTransferService.getIncomingEditorState(_constants.VisualizeConstants.APP_ID) || {};
    setOriginatingPath(pathValue);
    setOriginatingApp(value);
    setValueInput(valueInputValue);
    setEmbeddableId(embeddableIdValue);
    if (!valueInputValue) {
      // if there is no value input to load, redirect to the visualize listing page.
      history.replace(_constants.VisualizeConstants.LANDING_PAGE_PATH);
    }
    if (searchSessionId) {
      data.search.session.continue(searchSessionId);
    } else {
      data.search.session.start();
    }
  }, [services]);
  const isChromeVisible = (0, _utils.useChromeVisibility)(services.chrome);
  const {
    byValueVisInstance,
    visEditorRef,
    visEditorController
  } = (0, _utils.useVisByValue)(services, eventEmitter, isChromeVisible, valueInput, originatingApp, originatingPath);
  const {
    appState,
    hasUnappliedChanges
  } = (0, _utils.useVisualizeAppState)(services, eventEmitter, byValueVisInstance);
  const {
    isEmbeddableRendered,
    currentAppState
  } = (0, _utils.useEditorUpdates)(services, eventEmitter, setHasUnsavedChanges, appState, byValueVisInstance, visEditorController);
  (0, _utils.useLinkedSearchUpdates)(services, eventEmitter, appState, byValueVisInstance);
  (0, _utils.useDataViewUpdates)(services, eventEmitter, appState, byValueVisInstance);
  (0, _react.useEffect)(() => {
    // clean up all registered listeners if any is left
    return () => {
      eventEmitter.removeAllListeners();
    };
  }, [eventEmitter]);
  return /*#__PURE__*/_react.default.createElement(_visualize_editor_common.VisualizeEditorCommon, {
    visInstance: byValueVisInstance,
    appState: appState,
    currentAppState: currentAppState,
    isChromeVisible: isChromeVisible,
    hasUnsavedChanges: hasUnsavedChanges,
    hasUnappliedChanges: hasUnappliedChanges,
    isEmbeddableRendered: isEmbeddableRendered,
    originatingApp: originatingApp,
    setOriginatingApp: setOriginatingApp,
    originatingPath: originatingPath,
    setHasUnsavedChanges: setHasUnsavedChanges,
    visEditorRef: visEditorRef,
    embeddableId: embeddableId,
    onAppLeave: onAppLeave,
    eventEmitter: eventEmitter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.VisualizeByValueEditor = VisualizeByValueEditor;