"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeEditorCommon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _visualize_top_nav = require("./visualize_top_nav");
var _experimental_vis_info = require("./experimental_vis_info");
var _ = require("../..");
var _services = require("../../services");
var _viz_chart_warning = require("./viz_chart_warning");
var _split_chart_warning_helpers = require("../utils/split_chart_warning_helpers");
var _vis = require("../../vis.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/components/visualize_editor_common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flexParentStyle = (0, _react2.css)({
  flex: '1 1 auto',
  display: 'flex',
  flexDirection: 'column',
  '> *': {
    flexShrink: 0
  }
});
const visEditorCommonStyles = {
  base: euiThemeContext => (0, _react2.css)`
      height: '100%';
      ${flexParentStyle};
      ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
        .visualization {
          // While we are on a small screen the visualization is below the
          // editor. In this cases it needs a minimum height, since it would otherwise
          // maybe end up with 0 height since it just gets the flexbox rest of the screen.
          min-height: calc(${euiThemeContext.euiTheme.size.l} * 10);
        }
      }
      > .visualize {
        height: 100%;
        flex: 1 1 auto;
        display: flex;
        z-index: 0; // Without setting this to 0 you will run into a bug where the filter bar modal is hidden under a tilemap in an iframe: https://github.com/elastic/kibana/issues/16457
      }
    `,
  content: (0, _react2.css)`
    width: 100%;
    z-index: 0;
    ${flexParentStyle};
  `,
  visType: euiThemeContext => (0, _react2.css)({
    '&.visEditor--timelion': {
      '.visEditorSidebar__timelionOptions': {
        flex: '1 1 auto',
        display: 'flex',
        flexDirection: 'column'
      }
    },
    '&.visEditor--vega': {
      '.visEditorSidebar__config': {
        padding: 0,
        display: 'flex',
        flexDirection: 'row',
        overflow: 'hidden',
        minHeight: `calc(${euiThemeContext.euiTheme.size.base} * 15)`,
        [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
          maxHeight: `calc(${euiThemeContext.euiTheme.size.base} * 15)`
        }
      }
    }
  })
};
const VisualizeEditorCommon = ({
  visInstance,
  appState,
  currentAppState,
  isChromeVisible,
  hasUnsavedChanges,
  setHasUnsavedChanges,
  hasUnappliedChanges,
  isEmbeddableRendered,
  onAppLeave,
  originatingApp,
  originatingPath,
  setOriginatingApp,
  visualizationIdFromUrl,
  embeddableId,
  visEditorRef,
  eventEmitter
}) => {
  var _visInstance$vis2, _visInstance$vis4, _visInstance$vis5, _visInstance$vis5$dat, _visInstance$vis6, _visInstance$vis6$typ, _visInstance$vis7, _visInstance$vis7$typ, _visInstance$vis8, _visInstance$vis8$typ, _visInstance$vis9, _visInstance$vis9$typ, _visInstance$vis9$typ2;
  const styles = (0, _use_memo_css.useMemoCss)(visEditorCommonStyles);
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    async function aliasMatchRedirect() {
      const sharingSavedObjectProps = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps;
      if (services.spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'aliasMatch') {
        var _visInstance$vis;
        // We found this object by a legacy URL alias from its old ID; redirect the user to the page with its new ID, preserving any URL hash
        const newObjectId = sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'aliasMatch'
        const newPath = `${(0, _.urlFor)(newObjectId)}${services.history.location.search}`;
        await services.spaces.ui.redirectLegacyUrl({
          path: newPath,
          aliasPurpose: sharingSavedObjectProps.aliasPurpose,
          objectNoun: _i18n.i18n.translate('visualizations.legacyUrlConflict.objectNoun', {
            defaultMessage: '{visName} visualization',
            values: {
              visName: visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis = visInstance.vis) === null || _visInstance$vis === void 0 ? void 0 : _visInstance$vis.type.title
            }
          })
        });
        return;
      }
    }
    aliasMatchRedirect();
  }, [visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis2 = visInstance.vis) === null || _visInstance$vis2 === void 0 ? void 0 : _visInstance$vis2.type.title, services]);
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario
    const currentObjectId = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.id;
    const sharingSavedObjectProps = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps;
    if (services.spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' && currentObjectId) {
      var _visInstance$vis3;
      // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
      // callout with a warning for the user, and provide a way for them to navigate to the other object.
      const otherObjectId = sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'conflict'
      const otherObjectPath = `${(0, _.urlFor)(otherObjectId)}${services.history.location.search}`;
      return services.spaces.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('visualizations.legacyUrlConflict.objectNoun', {
          defaultMessage: '{visName} visualization',
          values: {
            visName: visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis3 = visInstance.vis) === null || _visInstance$vis3 === void 0 ? void 0 : _visInstance$vis3.type.title
          }
        }),
        currentObjectId,
        otherObjectId,
        otherObjectPath
      });
    }
    return null;
  }, [visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis, services, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis4 = visInstance.vis) === null || _visInstance$vis4 === void 0 ? void 0 : _visInstance$vis4.type.title]);
  // Adds a notification for split chart on the new implementation as it is not supported yet
  const chartName = visInstance === null || visInstance === void 0 ? void 0 : visInstance.vis.type.name;
  const isSplitChart = (0, _split_chart_warning_helpers.isSplitChart)(chartName, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis5 = visInstance.vis) === null || _visInstance$vis5 === void 0 ? void 0 : (_visInstance$vis5$dat = _visInstance$vis5.data) === null || _visInstance$vis5$dat === void 0 ? void 0 : _visInstance$vis5$dat.aggs);
  const chartsWithoutSmallMultiples = Object.values(_split_chart_warning_helpers.CHARTS_WITHOUT_SMALL_MULTIPLES);
  const chartNeedsWarning = chartName ? chartsWithoutSmallMultiples.includes(chartName) : false;
  const deprecatedCharts = Object.values(_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED);
  const deprecatedChartsNeedWarning = chartName ? deprecatedCharts.includes(chartName) : false;
  const chartToken = chartName && (chartNeedsWarning || deprecatedChartsNeedWarning) ? _split_chart_warning_helpers.CHARTS_CONFIG_TOKENS[chartName] : undefined;
  const hasLegacyChartsEnabled = chartToken ? (0, _services.getUISettings)().get(chartToken) : true;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `app-container visEditor visEditor--${visInstance === null || visInstance === void 0 ? void 0 : visInstance.vis.type.name}`,
    css: [styles.base, styles.visType],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 5
    }
  }, visInstance && appState && currentAppState && /*#__PURE__*/_react.default.createElement(_visualize_top_nav.VisualizeTopNav, {
    currentAppState: currentAppState,
    hasUnsavedChanges: hasUnsavedChanges,
    setHasUnsavedChanges: setHasUnsavedChanges,
    isChromeVisible: isChromeVisible,
    isEmbeddableRendered: isEmbeddableRendered,
    hasUnappliedChanges: hasUnappliedChanges,
    originatingApp: originatingApp,
    originatingPath: originatingPath,
    setOriginatingApp: setOriginatingApp,
    visInstance: visInstance,
    stateContainer: appState,
    visualizationIdFromUrl: visualizationIdFromUrl,
    embeddableId: embeddableId,
    onAppLeave: onAppLeave,
    eventEmitter: eventEmitter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }), (visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis6 = visInstance.vis) === null || _visInstance$vis6 === void 0 ? void 0 : (_visInstance$vis6$typ = _visInstance$vis6.type) === null || _visInstance$vis6$typ === void 0 ? void 0 : _visInstance$vis6$typ.stage) === 'experimental' && !(visInstance !== null && visInstance !== void 0 && (_visInstance$vis7 = visInstance.vis) !== null && _visInstance$vis7 !== void 0 && (_visInstance$vis7$typ = _visInstance$vis7.type) !== null && _visInstance$vis7$typ !== void 0 && _visInstance$vis7$typ.isDeprecated) && /*#__PURE__*/_react.default.createElement(_experimental_vis_info.ExperimentalVisInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 50
    }
  }), !hasLegacyChartsEnabled && isSplitChart && chartNeedsWarning && chartToken && chartName && /*#__PURE__*/_react.default.createElement(_viz_chart_warning.VizChartWarning, {
    chartType: chartName,
    chartConfigToken: chartToken,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }), (hasLegacyChartsEnabled && deprecatedChartsNeedWarning && chartToken && chartName || (visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis8 = visInstance.vis) === null || _visInstance$vis8 === void 0 ? void 0 : (_visInstance$vis8$typ = _visInstance$vis8.type) === null || _visInstance$vis8$typ === void 0 ? void 0 : _visInstance$vis8$typ.isDeprecated)) && /*#__PURE__*/_react.default.createElement(_viz_chart_warning.VizChartWarning, {
    chartType: chartName,
    chartConfigToken: chartToken !== null && chartToken !== void 0 ? chartToken : undefined,
    mode: "new",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }), visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis9 = visInstance.vis) === null || _visInstance$vis9 === void 0 ? void 0 : (_visInstance$vis9$typ = _visInstance$vis9.type) === null || _visInstance$vis9$typ === void 0 ? void 0 : (_visInstance$vis9$typ2 = _visInstance$vis9$typ.getInfoMessage) === null || _visInstance$vis9$typ2 === void 0 ? void 0 : _visInstance$vis9$typ2.call(_visInstance$vis9$typ, visInstance.vis), getLegacyUrlConflictCallout(), visInstance && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, 'savedVis' in visInstance && visInstance.savedVis.id ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.pageHeading",
    defaultMessage: "{chartName} {chartType} visualization",
    values: {
      chartName: visInstance.savedVis.title,
      chartType: visInstance.vis.type.title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.byValue_pageHeading",
    defaultMessage: "Visualization of type {chartType} embedded into {originatingApp} app",
    values: {
      chartType: visInstance.vis.type.title,
      originatingApp: originatingApp || 'dashboards'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: isChromeVisible ? 'visEditor__content' : 'visualize',
    ref: visEditorRef,
    css: isChromeVisible ? styles.content : _vis.visualizeStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }));
};
exports.VisualizeEditorCommon = VisualizeEditorCommon;