"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeListing = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _contentManagementTabbedTableListView = require("@kbn/content-management-tabbed-table-list-view");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _saved_visualize_utils = require("../../utils/saved_visualize_utils");
var _update_basic_attributes = require("../../utils/saved_objects_utils/update_basic_attributes");
var _check_for_duplicate_title = require("../../utils/saved_objects_utils/check_for_duplicate_title");
var _wizard = require("../../wizard");
var _services = require("../../services");
var _ = require("../..");
var _constants = require("../../../common/constants");
var _utils = require("../utils");
var _get_visualize_list_item_link = require("../utils/get_visualize_list_item_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/components/visualize_listing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const visualizeListingStyles = {
  table: ({
    euiTheme
  }) => (0, _react2.css)`
    .visListingTable__typeImage,
    .visListingTable__typeIcon {
      margin-right: ${euiTheme.size.s};
      position: relative;
      top: -1px;
    }

    .visListingTable__typeImage {
      ${(0, _eui.logicalSizeCSS)(euiTheme.size.base, euiTheme.size.base)};
    }

    .visListingTable__experimentalIcon {
      width: ${euiTheme.size.l};
      vertical-align: middle;
      padding: 0 ${euiTheme.size.s};
      margin-left: ${euiTheme.size.s};
    }
  `,
  calloutLink: (0, _react2.css)`
    text-decoration: underline;
  `
};
const toTableListViewSavedObject = savedObject => {
  var _ref, _ref2, _ref3;
  return {
    id: savedObject.id,
    updatedAt: savedObject.updatedAt,
    managed: savedObject.managed,
    references: savedObject.references,
    type: savedObject.savedObjectType,
    icon: savedObject.icon,
    stage: savedObject.stage,
    savedObjectType: savedObject.savedObjectType,
    typeTitle: savedObject.typeTitle,
    title: (_ref = savedObject.title) !== null && _ref !== void 0 ? _ref : '',
    error: (_ref2 = savedObject.error) !== null && _ref2 !== void 0 ? _ref2 : '',
    editor: savedObject.editor,
    attributes: {
      id: savedObject.id,
      title: (_ref3 = savedObject.title) !== null && _ref3 !== void 0 ? _ref3 : '',
      description: savedObject.description,
      readOnly: savedObject.readOnly,
      error: savedObject.error
    }
  };
};
const useTableListViewProps = (closeNewVisModal, listingLimit) => {
  const {
    services: {
      application,
      history,
      savedObjectsTagging,
      toastNotifications,
      visualizeCapabilities,
      contentManagement,
      http,
      ...startServices
    }
  } = (0, _public.useKibana)();
  const visualizedUserContent = (0, _react.useRef)();
  const createNewVis = (0, _react.useCallback)(() => {
    closeNewVisModal.current = (0, _wizard.showNewVisModal)();
  }, [closeNewVisModal]);
  const editItem = (0, _react.useCallback)(async ({
    attributes: {
      id
    },
    editor = {
      editUrl: ''
    }
  }) => {
    if (!('editApp' in editor || 'editUrl' in editor)) {
      await editor.onEdit(id);
      return;
    }
    const {
      editApp,
      editUrl
    } = editor;
    if (editApp) {
      application.navigateToApp(editApp, {
        path: editUrl
      });
      return;
    }
    // for visualizations the edit and view URLs are the same
    history.push(editUrl);
  }, [application, history]);
  const noItemsFragment = (0, _react.useMemo)(() => (0, _utils.getNoItemsMessage)(createNewVis), [createNewVis]);
  const fetchItems = (0, _react.useCallback)((searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    return (0, _saved_visualize_utils.findListItems)((0, _services.getTypes)(), searchTerm, listingLimit, references, referencesToExclude).then(({
      total,
      hits
    }) => {
      const content = hits.map(toTableListViewSavedObject);
      visualizedUserContent.current = content;
      return {
        total,
        hits: content
      };
    });
  }, [listingLimit]);
  const onContentEditorSave = (0, _react.useCallback)(async args => {
    var _visualizedUserConten;
    const content = (_visualizedUserConten = visualizedUserContent.current) === null || _visualizedUserConten === void 0 ? void 0 : _visualizedUserConten.find(({
      id
    }) => id === args.id);
    if (content) {
      var _args$description;
      await (0, _update_basic_attributes.updateBasicSoAttributes)(content.id, content.type, {
        title: args.title,
        description: (_args$description = args.description) !== null && _args$description !== void 0 ? _args$description : '',
        tags: args.tags
      }, {
        savedObjectsTagging,
        typesService: (0, _services.getTypes)(),
        contentManagement,
        http,
        ...startServices
      });
    }
  }, [savedObjectsTagging, contentManagement, http, startServices]);
  const contentEditorValidators = (0, _react.useMemo)(() => ({
    title: [{
      type: 'warning',
      async fn(value, id) {
        if (id) {
          var _visualizedUserConten2;
          const content = (_visualizedUserConten2 = visualizedUserContent.current) === null || _visualizedUserConten2 === void 0 ? void 0 : _visualizedUserConten2.find(c => c.id === id);
          if (content) {
            try {
              await (0, _check_for_duplicate_title.checkForDuplicateTitle)({
                id,
                title: value,
                lastSavedTitle: content.title
              }, false, false, () => {});
            } catch (e) {
              return _i18n.i18n.translate('visualizations.visualizeListingDeleteErrorTitle.duplicateWarning', {
                defaultMessage: 'Saving "{value}" creates a duplicate title.',
                values: {
                  value
                }
              });
            }
          }
        }
      }
    }]
  }), []);
  const deleteItems = (0, _react.useCallback)(async items => {
    await (0, _update_basic_attributes.deleteListItems)(items, {
      savedObjectsTagging,
      typesService: (0, _services.getTypes)(),
      contentManagement,
      http,
      ...startServices
    }).catch(error => {
      toastNotifications.addError(error, {
        title: _i18n.i18n.translate('visualizations.visualizeListingDeleteErrorTitle', {
          defaultMessage: 'Error deleting visualization'
        })
      });
    });
  }, [contentManagement, http, savedObjectsTagging, startServices, toastNotifications]);
  const props = {
    findItems: fetchItems,
    deleteItems,
    contentEditor: {
      isReadonly: !visualizeCapabilities.save,
      onSave: onContentEditorSave,
      customValidators: contentEditorValidators
    },
    editItem,
    emptyPrompt: noItemsFragment,
    createItem: createNewVis,
    rowItemActions: ({
      managed,
      attributes: {
        readOnly
      }
    }) => !visualizeCapabilities.save || readOnly ? {
      edit: {
        enabled: false,
        reason: managed ? _i18n.i18n.translate('visualizations.managedLegacyVisMessage', {
          defaultMessage: 'Elastic manages this visualisation. Changing it is not possible.'
        }) : _i18n.i18n.translate('visualizations.readOnlyLegacyVisMessage', {
          defaultMessage: "These details can't be edited because this visualization is no longer supported."
        })
      }
    } : undefined
  };
  return props;
};
const VisualizeListing = () => {
  const styles = (0, _use_memo_css.useMemoCss)(visualizeListingStyles);
  const {
    services: {
      application,
      executionContext,
      chrome,
      history,
      stateTransferService,
      dashboardCapabilities,
      uiSettings,
      kbnUrlStateStorage,
      listingViewRegistry,
      serverless
    }
  } = (0, _public.useKibana)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const closeNewVisModal = (0, _react.useRef)(() => {});
  (0, _public.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'list'
  });
  (0, _react.useEffect)(() => {
    if (pathname === '/new') {
      // In case the user navigated to the page via the /visualize/new URL we start the dialog immediately
      closeNewVisModal.current = (0, _wizard.showNewVisModal)({
        onClose: () => {
          // In case the user came via a URL to this page, change the URL to the regular landing page URL after closing the modal
          history.push(_constants.VisualizeConstants.LANDING_PAGE_PATH);
        }
      });
    } else {
      // close modal window if exists
      closeNewVisModal.current();
    }
  }, [history, pathname]);
  (0, _useMount.default)(() => {
    // Reset editor state for all apps if the visualize listing page is loaded.
    stateTransferService.clearEditorState();
    if (serverless !== null && serverless !== void 0 && serverless.setBreadcrumbs) {
      // reset any deeper context breadcrumbs
      // "Visualization" breadcrumb is set automatically by the serverless navigation
      serverless.setBreadcrumbs([]);
    } else {
      chrome.setBreadcrumbs([{
        text: _i18n.i18n.translate('visualizations.visualizeListingBreadcrumbsTitle', {
          defaultMessage: 'Visualize library'
        })
      }]);
    }
    chrome.docTitle.change(_i18n.i18n.translate('visualizations.listingPageTitle', {
      defaultMessage: 'Visualize library'
    }));
  });
  (0, _useUnmount.default)(() => closeNewVisModal.current());
  const getVisualizeListItemLink = (0, _react.useMemo)(() => (0, _get_visualize_list_item_link.getVisualizeListItemLinkFn)(application, kbnUrlStateStorage), [application, kbnUrlStateStorage]);
  const listingLimit = uiSettings.get(_.SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = uiSettings.get(_.SAVED_OBJECTS_PER_PAGE_SETTING);
  const tableViewProps = useTableListViewProps(closeNewVisModal, listingLimit);
  const visualizeLibraryTitle = _i18n.i18n.translate('visualizations.listing.table.listTitle', {
    defaultMessage: 'Visualize library'
  });
  const visualizeTab = (0, _react.useMemo)(() => {
    const calloutMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "visualize-dashboard-flow-prompt",
      id: "visualizations.visualizeListingDashboardFlowDescription",
      defaultMessage: "Building a dashboard? Create and add your visualizations right from the {dashboardApp}.",
      values: {
        dashboardApp: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          className: "visListingCallout__link",
          css: styles.calloutLink,
          onClick: event => {
            event.preventDefault();
            application.navigateToUrl(application.getUrlForApp('dashboards'));
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 397,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visualizations.visualizeListingDashboardAppName",
          defaultMessage: "Dashboard application",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 405,
            columnNumber: 15
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 7
      }
    });
    return {
      title: 'Visualizations',
      id: 'visualizations',
      getTableList: propsFromParent => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardCapabilities.createNew && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        size: "s",
        title: calloutMessage,
        iconType: "info",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 422,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 423,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement("div", {
        css: styles.table,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewTable, (0, _extends2.default)({
        id: "vis"
        // we allow users to create visualizations even if they can't save them
        // for data exploration purposes
        ,
        customTableColumn: (0, _utils.getCustomColumn)(),
        customSortingOptions: (0, _utils.getCustomSortingOptions)(),
        initialPageSize: initialPageSize,
        initialFilter: '',
        entityName: _i18n.i18n.translate('visualizations.listing.table.entityName', {
          defaultMessage: 'visualization'
        }),
        entityNamePlural: _i18n.i18n.translate('visualizations.listing.table.entityNamePlural', {
          defaultMessage: 'visualizations'
        }),
        getOnClickTitle: item => item.attributes.readOnly || item.error ? undefined : () => {
          var _tableViewProps$editI;
          return (_tableViewProps$editI = tableViewProps.editItem) === null || _tableViewProps$editI === void 0 ? void 0 : _tableViewProps$editI.call(tableViewProps, item);
        },
        getDetailViewLink: getVisualizeListItemLink,
        tableCaption: visualizeLibraryTitle
      }, tableViewProps, propsFromParent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 427,
          columnNumber: 13
        }
      }))))
    };
  }, [styles.calloutLink, styles.table, application, dashboardCapabilities.createNew, initialPageSize, visualizeLibraryTitle, tableViewProps, getVisualizeListItemLink]);
  const tabs = (0, _react.useMemo)(() => [visualizeTab, ...Array.from(listingViewRegistry)], [listingViewRegistry, visualizeTab]);
  const {
    activeTab
  } = (0, _reactRouterDom.useParams)();
  return /*#__PURE__*/_react.default.createElement(_contentManagementTabbedTableListView.TabbedTableListView, {
    headingId: "visualizeListingHeading",
    title: visualizeLibraryTitle,
    tabs: tabs,
    activeTabId: activeTab,
    changeActiveTab: id => {
      application.navigateToUrl(`#/${id}`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 474,
      columnNumber: 5
    }
  });
};
exports.VisualizeListing = VisualizeListing;