"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoItemsMessage = exports.getCustomSortingOptions = exports.getCustomColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/utils/get_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getBadge = item => {
  if (item.stage === 'beta') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      className: "visListingTable__betaIcon",
      label: "B",
      title: _i18n.i18n.translate('visualizations.listing.betaTitle', {
        defaultMessage: 'Beta'
      }),
      tooltipContent: _i18n.i18n.translate('visualizations.listing.betaTooltip', {
        defaultMessage: 'This visualization is in beta and is subject to change. The design and code is less mature than official GA ' + 'features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA ' + 'features'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 7
      }
    });
  } else if (item.stage === 'experimental') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      className: "visListingTable__experimentalIcon",
      label: "E",
      title: _i18n.i18n.translate('visualizations.listing.experimentalTitle', {
        defaultMessage: 'Technical preview'
      }),
      tooltipContent: _i18n.i18n.translate('visualizations.listing.experimentalTooltip', {
        defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    });
  }
};
const renderItemTypeIcon = item => {
  if (item.image) {
    return /*#__PURE__*/_react.default.createElement("img", {
      className: "visListingTable__typeImage",
      "aria-hidden": "true",
      alt: "",
      src: item.image,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "visListingTable__typeIcon",
    "aria-hidden": "true",
    type: item.icon || 'empty',
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
};
const getCustomColumn = () => {
  return {
    field: 'typeTitle',
    name: _i18n.i18n.translate('visualizations.listing.table.typeColumnName', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    width: '150px',
    render: (field, record) => {
      if (!record.error) {
        return /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 11
          }
        }, renderItemTypeIcon(record), record.typeTitle, getBadge(record));
      }
      if (!record.typeTitle) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "left",
          content: record.error,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          className: "visListingTable__typeIcon",
          "aria-hidden": "true",
          color: "warning",
          type: "warning",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visualizations.listing.type.unknown",
          defaultMessage: "Unknown",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        })));
      }

      // We should have a way to display generic item errors from TableListViewTable
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "left",
        content: record.error,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        className: "visListingTable__typeIcon",
        "aria-hidden": "true",
        color: "danger",
        type: "error",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.listing.type.error",
        defaultMessage: "Error",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 13
        }
      })));
    }
  };
};
exports.getCustomColumn = getCustomColumn;
const getCustomSortingOptions = () => {
  return {
    field: 'typeTitle',
    sortingLabels: [{
      label: _i18n.i18n.translate('visualizations.listing.table.sortingByTypeColumnNameAsc', {
        defaultMessage: 'Type A-Z'
      }),
      direction: 'asc'
    }, {
      label: _i18n.i18n.translate('visualizations.listing.table.sortingByTypeColumnNameDesc', {
        defaultMessage: 'Type Z-A'
      }),
      direction: 'desc'
    }]
  };
};
exports.getCustomSortingOptions = getCustomSortingOptions;
const getNoItemsMessage = createItem => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "visualizeApp",
  title: /*#__PURE__*/_react.default.createElement("h1", {
    id: "visualizeListingHeading",
    "data-test-subj": "emptyListPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.title",
    defaultMessage: "Create your first visualization",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.description",
    defaultMessage: "You can create different visualizations based on your data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createItem,
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "newItemButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.createButtonLabel",
    defaultMessage: "Create new visualization",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 144,
    columnNumber: 3
  }
});
exports.getNoItemsMessage = getNoItemsMessage;