"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showPublicUrlSwitch = exports.getTopNavConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _public = require("@kbn/saved-objects-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _saved_visualize_utils = require("../../utils/saved_visualize_utils");
var _ = require("../..");
var _constants = require("../../../common/constants");
var _breadcrumbs = require("./breadcrumbs");
var _services = require("../../services");
var _triggers = require("../../triggers");
var _utils = require("./utils");
var _state = require("../../embeddable/state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/visualize_app/utils/get_top_nav_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SavedObjectSaveModalDashboardWithSaveResult = (0, _public2.withSuspense)(_public2.LazySavedObjectSaveModalDashboardWithSaveResult);
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.visualize_v2) return false;
  const visualize = anonymousUserCapabilities.visualize_v2;
  return !!visualize.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;
const getTopNavConfig = ({
  hasUnsavedChanges,
  setHasUnsavedChanges,
  openInspector,
  originatingApp,
  originatingPath,
  setOriginatingApp,
  hasUnappliedChanges,
  visInstance,
  stateContainer,
  visualizationIdFromUrl,
  stateTransfer,
  embeddableId,
  displayEditInLensItem,
  hideLensBadge,
  setNavigateToLens,
  showBadge,
  eventEmitter
}, {
  data,
  application,
  chrome,
  history,
  share,
  setActiveUrl,
  toastNotifications,
  visualizeCapabilities,
  dashboardCapabilities,
  savedObjectsTagging,
  presentationUtil,
  getKibanaVersion,
  serverless,
  ...startServices
}) => {
  var _share$availableInteg;
  const {
    vis,
    embeddableHandler
  } = visInstance;
  const savedVis = visInstance.savedVis;

  /**
   * Called when the user clicks "Save" button.
   */
  async function doSave(saveOptions) {
    var _vis$data$searchSourc;
    const newlyCreated = !Boolean(savedVis.id) || saveOptions.copyOnSave;
    // vis.title was not bound and it's needed to reflect title into visState
    stateContainer.transitions.setVis({
      title: savedVis.title
    });
    savedVis.savedSearchId = vis.data.savedSearchId;
    savedVis.searchSourceFields = (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getSerializedFields();
    savedVis.visState = stateContainer.getState().vis;
    savedVis.uiStateJSON = vis.uiState.toString();
    setHasUnsavedChanges(false);
    try {
      const id = await (0, _saved_visualize_utils.saveVisualization)(savedVis, saveOptions, {
        savedObjectsTagging,
        ...startServices
      });
      if (id) {
        toastNotifications.addSuccess({
          title: _i18n.i18n.translate('visualizations.topNavMenu.saveVisualization.successNotificationText', {
            defaultMessage: `Saved ''{visTitle}''`,
            values: {
              visTitle: savedVis.title
            }
          }),
          'data-test-subj': 'saveVisualizationSuccess'
        });
        chrome.recentlyAccessed.add((0, _.getFullPath)(id), savedVis.title, String(id));
        if (originatingApp && saveOptions.returnToOrigin || saveOptions.dashboardId) {
          if (!embeddableId) {
            const appPath = `${_constants.VisualizeConstants.EDIT_PATH}/${encodeURIComponent(id)}`;

            // Manually insert a new url so the back button will open the saved visualization.
            history.replace(appPath);
            setActiveUrl(appPath);
          }
          const app = originatingApp || 'dashboards';
          let path;
          if (saveOptions.dashboardId) {
            path = saveOptions.dashboardId === 'new' ? '#/create' : `#/view/${saveOptions.dashboardId}`;
          } else if (originatingPath) {
            path = originatingPath;
          }
          if (stateTransfer) {
            stateTransfer.navigateToWithEmbeddablePackage(app, {
              state: {
                type: _.VISUALIZE_EMBEDDABLE_TYPE,
                serializedState: {
                  rawState: {
                    savedObjectId: id
                  }
                },
                embeddableId: saveOptions.copyOnSave ? undefined : embeddableId,
                searchSessionId: data.search.session.getSessionId()
              },
              path
            });
          } else {
            application.navigateToApp(app, {
              path
            });
          }
        } else {
          if (setOriginatingApp && originatingApp && newlyCreated) {
            setOriginatingApp(undefined);
            // remove editor state so the connection is still broken after reload
            stateTransfer.clearEditorState(_constants.VisualizeConstants.APP_ID);
          }
          chrome.docTitle.change(savedVis.lastSavedTitle);
          if (serverless !== null && serverless !== void 0 && serverless.setBreadcrumbs) {
            serverless.setBreadcrumbs((0, _breadcrumbs.getEditServerlessBreadcrumbs)({}, savedVis.lastSavedTitle));
          } else {
            chrome.setBreadcrumbs((0, _breadcrumbs.getEditBreadcrumbs)({}, savedVis.lastSavedTitle));
          }
          if (id !== visualizationIdFromUrl) {
            history.replace({
              ...history.location,
              pathname: `${_constants.VisualizeConstants.EDIT_PATH}/${id}`
            });
          }
        }
      }
      return {
        id
      };
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('visualizations.topNavMenu.saveVisualization.failureNotificationText', {
          defaultMessage: `Error on saving ''{visTitle}''`,
          values: {
            visTitle: savedVis.title
          }
        }),
        text: error.message,
        'data-test-subj': 'saveVisualizationError'
      });
      return {
        error
      };
    }
  }
  const createVisReference = () => {
    if (!originatingApp) {
      return;
    }
    stateTransfer.navigateToWithEmbeddablePackage(originatingApp, {
      state: {
        serializedState: (0, _state.serializeState)({
          serializedVis: vis.serialize()
        }),
        embeddableId,
        type: _.VISUALIZE_EMBEDDABLE_TYPE,
        searchSessionId: data.search.session.getSessionId()
      },
      path: originatingPath
    });
  };
  const navigateToOriginatingApp = () => {
    if (originatingApp) {
      application.navigateToApp(originatingApp, {
        path: originatingPath
      });
    }
  };
  const saveButtonLabel = !savedVis.id && originatingApp ? _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationToLibraryButtonLabel', {
    defaultMessage: 'Save to library'
  }) : originatingApp && savedVis.id ? _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationAsButtonLabel', {
    defaultMessage: 'Save as'
  }) : _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationButtonLabel', {
    defaultMessage: 'Save'
  });
  const showSaveButton = visualizeCapabilities.save || !originatingApp && dashboardCapabilities.showWriteControls;
  const showShareOptions = async (anchorElement, asExport) => {
    if (share) {
      var _visInstance$savedSea, _visInstance$savedSea2, _visInstance$savedSea3, _visInstance$savedSea4, _visInstance$savedSea5, _visInstance$savedSea6;
      const currentState = stateContainer.getState();
      const searchParams = (0, _queryString.parse)(history.location.search);
      const params = {
        visId: savedVis === null || savedVis === void 0 ? void 0 : savedVis.id,
        filters: currentState.filters,
        refreshInterval: undefined,
        timeRange: data.query.timefilter.timefilter.getTime(),
        uiState: currentState.uiState,
        query: currentState.query,
        vis: currentState.vis,
        linked: currentState.linked,
        indexPattern: (_visInstance$savedSea = (_visInstance$savedSea2 = visInstance.savedSearch) === null || _visInstance$savedSea2 === void 0 ? void 0 : (_visInstance$savedSea3 = _visInstance$savedSea2.searchSource) === null || _visInstance$savedSea3 === void 0 ? void 0 : (_visInstance$savedSea4 = _visInstance$savedSea3.getField('index')) === null || _visInstance$savedSea4 === void 0 ? void 0 : _visInstance$savedSea4.id) !== null && _visInstance$savedSea !== void 0 ? _visInstance$savedSea : searchParams.indexPattern,
        savedSearchId: (_visInstance$savedSea5 = (_visInstance$savedSea6 = visInstance.savedSearch) === null || _visInstance$savedSea6 === void 0 ? void 0 : _visInstance$savedSea6.id) !== null && _visInstance$savedSea5 !== void 0 ? _visInstance$savedSea5 : searchParams.savedSearchId
      };
      // TODO: support sharing in by-value mode
      await share.toggleShareContextMenu({
        asExport,
        anchorElement,
        allowShortUrl: Boolean(visualizeCapabilities.createShortUrl),
        shareableUrl: (0, _public3.unhashUrl)(window.location.href),
        objectId: savedVis === null || savedVis === void 0 ? void 0 : savedVis.id,
        objectType: 'visualization',
        objectTypeMeta: {
          title: _i18n.i18n.translate('visualizations.share.shareModal.title', {
            defaultMessage: 'Share this visualization'
          }),
          config: {
            embed: {
              computeAnonymousCapabilities: showPublicUrlSwitch
            },
            integration: {
              export: {
                pdfReports: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('visualizations.exports.pdfReports.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    }),
                    __self: void 0,
                    __source: {
                      fileName: _jsxFileName,
                      lineNumber: 329,
                      columnNumber: 21
                    }
                  }, _i18n.i18n.translate('visualizations.exports.pdfReports.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'URL may change if you upgrade Kibana.'
                  }))
                },
                imageReports: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('visualizations.exports.imageReports.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    }),
                    __self: void 0,
                    __source: {
                      fileName: _jsxFileName,
                      lineNumber: 347,
                      columnNumber: 21
                    }
                  }, _i18n.i18n.translate('visualizations.exports.imageReports.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'URL may change if you upgrade Kibana.'
                  }))
                },
                csvReports: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('visualizations.exports.csvReports.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    }),
                    __self: void 0,
                    __source: {
                      fileName: _jsxFileName,
                      lineNumber: 365,
                      columnNumber: 21
                    }
                  }, _i18n.i18n.translate('visualizations.exports.csvReports.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'URL may change if you upgrade Kibana.'
                  }))
                }
              }
            }
          }
        },
        sharingData: {
          title: (savedVis === null || savedVis === void 0 ? void 0 : savedVis.title) || _i18n.i18n.translate('visualizations.reporting.defaultReportTitle', {
            defaultMessage: 'Visualization [{date}]',
            values: {
              date: (0, _moment.default)().toISOString(true)
            }
          }),
          locatorParams: {
            id: _deeplinksAnalytics.VISUALIZE_APP_LOCATOR,
            version: getKibanaVersion(),
            params
          }
        },
        isDirty: hasUnappliedChanges || hasUnsavedChanges
      });
    }
  };
  const topNavMenu = [...(displayEditInLensItem ? [{
    id: 'goToLens',
    label: _i18n.i18n.translate('visualizations.topNavMenu.goToLensButtonLabel', {
      defaultMessage: 'Edit visualization in Lens'
    }),
    emphasize: false,
    description: _i18n.i18n.translate('visualizations.topNavMenu.goToLensButtonAriaLabel', {
      defaultMessage: 'Go to Lens with your current configuration'
    }),
    className: 'visNavItem__goToLens',
    testId: 'visualizeEditInLensButton',
    ...(showBadge && {
      badge: {
        label: _i18n.i18n.translate('visualizations.tonNavMenu.tryItBadgeText', {
          defaultMessage: 'Try it'
        }),
        color: 'accent'
      }
    }),
    run: async () => {
      var _visInstance$vis$type, _visInstance$vis$type2;
      // lens doesn't support saved searches, should unlink before transition
      if (eventEmitter && visInstance.vis.data.savedSearchId) {
        eventEmitter.emit('unlinkFromSavedSearch', false);
      }
      const navigateToLensConfig = await ((_visInstance$vis$type = (_visInstance$vis$type2 = visInstance.vis.type).navigateToLens) === null || _visInstance$vis$type === void 0 ? void 0 : _visInstance$vis$type.call(_visInstance$vis$type2, vis, data.query.timefilter.timefilter));
      const searchFilters = data.query.filterManager.getAppFilters();
      const searchQuery = data.query.queryString.getQuery();
      const updatedWithMeta = {
        ...navigateToLensConfig,
        embeddableId,
        vizEditorOriginatingAppUrl: (0, _utils.getVizEditorOriginatingAppUrl)(history),
        originatingApp,
        title: (visInstance === null || visInstance === void 0 ? void 0 : visInstance.panelTitle) || vis.title,
        visTypeTitle: vis.type.title,
        description: (visInstance === null || visInstance === void 0 ? void 0 : visInstance.panelDescription) || vis.description,
        panelTimeRange: visInstance === null || visInstance === void 0 ? void 0 : visInstance.panelTimeRange,
        isEmbeddable: Boolean(originatingApp),
        ...(searchFilters && {
          searchFilters
        }),
        ...(searchQuery && {
          searchQuery
        })
      };
      if (navigateToLensConfig) {
        hideLensBadge();
        setNavigateToLens(true);
        (0, _services.getUiActions)().getTrigger(visInstance.vis.type.group === 'aggbased' ? _triggers.AGG_BASED_VISUALIZATION_TRIGGER : _triggers.VISUALIZE_EDITOR_TRIGGER).exec(updatedWithMeta);
      }
    }
  }] : []), {
    id: 'inspector',
    label: _i18n.i18n.translate('visualizations.topNavMenu.openInspectorButtonLabel', {
      defaultMessage: 'inspect'
    }),
    description: _i18n.i18n.translate('visualizations.topNavMenu.openInspectorButtonAriaLabel', {
      defaultMessage: 'Open Inspector for visualization'
    }),
    testId: 'openInspectorButton',
    disableButton() {
      return !embeddableHandler.hasInspector || !embeddableHandler.hasInspector();
    },
    run: openInspector,
    tooltip() {
      if (!embeddableHandler.hasInspector || !embeddableHandler.hasInspector()) {
        return _i18n.i18n.translate('visualizations.topNavMenu.openInspectorDisabledButtonTooltip', {
          defaultMessage: `This visualization doesn't support any inspectors.`
        });
      }
    }
  },
  // Only show the export button if the current user meets the requirements for at least one registered export integration
  ...(Boolean(share === null || share === void 0 ? void 0 : (_share$availableInteg = share.availableIntegrations('visualization', 'export')) === null || _share$availableInteg === void 0 ? void 0 : _share$availableInteg.length) ? [{
    id: 'export',
    iconType: 'download',
    iconOnly: true,
    label: _i18n.i18n.translate('visualizations.topNavMenu.shareVisualizationButtonLabel', {
      defaultMessage: 'export'
    }),
    description: _i18n.i18n.translate('visualizations.topNavMenu.shareVisualizationButtonAriaLabel', {
      defaultMessage: 'Export Visualization'
    }),
    testId: 'exportTopNavButton',
    run: anchorElement => showShareOptions(anchorElement, true),
    // disable the Share button if no action specified and fot byValue visualizations
    disableButton: !share || Boolean(!savedVis.id && originatingApp)
  }] : []), {
    id: 'share',
    iconType: 'share',
    iconOnly: true,
    label: _i18n.i18n.translate('visualizations.topNavMenu.shareVisualizationButtonLabel', {
      defaultMessage: 'share'
    }),
    description: _i18n.i18n.translate('visualizations.topNavMenu.shareVisualizationButtonAriaLabel', {
      defaultMessage: 'Share Visualization'
    }),
    testId: 'shareTopNavButton',
    run: showShareOptions,
    // disable the Share button if no action specified and fot byValue visualizations
    disableButton: !share || Boolean(!savedVis.id && originatingApp)
  }, ...(originatingApp ? [{
    id: 'cancel',
    label: _i18n.i18n.translate('visualizations.topNavMenu.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    emphasize: false,
    description: _i18n.i18n.translate('visualizations.topNavMenu.cancelButtonAriaLabel', {
      defaultMessage: 'Return to the last app without saving changes'
    }),
    testId: 'visualizeCancelAndReturnButton',
    tooltip() {
      if (hasUnappliedChanges || hasUnsavedChanges) {
        return _i18n.i18n.translate('visualizations.topNavMenu.cancelAndReturnButtonTooltip', {
          defaultMessage: 'Discard your changes before finishing'
        });
      }
    },
    run: async () => {
      return navigateToOriginatingApp();
    }
  }] : []), ...(showSaveButton ? [{
    id: 'save',
    iconType: originatingApp ? undefined : 'save',
    label: saveButtonLabel,
    emphasize: !originatingApp,
    description: _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationButtonAriaLabel', {
      defaultMessage: 'Save Visualization'
    }),
    testId: 'visualizeSaveButton',
    disableButton: hasUnappliedChanges,
    tooltip() {
      if (hasUnappliedChanges) {
        return _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationDisabledButtonTooltip', {
          defaultMessage: 'Apply or Discard your changes before saving'
        });
      }
    },
    run: () => {
      const onSave = async ({
        newTitle,
        newCopyOnSave,
        isTitleDuplicateConfirmed,
        onTitleDuplicate,
        newDescription,
        returnToOrigin,
        dashboardId,
        addToLibrary
      }) => {
        const currentTitle = savedVis.title;
        savedVis.title = newTitle;
        embeddableHandler.updateInput({
          title: newTitle
        });
        savedVis.description = newDescription;
        if (savedObjectsTagging) {
          savedVis.tags = selectedTags;
        }

        // If we're adding to a dashboard and not saving to library,
        // we'll want to use a by-value operation
        if (dashboardId && !addToLibrary) {
          const appPath = `${_constants.VisualizeConstants.LANDING_PAGE_PATH}`;

          // Manually insert a new url so the back button will open the saved visualization.
          history.replace(appPath);
          setActiveUrl(appPath);
          stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
            state: {
              serializedState: (0, _state.serializeState)({
                serializedVis: vis.serialize(),
                titles: {
                  title: newTitle,
                  description: newDescription
                }
              }),
              embeddableId,
              type: _.VISUALIZE_EMBEDDABLE_TYPE,
              searchSessionId: data.search.session.getSessionId()
            },
            path: dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`
          });

          // TODO: Saved Object Modal requires `id` to be defined so this is a workaround
          return {
            id: 'true'
          };
        }

        // We're adding the viz to a library so we need to save it and then
        // add to a dashboard if necessary
        const response = await doSave({
          confirmOverwrite: false,
          isTitleDuplicateConfirmed,
          onTitleDuplicate,
          returnToOrigin,
          dashboardId: !!dashboardId ? dashboardId : undefined,
          copyOnSave: newCopyOnSave
        });
        // If the save wasn't successful, put the original values back.
        if (!response.id || response.error) {
          savedVis.title = currentTitle;
        }
        return response;
      };
      let selectedTags = [];
      let tagOptions;
      if (savedObjectsTagging) {
        selectedTags = savedVis.tags || [];
        tagOptions = /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
          initialSelection: selectedTags,
          onTagsSelected: newSelection => {
            selectedTags = newSelection;
          },
          markOptional: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 649,
            columnNumber: 19
          }
        });
      }
      let saveModal;
      if (originatingApp) {
        saveModal = /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalOrigin, {
          documentInfo: savedVis || {
            title: ''
          },
          onSave: onSave,
          options: tagOptions,
          getAppNameFromId: stateTransfer.getAppNameFromId,
          objectType: _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationObjectType', {
            defaultMessage: 'visualization'
          }),
          onClose: () => {},
          originatingApp: originatingApp,
          returnToOriginSwitchLabel: originatingApp && embeddableId ? _i18n.i18n.translate('visualizations.topNavMenu.updatePanel', {
            defaultMessage: 'Update panel on {originatingAppName}',
            values: {
              originatingAppName: stateTransfer.getAppNameFromId(originatingApp)
            }
          }) : undefined,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 663,
            columnNumber: 19
          }
        });
      } else {
        saveModal = /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboardWithSaveResult, {
          documentInfo: {
            id: visualizeCapabilities.save ? savedVis === null || savedVis === void 0 ? void 0 : savedVis.id : undefined,
            title: (savedVis === null || savedVis === void 0 ? void 0 : savedVis.title) || '',
            description: (savedVis === null || savedVis === void 0 ? void 0 : savedVis.description) || ''
          },
          canSaveByReference: Boolean(visualizeCapabilities.save),
          onSave: onSave,
          tagOptions: tagOptions,
          objectType: _i18n.i18n.translate('visualizations.topNavMenu.saveVisualizationObjectType', {
            defaultMessage: 'visualization'
          }),
          onClose: () => {},
          mustCopyOnSaveMessage: savedVis.managed ? _i18n.i18n.translate('visualizations.topNavMenu.mustCopyOnSave', {
            defaultMessage: 'Elastic manages this visualization. Save any changes to a new visualization.'
          }) : undefined,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 690,
            columnNumber: 19
          }
        });
      }
      (0, _public.showSaveModal)(saveModal);
    }
  }] : []), ...(originatingApp ? [{
    id: 'saveAndReturn',
    label: _i18n.i18n.translate('visualizations.topNavMenu.saveAndReturnVisualizationButtonLabel', {
      defaultMessage: 'Save and return'
    }),
    emphasize: true,
    iconType: 'checkInCircleFilled',
    description: _i18n.i18n.translate('visualizations.topNavMenu.saveAndReturnVisualizationButtonAriaLabel', {
      defaultMessage: 'Finish editing visualization and return to the last app'
    }),
    testId: 'visualizesaveAndReturnButton',
    disableButton: hasUnappliedChanges,
    tooltip() {
      if (hasUnappliedChanges) {
        return _i18n.i18n.translate('visualizations.topNavMenu.saveAndReturnVisualizationDisabledButtonTooltip', {
          defaultMessage: 'Apply or Discard your changes before finishing'
        });
      }
    },
    run: async () => {
      if (!(savedVis !== null && savedVis !== void 0 && savedVis.id)) {
        return createVisReference();
      }
      const saveOptions = {
        confirmOverwrite: false,
        returnToOrigin: true
      };
      return doSave(saveOptions);
    }
  }] : [])];
  return topNavMenu;
};
exports.getTopNavConfig = getTopNavConfig;