"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSelection = GroupSelection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _vis_groups_enum = require("../../vis_types/vis_groups_enum");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/wizard/group_selection/group_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const groupSelectionStyles = {
  body: (0, _react2.css)({
    // override EUI specificity
    '.euiModalBody__overflow': {
      padding: '0 !important'
    }
  }),
  visGroups: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: `${euiTheme.size.s} ${euiTheme.size.xl} 0`
  }),
  footer: euiThemeContext => (0, _react2.css)({
    padding: `0 ${euiThemeContext.euiTheme.size.xl} ${euiThemeContext.euiTheme.size.l}`,
    background: euiThemeContext.euiTheme.colors.backgroundBaseFormsPrepend,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      background: euiThemeContext.euiTheme.colors.backgroundBasePlain
    }
  }),
  footerDescriptionList: euiThemeContext => (0, _react2.css)({
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      paddingTop: euiThemeContext.euiTheme.size.l
    }
  }),
  footerDescriptionListTitle: (0, _react2.css)({
    // override EUI specificity
    width: 'auto !important'
  }),
  visGroupCardWrapper: (0, _react2.css)({
    position: 'relative'
  })
};
const legacyTabTitle = _i18n.i18n.translate('visualizations.newVisWizard.legacyTab', {
  defaultMessage: 'Legacy'
});
const tabs = [{
  id: 'recommended',
  label: _i18n.i18n.translate('visualizations.newVisWizard.recommendedTab', {
    defaultMessage: 'Recommended'
  }),
  dataTestSubj: 'groupModalRecommendedTab'
}, {
  id: 'legacy',
  dataTestSubj: 'groupModalLegacyTab',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    "aria-label": legacyTabTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, legacyTabTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visualizations.newVisWizard.legacyTabDescription', {
      defaultMessage: 'Legacy visualizations are scheduled for deprecation in the future.'
    }),
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  })))
}];
const getVisTypesFromGroup = (visTypesRegistry, group) => {
  return visTypesRegistry.getByGroup(group).filter(({
    disableCreate
  }) => !disableCreate);
};
function GroupSelection({
  tab = 'recommended',
  setTab,
  visTypesRegistry,
  ...props
}) {
  const styles = (0, _use_memo_css.useMemoCss)(groupSelectionStyles);
  const visualizeGuideLink = props.docLinks.links.visualize.guide;
  const promotedVisGroups = (0, _react.useMemo)(() => (0, _lodash.orderBy)([...visTypesRegistry.getAliases(), ...visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.PROMOTED)].filter(visDefinition => {
    return !visDefinition.disableCreate;
  }), ['promotion', 'title'], ['asc', 'asc']), [visTypesRegistry]);
  const aggBasedTypes = getVisTypesFromGroup(visTypesRegistry, _vis_groups_enum.VisGroups.AGGBASED);
  const legacyTypes = getVisTypesFromGroup(visTypesRegistry, _vis_groups_enum.VisGroups.LEGACY);
  const shouldDisplayLegacyTab = legacyTypes.length + aggBasedTypes.length;
  const [tsvbProps] = legacyTypes.map(visType => ({
    visType: {
      ...visType,
      icon: visType.name === 'metrics' ? 'visualizeApp' : visType.icon
    },
    onVisTypeSelected: props.onVisTypeSelected,
    key: visType.name
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "groupModalHeader",
    id: "vis-wizard-modal-title",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.title",
    defaultMessage: "Create visualization",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    css: styles.body,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, shouldDisplayLegacyTab && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.visGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }, tabs.map(t => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": t.dataTestSubj,
    isSelected: tab === t.id,
    onClick: () => setTab(t.id),
    key: t.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 17
    }
  }, t.label)))), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.visGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }), tab === 'recommended' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "visNewDialogGroups",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }, promotedVisGroups.map(visType => /*#__PURE__*/_react.default.createElement(VisGroup, {
    visType: visType,
    key: visType.name,
    onVisTypeSelected: props.onVisTypeSelected,
    shouldStretch: visType.name === 'lens',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "visNewDialogGroups",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, tsvbProps ? /*#__PURE__*/_react.default.createElement(VisGroup, (0, _extends2.default)({}, tsvbProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 28
    }
  })) : null, /*#__PURE__*/_react.default.createElement(VisGroup, {
    visType: {
      stage: 'production',
      name: 'aggbased',
      description: _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupDescription', {
        defaultMessage: 'Craft charts using basic aggregations.'
      }),
      icon: 'indexPatternApp',
      title: _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupTitle', {
        defaultMessage: 'Aggregation-based'
      })
    },
    onVisTypeSelected: () => {
      props.showMainDialog(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    visualizeGuideLink: visualizeGuideLink,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  })));
}
const ModalFooter = ({
  visualizeGuideLink
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(groupSelectionStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.footer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "responsiveColumn",
    compressed: true,
    css: styles.footerDescriptionList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    css: styles.footerDescriptionListTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.learnMoreText",
    defaultMessage: "Want to learn more?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: visualizeGuideLink,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.viewDocumentationLink",
    defaultMessage: "View documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  })))));
};
const VisGroup = ({
  visType,
  onVisTypeSelected,
  shouldStretch = false
}) => {
  const onClick = (0, _react.useCallback)(() => {
    onVisTypeSelected(visType);
  }, [onVisTypeSelected, visType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: [shouldStretch ? {
      gridColumn: '1 / -1'
    } : null, groupSelectionStyles.visGroupCardWrapper],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    titleSize: "xs",
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "visTypeTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 11
      }
    }, 'titleInWizard' in visType && visType.titleInWizard ? visType.titleInWizard : visType.title),
    onClick: onClick,
    "data-test-subj": `visType-${visType.name}`,
    "data-vis-stage": !('alias' in visType) ? visType.stage : 'alias',
    "aria-label": `visType-${visType.name}`,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 13
      }
    }, visType.description || ''), /*#__PURE__*/_react.default.createElement("em", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 13
      }
    }, " ", visType.note || '')),
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: visType.icon || 'empty',
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }));
};