"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _dialog_navigation = require("../dialog_navigation");
var _show_saved_object = require("./show_saved_object");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/wizard/search_selection/search_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class SearchSelection extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "fixedPageSize", 8);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: "vis-wizard-modal-title",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newVisWizard.newVisTypeTitle",
      defaultMessage: "New {visTypeName}",
      values: {
        visTypeName: this.props.visType.title
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    }), ' ', "/", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newVisWizard.chooseSourceTitle",
      defaultMessage: "Choose a source",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_dialog_navigation.DialogNavigation, {
      goBack: this.props.goBack,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
      key: "searchSavedObjectFinder",
      id: "visSearchSelection",
      onChoose: this.props.onSearchSelected,
      showFilter: true,
      noItemsMessage: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.notFoundLabel', {
        defaultMessage: 'No matching indices or Discover sessions found.'
      }),
      savedObjectMetaData: [{
        type: 'search',
        getIconForSavedObject: () => 'discoverApp',
        name: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.savedObjectType.search', {
          defaultMessage: 'Discover session'
        }),
        // ignore the saved searches that have text-based languages queries
        includeFields: ['isTextBasedQuery', 'usesAdHocDataView'],
        showSavedObject: _show_saved_object.showSavedObject
      }, {
        type: 'index-pattern',
        getIconForSavedObject: () => 'indexPatternApp',
        name: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.savedObjectType.dataView', {
          defaultMessage: 'Data view'
        })
      }],
      fixedPageSize: this.fixedPageSize,
      services: {
        contentClient: this.props.contentClient,
        uiSettings: this.props.uiSettings
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    })));
  }
}
exports.SearchSelection = SearchSelection;