"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlackAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SlackAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const toArray = (0, _lodash.get)(props, 'to');
    this.to = (0, _lodash.isArray)(toArray) ? toArray : toArray && [toArray];
    const defaultText = _i18n.i18n.translate('xpack.watcher.models.slackAction.defaultText', {
      defaultMessage: 'Watch [{context}] has exceeded the threshold',
      values: {
        context: '{{ctx.metadata.name}}'
      }
    });
    this.text = (0, _lodash.get)(props, 'text', props.ignoreDefaults ? null : defaultText);
  }
  validate() {
    // Currently no validation required
    const errors = {
      to: [],
      text: []
    };
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    const to = this.to && this.to.length > 0 ? this.to : undefined;
    const message = this.text || to ? {
      text: this.text,
      to
    } : {};
    Object.assign(result, {
      to,
      text: this.text,
      slack: {
        message
      }
    });
    return result;
  }
  get simulateMessage() {
    const toList = this.to && this.to.join(', ');
    return _i18n.i18n.translate('xpack.watcher.models.slackAction.simulateMessage', {
      defaultMessage: 'Sample Slack message sent {toList}.',
      values: {
        toList: toList ? `to ${toList}` : ''
      }
    });
  }
  get simulateFailMessage() {
    const toList = this.to && this.to.join(', ');
    return _i18n.i18n.translate('xpack.watcher.models.slackAction.simulateFailMessage', {
      defaultMessage: 'Failed to send sample Slack message {toList}.',
      values: {
        toList: toList ? `to ${toList}` : ''
      }
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new SlackAction(upstreamAction);
  }
}
exports.SlackAction = SlackAction;
(0, _defineProperty2.default)(SlackAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.slackAction.TypeName', {
  defaultMessage: 'Slack'
}));
(0, _defineProperty2.default)(SlackAction, "iconClass", 'logoSlack');
(0, _defineProperty2.default)(SlackAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.slackAction.selectMessageText', {
  defaultMessage: 'Send a message to a Slack user or channel.'
}));
(0, _defineProperty2.default)(SlackAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.slackAction.simulateButtonLabel', {
  defaultMessage: 'Send a sample message'
}));