"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnknownAction = void 0;
var _lodash = require("lodash");
var _base_action = require("./base_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UnknownAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    this.actionJson = (0, _lodash.get)(props, 'actionJson');
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      actionJson: this.actionJson
    });
    return result;
  }
  static fromUpstreamJson(upstreamAction) {
    return new UnknownAction(upstreamAction);
  }
}
exports.UnknownAction = UnknownAction;