"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.comparators = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const comparators = exports.comparators = {
  [_constants.COMPARATORS.GREATER_THAN]: {
    text: _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.comparators.isAboveLabel', {
      defaultMessage: 'Is above'
    }),
    value: _constants.COMPARATORS.GREATER_THAN,
    requiredValues: 1
  },
  [_constants.COMPARATORS.GREATER_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.comparators.isAboveOrEqualsLabel', {
      defaultMessage: 'Is above or equals'
    }),
    value: _constants.COMPARATORS.GREATER_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [_constants.COMPARATORS.LESS_THAN]: {
    text: _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.comparators.isBelowLabel', {
      defaultMessage: 'Is below'
    }),
    value: _constants.COMPARATORS.LESS_THAN,
    requiredValues: 1
  },
  [_constants.COMPARATORS.LESS_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.comparators.isBelowOrEqualsLabel', {
      defaultMessage: 'Is below or equals'
    }),
    value: _constants.COMPARATORS.LESS_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [_constants.COMPARATORS.BETWEEN]: {
    text: _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.comparators.isBetweenLabel', {
      defaultMessage: 'Is between'
    }),
    value: _constants.COMPARATORS.BETWEEN,
    requiredValues: 2
  }
};