"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchStatus = void 0;
var _lodash = require("lodash");
var _get_moment = require("../../../../common/lib/get_moment");
var _action_status = require("../action_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WatchStatus {
  constructor(props = {}) {
    this.id = (0, _lodash.get)(props, 'id');
    this.state = (0, _lodash.get)(props, 'state');
    this.comment = (0, _lodash.get)(props, 'comment');
    this.isActive = (0, _lodash.get)(props, 'isActive');
    this.lastExecution = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastExecution'));
    this.lastChecked = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastChecked'));
    this.lastMetCondition = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastMetCondition'));
    const actionStatuses = (0, _lodash.get)(props, 'actionStatuses', []);
    this.actionStatuses = actionStatuses.map(actionStatus => _action_status.ActionStatus.fromUpstreamJson(actionStatus));
  }
  static fromUpstreamJson(upstreamWatchStatus) {
    return new WatchStatus(upstreamWatchStatus);
  }
}
exports.WatchStatus = WatchStatus;