"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonWatchEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _execute_details = require("../../../../models/execute_details");
var _get_action_type = require("../../../../../../common/lib/get_action_type");
var _constants = require("../../../../../../common/constants");
var _json_watch_edit_form = require("./json_watch_edit_form");
var _json_watch_edit_simulate = require("./json_watch_edit_simulate");
var _watch_context = require("../../watch_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/json_watch_edit/json_watch_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WATCH_EDIT_TAB = 'watchEditTab';
const WATCH_SIMULATE_TAB = 'watchSimulateTab';
const WATCH_TABS = [{
  id: WATCH_EDIT_TAB,
  name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.editTabLabel', {
    defaultMessage: 'Edit'
  })
}, {
  id: WATCH_SIMULATE_TAB,
  name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.simulateTabLabel', {
    defaultMessage: 'Simulate'
  })
}];
const EXECUTE_DETAILS_INITIAL_STATE = {
  triggeredTimeValue: 0,
  triggeredTimeUnit: _constants.TIME_UNITS.SECOND,
  scheduledTimeValue: 0,
  scheduledTimeUnit: _constants.TIME_UNITS.SECOND,
  ignoreCondition: false
};
function getActions(watch) {
  const actions = watch.watch && watch.watch.actions || {};
  return Object.keys(actions).map(actionKey => ({
    actionId: actionKey,
    type: (0, _get_action_type.getActionType)(actions[actionKey]),
    actionMode: _constants.ACTION_MODES.SIMULATE
  }));
}
function getActionModes(items) {
  const result = items.reduce((itemsAccum, item) => {
    if (item.actionId) {
      itemsAccum[item && item.actionId] = item.actionMode;
    }
    return itemsAccum;
  }, {});
  return result;
}
const JsonWatchEdit = ({
  pageTitle
}) => {
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const watchActions = getActions(watch);
  // hooks
  const [selectedTab, setSelectedTab] = (0, _react.useState)(WATCH_EDIT_TAB);
  const [executeDetails, setExecuteDetails] = (0, _react.useState)(new _execute_details.ExecuteDetails({
    ...EXECUTE_DETAILS_INITIAL_STATE,
    actionModes: getActionModes(watchActions)
  }));
  const executeWatchErrors = executeDetails.validate();
  const hasExecuteWatchErrors = !!Object.keys(executeWatchErrors).find(errorKey => executeWatchErrors[errorKey].length >= 1);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 20
      }
    }, pageTitle),
    bottomBorder: true,
    tabs: WATCH_TABS.map((tab, index) => ({
      onClick: () => {
        setSelectedTab(tab.id);
        setExecuteDetails(new _execute_details.ExecuteDetails({
          ...executeDetails,
          actionModes: getActionModes(watchActions)
        }));
      },
      isSelected: tab.id === selectedTab,
      key: index,
      'data-test-subj': 'tab',
      label: tab.name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }), selectedTab === WATCH_SIMULATE_TAB && /*#__PURE__*/_react.default.createElement(_json_watch_edit_simulate.JsonWatchEditSimulate, {
    executeDetails: executeDetails,
    setExecuteDetails: details => setExecuteDetails(details),
    executeWatchErrors: executeWatchErrors,
    hasExecuteWatchErrors: hasExecuteWatchErrors,
    watchActions: watchActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }), selectedTab === WATCH_EDIT_TAB && /*#__PURE__*/_react.default.createElement(_json_watch_edit_form.JsonWatchEditForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 42
    }
  }));
};
exports.JsonWatchEdit = JsonWatchEdit;