"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonWatchEditForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _shared_imports = require("../../../../shared_imports");
var _serialization = require("../../../../../../common/lib/serialization");
var _components = require("../../../../components");
var _watch_edit_actions = require("../../watch_edit_actions");
var _watch_context = require("../../watch_context");
var _navigation = require("../../../../lib/navigation");
var _request_flyout = require("../request_flyout");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/json_watch_edit/json_watch_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useXJsonMode
} = _shared_imports.XJson;
const JsonWatchEditForm = () => {
  const {
    links: {
      putWatchApiUrl
    },
    toasts
  } = (0, _app_context.useAppContext)();
  const {
    watch,
    setWatchProperty
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(watch.watchString);
  const {
    errors
  } = watch.validate();
  const hasErrors = !!Object.keys(errors).find(errorKey => errors[errorKey].length >= 1);
  const [validationError, setValidationError] = (0, _react.useState)(null);
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const [serverError, setServerError] = (0, _react.useState)(null);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const hasActionErrors = !!validationError;
  const invalidActionMessage = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.actionValidationErrorMessage', {
    defaultMessage: 'Invalid watch actions'
  });
  const jsonErrors = {
    ...errors,
    json: hasActionErrors ? [...errors.json, invalidActionMessage] : [...errors.json]
  };
  (0, _react.useEffect)(() => {
    if (errors.json.length === 0) {
      setWatchProperty('watch', JSON.parse(watch.watchString));
    }
  }, [setWatchProperty, errors, watch]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: hasActionErrors,
    error: validationError ? validationError : [],
    "data-test-subj": "jsonWatchForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, serverError && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.json.saveWatchErrorTitle",
      defaultMessage: "Error saving watch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }),
    error: serverError,
    "data-test-subj": "sectionError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "watchName",
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.watchNameLabel', {
      defaultMessage: 'Name (optional)'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "watchName",
    name: "name",
    value: watch.name || '',
    "data-test-subj": "nameInput",
    onChange: e => {
      const watchName = e.target.value;
      setWatchProperty('name', watchName);
    },
    onBlur: () => {
      if (!watch.name) {
        setWatchProperty('name', '');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchId",
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.watchIDLabel', {
      defaultMessage: 'ID'
    }),
    errorKey: "id",
    isShowingErrors: hasErrors && watch.id !== undefined,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "id",
    name: "id",
    "data-test-subj": "idInput",
    value: watch.id || '',
    readOnly: !watch.isNew,
    onChange: e => {
      setWatchProperty('id', e.target.value);
    },
    onBlur: () => {
      if (!watch.id) {
        setWatchProperty('id', '');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchJson",
    label: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.watchJsonLabel', {
      defaultMessage: 'Watch JSON'
    }), ' ', "(", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: putWatchApiUrl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.watchJsonDocLink', {
      defaultMessage: 'API syntax'
    })), ")"),
    errorKey: "json",
    isShowingErrors: hasErrors || hasActionErrors,
    fullWidth: true,
    errors: jsonErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: xJson,
    "data-test-subj": "jsonEditor",
    height: 500,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.form.watchJsonAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    onChange: xjson => {
      if (validationError) {
        setValidationError(null);
      }
      setXJson(xjson);
      // Keep the watch in sync with the editor content
      setWatchProperty('watchString', convertToJson(xjson));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saveWatchButton",
    fill: true,
    color: "success",
    type: "submit",
    iconType: "check",
    isLoading: isSaving,
    isDisabled: hasErrors,
    onClick: async () => {
      setIsSaving(true);
      const savedWatch = await (0, _watch_edit_actions.onWatchSave)(watch, toasts);
      if (savedWatch && savedWatch.error) {
        const {
          data
        } = savedWatch.error;
        setIsSaving(false);
        if (data && data.error === 'validation') {
          return setValidationError(data.message);
        }
        return setServerError(savedWatch.error);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, watch.isNew ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.createButtonLabel",
    defaultMessage: "Create watch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.saveButtonLabel",
    defaultMessage: "Save watch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "btnCancelWatch",
    onClick: () => (0, _navigation.goToWatchList)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsRequestVisible(!isRequestVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.hideRequestButtonLabel",
    defaultMessage: "Hide request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.showRequestButtonLabel",
    defaultMessage: "Show request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }))))), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    id: watch.id,
    payload: (0, _serialization.serializeJsonWatch)(watch.name, watch.watch),
    close: () => setIsRequestVisible(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }) : null);
};
exports.JsonWatchEditForm = JsonWatchEditForm;