"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggingActionFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/action_fields/logging_action_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LoggingActionFields = ({
  action,
  editAction,
  errors,
  hasErrors
}) => {
  const {
    text
  } = action;
  return /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "loggingText",
    errorKey: "text",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && text !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.loggingAction.logTextFieldLabel', {
      defaultMessage: 'Log text'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "text",
    value: text || '',
    "data-test-subj": "loggingTextInput",
    onChange: e => {
      editAction({
        key: 'text',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!text) {
        editAction({
          key: 'text',
          value: ''
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.LoggingActionFields = LoggingActionFields;