"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchActionsDropdown = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _action = require("../../../../models/action");
var _constants = require("../../../../../../common/constants");
var _watch_context = require("../../watch_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/threshold_watch_action_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  watcherTresholdActionContextMenuItem: (0, _react.css)`
    align-self: center;
  `
};
const disabledMessage = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.actions.disabledOptionLabel', {
  defaultMessage: 'Disabled. Configure your elasticsearch.yml.'
});
const WatchActionsDropdown = ({
  settings,
  isLoading
}) => {
  const {
    addAction
  } = (0, _react2.useContext)(_watch_context.WatchContext);
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react2.useState)(false);
  const allActionTypes = _action.Action.getActionTypes();
  const actions = Object.entries(allActionTypes).map(([type, {
    typeName,
    iconClass,
    selectMessage
  }]) => {
    const isEnabled = settings && settings.actionTypes && settings.actionTypes[type] && typeof settings.actionTypes[type].enabled !== 'undefined' ? settings.actionTypes[type].enabled : true;
    return {
      type,
      typeName,
      iconClass,
      selectMessage,
      isEnabled
    };
  });
  const button = /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addWatchActionButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setIsPopOverOpen(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.actions.addActionButtonLabel",
    defaultMessage: "Add action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    id: "watchActionPanel",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    items: actions.map((action, index) => {
      const isActionDisabled = action.type === _constants.ACTION_TYPES.EMAIL && !action.isEnabled; // Currently can only fully verify email action
      const description = isActionDisabled ? disabledMessage : action.selectMessage;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
        key: `${action.type}-${index}`,
        disabled: isActionDisabled,
        "data-test-subj": `${action.type}ActionButton`,
        onClick: () => {
          addAction({
            type: action.type,
            defaults: {
              isNew: true
            }
          });
          setIsPopOverOpen(false);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: styles.watcherTresholdActionContextMenuItem,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: action.iconClass,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      }, action.typeName), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 21
        }
      }, description)))));
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
};
exports.WatchActionsDropdown = WatchActionsDropdown;