"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchActionsPanel = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _api = require("../../../../lib/api");
var _threshold_watch_action_dropdown = require("./threshold_watch_action_dropdown");
var _threshold_watch_action_accordion = require("./threshold_watch_action_accordion");
var _watch_context = require("../../watch_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_edit_page/components/threshold_watch_edit/threshold_watch_action_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  watcherThresholdActionDropdownContainer: (0, _react.css)`
    justify-content: flex-end;
    flex-direction: row;
  `
};
const WatchActionsPanel = ({
  actionErrors
}) => {
  const {
    watch
  } = (0, _react2.useContext)(_watch_context.WatchContext);
  const {
    data: settings,
    isLoading
  } = (0, _api.useLoadSettings)();
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "watchActionsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.actions.title', {
    defaultMessage: 'Perform {watchActionsCount, plural, one{# action} other {# actions}} when condition is met',
    values: {
      watchActionsCount: watch.actions.length
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.watcherThresholdActionDropdownContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_threshold_watch_action_dropdown.WatchActionsDropdown, {
    settings: settings,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_threshold_watch_action_accordion.WatchActionsAccordion, {
    settings: settings,
    actionErrors: actionErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.WatchActionsPanel = WatchActionsPanel;