"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchListPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _components = require("../../components");
var _api = require("../../lib/api");
var _navigation = require("../../lib/navigation");
var _app_context = require("../../app_context");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/watcher/public/application/sections/watch_list_page/watch_list_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * EuiMemoryTable relies on referential equality of a column's name field when sorting by that column.
 * Therefore, we want the JSX elements preserved through renders.
 */
const stateColumnHeader = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.stateHeader.tooltipText', {
    defaultMessage: 'Active, inactive, or error.'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.stateHeader', {
  defaultMessage: 'State'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  size: "s",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 7
  }
})));
const conditionLastMetHeader = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.lastFiredHeader.tooltipText', {
    defaultMessage: `The last time the condition was met and action taken.`
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.lastFiredHeader', {
  defaultMessage: 'Condition last met'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  size: "s",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 7
  }
})));
const lastCheckedHeader = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.lastTriggeredHeader.tooltipText', {
    defaultMessage: `The last time the condition was checked.`
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.lastTriggeredHeader', {
  defaultMessage: 'Last checked'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  size: "s",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 7
  }
})));
const commentHeader = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.commentHeader.tooltipText', {
    defaultMessage: 'Whether any actions have been acknowledged, throttled, or failed to execute.'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.commentHeader', {
  defaultMessage: 'Comment'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  size: "s",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 7
  }
})));
const WatchListPage = () => {
  // hooks
  const {
    setBreadcrumbs,
    history,
    links: {
      watcherGettingStartedUrl
    }
  } = (0, _app_context.useAppContext)();
  const [query, setQuery] = (0, _react.useState)('');
  const [queryError, setQueryError] = (0, _react.useState)(null);
  const [selection, setSelection] = (0, _react.useState)([]);
  const [watchesToDelete, setWatchesToDelete] = (0, _react.useState)([]);
  // Filter out deleted watches on the client, because the API will return 200 even though some watches
  // may not really be deleted until after they're done firing and this could take some time.
  const [deletedWatches, setDeletedWatches] = (0, _react.useState)([]);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: _constants.PAGINATION.initialPageSize
  });
  (0, _react.useEffect)(() => {
    setBreadcrumbs([_breadcrumbs.listBreadcrumb]);
  }, [setBreadcrumbs]);
  const {
    isLoading: isWatchesLoading,
    data: watches,
    error
  } = (0, _api.useLoadWatches)(_constants.REFRESH_INTERVALS.WATCH_LIST);
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const availableWatches = (0, _react.useMemo)(() => watches ? watches.filter(watch => !deletedWatches.includes(watch.id)) : undefined, [watches, deletedWatches]);
  const watcherDescriptionText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchList.subhead",
    defaultMessage: "Watch for changes or anomalies in your data and take action if needed.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  });
  const createWatchContextMenu = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "createWatchPanel",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "createWatchButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsPopOverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchList.createWatchButtonLabel",
      defaultMessage: "Create",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [_constants.WATCH_TYPES.THRESHOLD, _constants.WATCH_TYPES.JSON].map(watchType => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: watchType,
        "data-test-subj": `${watchType}WatchCreateLink`,
        onClick: () => {
          setIsPopOverOpen(false);
          const navigate = watchType === _constants.WATCH_TYPES.THRESHOLD ? _navigation.goToCreateThresholdAlert : _navigation.goToCreateAdvancedWatch;
          navigate();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 13
        }
      }, watchType === _constants.WATCH_TYPES.THRESHOLD ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.createThresholdAlertButtonLabel",
        defaultMessage: "Create threshold alert",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.createThresholdAlertButtonTooltip",
        defaultMessage: "Send an alert on a specified condition.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 23
        }
      })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.createAdvancedWatchButtonLabel",
        defaultMessage: "Create advanced watch",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.createAdvancedWatchTooltip",
        defaultMessage: "Set up a custom watch in JSON.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 23
        }
      })))));
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }));
  if (isWatchesLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchList.loadingWatchesDescription",
      defaultMessage: "Loading watches\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 11
      }
    })));
  }
  const errorCode = (0, _components.getPageErrorCode)(error);
  if (errorCode) {
    return /*#__PURE__*/_react.default.createElement(_components.PageError, {
      errorCode: errorCode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 12
      }
    });
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.errorTitle",
        defaultMessage: "Error loading watches",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 11
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 7
      }
    });
  }
  if (availableWatches && availableWatches.length === 0) {
    const emptyPromptBody = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 9
      }
    }, watcherDescriptionText, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: watcherGettingStartedUrl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchList.watcherLearnMoreLinkText",
      defaultMessage: "Learn more.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 13
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.emptyPromptTitle",
        defaultMessage: "You don\u2019t have any watches yet",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 13
        }
      })),
      body: emptyPromptBody,
      actions: createWatchContextMenu,
      "data-test-subj": "emptyPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 7
      }
    });
  }
  let content;
  if (availableWatches) {
    const columns = [{
      field: 'id',
      name: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.idHeader', {
        defaultMessage: 'ID'
      }),
      sortable: true,
      truncateText: false,
      render: id => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
          "data-test-subj": `watchIdColumn-${id}`
        }, (0, _public.reactRouterNavigate)(history, `/watches/watch/${id}/status`), {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 327,
            columnNumber: 13
          }
        }), id);
      }
    }, {
      field: 'name',
      name: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.nameHeader', {
        defaultMessage: 'Name'
      }),
      render: (name, item) => {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": `watchNameColumn-${item.id}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 342,
            columnNumber: 18
          }
        }, name);
      },
      sortable: true,
      truncateText: false
    }, {
      field: 'watchStatus.state',
      name: stateColumnHeader,
      sortable: true,
      width: '130px',
      render: state => /*#__PURE__*/_react.default.createElement(_components.WatchStateBadge, {
        state: state,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 36
        }
      })
    }, {
      field: 'watchStatus.lastMetCondition',
      name: conditionLastMetHeader,
      sortable: true,
      truncateText: true,
      width: '160px',
      render: lastMetCondition => {
        return lastMetCondition ? lastMetCondition.fromNow() : lastMetCondition;
      }
    }, {
      field: 'watchStatus.lastChecked',
      name: lastCheckedHeader,
      sortable: true,
      truncateText: true,
      width: '160px',
      render: lastChecked => {
        return lastChecked ? lastChecked.fromNow() : lastChecked;
      }
    }, {
      field: 'watchStatus.comment',
      name: commentHeader,
      sortable: true,
      truncateText: true
    }, {
      name: _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.actionHeader', {
        defaultMessage: 'Actions'
      }),
      width: '75px',
      actions: [{
        render: watch => {
          const label = _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.actionEditTooltipLabel', {
            defaultMessage: 'Edit'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            delay: "long",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 393,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
            isDisabled: watch.isSystemWatch,
            "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.actionEditAriaLabel', {
              defaultMessage: "Edit watch ''{name}''",
              values: {
                name: watch.name
              }
            }),
            iconType: "pencil",
            color: "primary"
          }, (0, _public.reactRouterNavigate)(history, `/watches/watch/${watch.id}/edit`), {
            "data-test-subj": "editWatchButton",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 394,
              columnNumber: 19
            }
          })));
        }
      }, {
        render: watch => {
          const label = _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.actionDeleteTooltipLabel', {
            defaultMessage: 'Delete'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            delay: "long",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 419,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            isDisabled: watch.isSystemWatch,
            "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.actionDeleteAriaLabel', {
              defaultMessage: "Delete watch ''{name}''",
              values: {
                name: watch.name
              }
            }),
            iconType: "trash",
            color: "danger",
            onClick: () => {
              setWatchesToDelete([watch.id]);
            },
            "data-test-subj": "deleteWatchButton",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 420,
              columnNumber: 19
            }
          }));
        }
      }]
    }];
    const selectionConfig = {
      onSelectionChange: setSelection,
      selectable: watch => !watch.isSystemWatch,
      selectableMessage: selectable => !selectable ? _i18n.i18n.translate('xpack.watcher.sections.watchList.watchTable.disabledWatchTooltipText', {
        defaultMessage: 'This watch is read-only'
      }) : ''
    };
    const handleOnChange = ({
      queryText,
      error: searchError
    }) => {
      if (!searchError) {
        setQuery(queryText);
        setQueryError(null);
      } else {
        setQueryError(searchError.message);
      }
    };
    const searchConfig = {
      onChange: handleOnChange,
      query,
      box: {
        incremental: true
      },
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "btnDeleteWatches",
        onClick: () => {
          setWatchesToDelete(selection.map(selected => selected.id));
        },
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 472,
          columnNumber: 11
        }
      }, selection.length > 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.deleteMultipleWatchesButtonLabel",
        defaultMessage: "Delete watches",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 480,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.deleteSingleWatchButtonLabel",
        defaultMessage: "Delete watch",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 485,
          columnNumber: 15
        }
      })) : undefined,
      toolsRight: createWatchContextMenu
    };
    content = /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "watchesTableContainer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 496,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      onTableChange: ({
        page: {
          index,
          size
        }
      }) => setPagination({
        pageIndex: index,
        pageSize: size
      }),
      items: availableWatches,
      itemId: "id",
      columns: columns,
      search: searchConfig,
      pagination: {
        ..._constants.PAGINATION,
        pageIndex: pagination.pageIndex,
        pageSize: pagination.pageSize
      },
      sorting: {
        sort: {
          field: 'name',
          direction: 'asc'
        }
      },
      selection: selectionConfig,
      childrenBetween: queryError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "watcherListSearchError",
        iconType: "warning",
        color: "danger",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchList.watchTable.errorOnSearch",
          defaultMessage: "Invalid search: {queryError}",
          values: {
            queryError
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 525,
            columnNumber: 21
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 520,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 532,
          columnNumber: 17
        }
      })),
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchList.watchTable.noWatchesMessage",
        defaultMessage: "No watches to show",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 537,
          columnNumber: 13
        }
      }),
      rowProps: () => ({
        'data-test-subj': 'row'
      }),
      cellProps: () => ({
        'data-test-subj': 'cell'
      }),
      "data-test-subj": "watchesTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchList.header",
      defaultMessage: "Watcher",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 559,
        columnNumber: 13
      }
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: watcherGettingStartedUrl,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 567,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchList.watcherGettingStartedDocsLinkText",
      defaultMessage: "Watcher docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 573,
        columnNumber: 13
      }
    }))],
    description: watcherDescriptionText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.DeleteWatchesModal, {
    callback: deleted => {
      if (deleted) {
        setDeletedWatches([...deletedWatches, ...watchesToDelete]);
      }
      setWatchesToDelete([]);
    },
    watchesToDelete: watchesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 7
    }
  }), content);
};
exports.WatchListPage = WatchListPage;