/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.watcher_bundle_jsonpfunction=self.watcher_bundle_jsonpfunction||[]).push([[323],{323:(e,t,a)=>{"use strict";a.d(t,{renderApp:()=>Qt});var s=a(286),i=a.n(s),n=a(874),r=a(409),o=a(744),l=a(482),c=a(493),u=a(193),d=a(700),h=a(8),g=a(879);const m={text:h.i18n.translate("xpack.watcher.breadcrumb.listLabel",{defaultMessage:"Watcher"}),href:"/watches"},p={text:h.i18n.translate("xpack.watcher.breadcrumb.createLabel",{defaultMessage:"Create"})},x={text:h.i18n.translate("xpack.watcher.breadcrumb.editLabel",{defaultMessage:"Edit"})},w={text:h.i18n.translate("xpack.watcher.breadcrumb.statusLabel",{defaultMessage:"Status"})};class Settings{constructor(e){this.actionTypes=e.actionTypes}static fromUpstreamJson(e){const t=e.action_types;return new Settings({actionTypes:t})}}var f=a(915),y=a(79),j=a(770),b=a.n(j),E=a(319),T=a(472);class BaseAction{constructor(e={}){this.id=(0,j.get)(e,"id"),this.type=(0,j.get)(e,"type"),this.isNew=(0,j.get)(e,"isNew",!1)}get upstreamJson(){return{id:this.id,type:this.type}}get typeName(){return this.constructor.typeName}get iconClass(){return this.constructor.iconClass}get selectMessage(){return this.constructor.selectMessage}get simulateMessage(){return h.i18n.translate("xpack.watcher.models.baseAction.simulateMessage",{defaultMessage:"Action {id} simulated successfully",values:{id:this.id}})}get simulatePrompt(){return this.constructor.simulatePrompt}}(0,f.default)(BaseAction,"typeName",h.i18n.translate("xpack.watcher.models.baseAction.typeName",{defaultMessage:"Action"})),(0,f.default)(BaseAction,"iconClass","apps"),(0,f.default)(BaseAction,"selectMessage",h.i18n.translate("xpack.watcher.models.baseAction.selectMessageText",{defaultMessage:"Perform an action."})),(0,f.default)(BaseAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.baseAction.simulateButtonLabel",{defaultMessage:"Simulate this action now"}));class EmailAction extends BaseAction{constructor(e={}){super(e);const t=(0,j.get)(e,"to");this.to=(0,j.isArray)(t)?t:t&&[t];const a=h.i18n.translate("xpack.watcher.models.emailAction.defaultSubjectText",{defaultMessage:"Watch [{context}] has exceeded the threshold",values:{context:"{{ctx.metadata.name}}"}});this.subject=(0,j.get)(e,"subject",e.ignoreDefaults?null:a),this.body=(0,j.get)(e,"body")}validate(){const e={to:[]};return this.to&&this.to.length||e.to.push(h.i18n.translate("xpack.watcher.watchActions.email.emailRecipientIsRequiredValidationMessage",{defaultMessage:'"To" email address is required.'})),e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{to:this.to,subject:this.subject,body:this.body,email:{to:this.to&&this.to.length>0?this.to:void 0,subject:this.subject,body:{text:this.body}}}),e}get simulateMessage(){const e=this.to.join(", ");return h.i18n.translate("xpack.watcher.models.emailAction.simulateMessage",{defaultMessage:"Sample email sent to {toList}",values:{toList:e}})}get simulateFailMessage(){const e=this.to.join(", ");return h.i18n.translate("xpack.watcher.models.emailAction.simulateFailMessage",{defaultMessage:"Failed to send email to {toList}.",values:{toList:e}})}static fromUpstreamJson(e){return new EmailAction(e)}}(0,f.default)(EmailAction,"typeName",h.i18n.translate("xpack.watcher.models.emailAction.typeName",{defaultMessage:"Email"})),(0,f.default)(EmailAction,"iconClass","email"),(0,f.default)(EmailAction,"selectMessage",h.i18n.translate("xpack.watcher.models.emailAction.selectMessageText",{defaultMessage:"Send an email from your server."})),(0,f.default)(EmailAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.emailAction.simulateButtonLabel",{defaultMessage:"Send test email"}));class LoggingAction extends BaseAction{constructor(e={}){super(e);const t=h.i18n.translate("xpack.watcher.models.loggingAction.defaultText",{defaultMessage:"Watch [{context}] has exceeded the threshold",values:{context:"{{ctx.metadata.name}}"}});this.text=(0,j.get)(e,"text",e.ignoreDefaults?null:t)}validate(){const e={text:[]};return this.text||e.text.push(h.i18n.translate("xpack.watcher.watchActions.logging.logTextIsRequiredValidationMessage",{defaultMessage:"Log text is required."})),e}get upstreamJson(){const e=super.upstreamJson;let t;return"string"==typeof this.text?this.text.trim()&&(t=this.text):t=this.text,Object.assign(e,{text:t,logging:{text:t}}),e}get simulateMessage(){return h.i18n.translate("xpack.watcher.models.loggingAction.simulateMessage",{defaultMessage:"Sample message logged"})}get simulateFailMessage(){return h.i18n.translate("xpack.watcher.models.loggingAction.simulateFailMessage",{defaultMessage:"Failed to log sample message."})}static fromUpstreamJson(e){return new LoggingAction(e)}}(0,f.default)(LoggingAction,"typeName",h.i18n.translate("xpack.watcher.models.loggingAction.typeName",{defaultMessage:"Logging"})),(0,f.default)(LoggingAction,"iconClass","logsApp"),(0,f.default)(LoggingAction,"selectMessage",h.i18n.translate("xpack.watcher.models.loggingAction.selectMessageText",{defaultMessage:"Add an item to the logs."})),(0,f.default)(LoggingAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.loggingAction.simulateButtonLabel",{defaultMessage:"Log a sample message"}));class SlackAction extends BaseAction{constructor(e={}){super(e);const t=(0,j.get)(e,"to");this.to=(0,j.isArray)(t)?t:t&&[t];const a=h.i18n.translate("xpack.watcher.models.slackAction.defaultText",{defaultMessage:"Watch [{context}] has exceeded the threshold",values:{context:"{{ctx.metadata.name}}"}});this.text=(0,j.get)(e,"text",e.ignoreDefaults?null:a)}validate(){return{to:[],text:[]}}get upstreamJson(){const e=super.upstreamJson,t=this.to&&this.to.length>0?this.to:void 0,a=this.text||t?{text:this.text,to:t}:{};return Object.assign(e,{to:t,text:this.text,slack:{message:a}}),e}get simulateMessage(){const e=this.to&&this.to.join(", ");return h.i18n.translate("xpack.watcher.models.slackAction.simulateMessage",{defaultMessage:"Sample Slack message sent {toList}.",values:{toList:e?`to ${e}`:""}})}get simulateFailMessage(){const e=this.to&&this.to.join(", ");return h.i18n.translate("xpack.watcher.models.slackAction.simulateFailMessage",{defaultMessage:"Failed to send sample Slack message {toList}.",values:{toList:e?`to ${e}`:""}})}static fromUpstreamJson(e){return new SlackAction(e)}}(0,f.default)(SlackAction,"typeName",h.i18n.translate("xpack.watcher.models.slackAction.TypeName",{defaultMessage:"Slack"})),(0,f.default)(SlackAction,"iconClass","logoSlack"),(0,f.default)(SlackAction,"selectMessage",h.i18n.translate("xpack.watcher.models.slackAction.selectMessageText",{defaultMessage:"Send a message to a Slack user or channel."})),(0,f.default)(SlackAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.slackAction.simulateButtonLabel",{defaultMessage:"Send a sample message"}));class WebhookAction extends BaseAction{constructor(e={}){super(e);const t=JSON.stringify({message:"Watch [{{ctx.metadata.name}}] has exceeded the threshold"},null,2);this.body=(0,j.get)(e,"body",e.ignoreDefaults?null:t),this.method=(0,j.get)(e,"method"),this.host=(0,j.get)(e,"host"),this.port=(0,j.get)(e,"port"),this.scheme=(0,j.get)(e,"scheme","http"),this.path=(0,j.get)(e,"path"),this.username=(0,j.get)(e,"username"),this.password=(0,j.get)(e,"password"),this.contentType=(0,j.get)(e,"contentType"),this.fullPath=`${this.host}:${this.port}${this.path?"/"+this.path:""}`}validate(){const e={host:[],port:[],body:[],username:[],password:[]};if(this.host||e.host.push(h.i18n.translate("xpack.watcher.watchActions.webhook.hostIsRequiredValidationMessage",{defaultMessage:"Webhook host is required."})),this.port||e.port.push(h.i18n.translate("xpack.watcher.watchActions.webhook.portIsRequiredValidationMessage",{defaultMessage:"Webhook port is required."})),"application/json"===this.contentType&&"string"==typeof this.body&&""!==this.body){const t=h.i18n.translate("xpack.watcher.watchActions.webhook.invalidJsonValidationMessage",{defaultMessage:"Invalid JSON"});try{const a=JSON.parse(this.body);a&&"object"!=typeof a&&e.body.push(t)}catch(a){e.body.push(t)}}return this.username&&!this.password&&e.password.push(h.i18n.translate("xpack.watcher.watchActions.webhook.passwordIsRequiredIfUsernameValidationMessage",{defaultMessage:"Password is required."})),this.password&&!this.username&&e.username.push(h.i18n.translate("xpack.watcher.watchActions.webhook.usernameIsRequiredIfPasswordValidationMessage",{defaultMessage:"Username is required."})),e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{method:this.method,host:this.host,port:this.port,scheme:this.scheme,path:this.path,body:this.body,username:this.username,password:this.password,webhook:{host:this.host,port:this.port}}),e}get simulateMessage(){return h.i18n.translate("xpack.watcher.models.webhookAction.simulateMessage",{defaultMessage:"Sample request sent to {fullPath}",values:{fullPath:this.fullPath}})}get simulateFailMessage(){return h.i18n.translate("xpack.watcher.models.webhookAction.simulateFailMessage",{defaultMessage:"Failed to send request to {fullPath}.",values:{fullPath:this.fullPath}})}static fromUpstreamJson(e){return new WebhookAction(e)}}(0,f.default)(WebhookAction,"typeName",h.i18n.translate("xpack.watcher.models.webhookAction.typeName",{defaultMessage:"Webhook"})),(0,f.default)(WebhookAction,"iconClass","logoWebhook"),(0,f.default)(WebhookAction,"selectMessage",h.i18n.translate("xpack.watcher.models.webhookAction.selectMessageText",{defaultMessage:"Send a request to a web service."})),(0,f.default)(WebhookAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.webhookAction.simulateButtonLabel",{defaultMessage:"Send request"}));class IndexAction extends BaseAction{constructor(e={}){super(e),this.index=(0,j.get)(e,"index")}validate(){return{index:[]}}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{index:{index:this.index}}),e}get simulateMessage(){const e=this.index||"";return h.i18n.translate("xpack.watcher.models.indexAction.simulateMessage",{defaultMessage:"Index {index} has been indexed.",values:{index:e}})}get simulateFailMessage(){const e=this.index||"";return h.i18n.translate("xpack.watcher.models.indexAction.simulateFailMessage",{defaultMessage:"Failed to index {index}.",values:{index:e}})}static fromUpstreamJson(e){return new IndexAction(e)}}(0,f.default)(IndexAction,"typeName",h.i18n.translate("xpack.watcher.models.indexAction.typeName",{defaultMessage:"Index"})),(0,f.default)(IndexAction,"iconClass","indexOpen"),(0,f.default)(IndexAction,"selectMessage",h.i18n.translate("xpack.watcher.models.indexAction.selectMessageText",{defaultMessage:"Index data into Elasticsearch."})),(0,f.default)(IndexAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.indexAction.simulateButtonLabel",{defaultMessage:"Index data"}));class PagerDutyAction extends BaseAction{constructor(e={}){super(e);const t=h.i18n.translate("xpack.watcher.models.pagerdutyAction.defaultDescriptionText",{defaultMessage:"Watch [{context}] has exceeded the threshold",values:{context:"{{ctx.metadata.name}}"}});this.description=(0,j.get)(e,"description",e.ignoreDefaults?null:t)}validate(){const e={description:[]};return this.description||e.description.push(h.i18n.translate("xpack.watcher.watchActions.pagerduty.descriptionIsRequiredValidationMessage",{defaultMessage:"PagerDuty description is required."})),e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{description:this.description,pagerduty:{description:this.description}}),e}get simulateMessage(){return h.i18n.translate("xpack.watcher.models.pagerDutyAction.simulateMessage",{defaultMessage:"PagerDuty event has been sent."})}get simulateFailMessage(){return h.i18n.translate("xpack.watcher.models.pagerDutyAction.simulateFailMessage",{defaultMessage:"Failed to send PagerDuty event."})}static fromUpstreamJson(e){return new PagerDutyAction(e)}}(0,f.default)(PagerDutyAction,"typeName",h.i18n.translate("xpack.watcher.models.pagerDutyAction.typeName",{defaultMessage:"PagerDuty"})),(0,f.default)(PagerDutyAction,"iconClass","apps"),(0,f.default)(PagerDutyAction,"selectMessage",h.i18n.translate("xpack.watcher.models.pagerDutyAction.selectMessageText",{defaultMessage:"Create an event in PagerDuty."})),(0,f.default)(PagerDutyAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.pagerDutyAction.simulateButtonLabel",{defaultMessage:"Send a PagerDuty event"}));class JiraAction extends BaseAction{constructor(e={}){super(e);const t=h.i18n.translate("xpack.watcher.models.jiraAction.defaultSummaryText",{defaultMessage:"Watch [{context}] has exceeded the threshold",values:{context:"{{ctx.metadata.name}}"}});this.summary=(0,j.get)(e,"summary",e.ignoreDefaults?null:t),this.projectKey=(0,j.get)(e,"projectKey"),this.issueType=(0,j.get)(e,"issueType")}validate(){const e={projectKey:[],issueType:[],summary:[]};return this.projectKey||e.projectKey.push(h.i18n.translate("xpack.watcher.watchActions.jira.projectKeyIsRequiredValidationMessage",{defaultMessage:"Jira project key is required."})),this.issueType||e.issueType.push(h.i18n.translate("xpack.watcher.watchActions.jira.issueTypeNameIsRequiredValidationMessage",{defaultMessage:"Jira issue type is required."})),this.summary||e.summary.push(h.i18n.translate("xpack.watcher.watchActions.jira.summaryIsRequiredValidationMessage",{defaultMessage:"Jira summary is required."})),e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{projectKey:this.projectKey,issueType:this.issueType,summary:this.summary,jira:{fields:{project:{key:this.projectKey},issuetype:{name:this.issueType},summary:this.summary}}}),e}get simulateMessage(){return h.i18n.translate("xpack.watcher.models.jiraAction.simulateMessage",{defaultMessage:"Jira issue has been created."})}get simulateFailMessage(){return h.i18n.translate("xpack.watcher.models.jiraAction.simulateFailMessage",{defaultMessage:"Failed to create Jira issue."})}static fromUpstreamJson(e){return new JiraAction(e)}}(0,f.default)(JiraAction,"typeName",h.i18n.translate("xpack.watcher.models.jiraAction.typeName",{defaultMessage:"Jira"})),(0,f.default)(JiraAction,"iconClass","apps"),(0,f.default)(JiraAction,"selectMessage",h.i18n.translate("xpack.watcher.models.jiraAction.selectMessageText",{defaultMessage:"Create an issue in Atlassian’s Jira Software."})),(0,f.default)(JiraAction,"simulatePrompt",h.i18n.translate("xpack.watcher.models.jiraAction.simulateButtonLabel",{defaultMessage:"Create a sample Jira issue"}));class UnknownAction extends BaseAction{constructor(e={}){super(e),this.actionJson=(0,j.get)(e,"actionJson")}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{actionJson:this.actionJson}),e}static fromUpstreamJson(e){return new UnknownAction(e)}}const v={};(0,y.set)(v,E.TH.EMAIL,EmailAction),(0,y.set)(v,E.TH.LOGGING,LoggingAction),(0,y.set)(v,E.TH.SLACK,SlackAction),(0,y.set)(v,E.TH.WEBHOOK,WebhookAction),(0,y.set)(v,E.TH.INDEX,IndexAction),(0,y.set)(v,E.TH.PAGERDUTY,PagerDutyAction),(0,y.set)(v,E.TH.JIRA,JiraAction);class Action{static fromUpstreamJson(e){const t=(0,j.get)(e,"type");return(v[t]||UnknownAction).fromUpstreamJson(e)}}(0,f.default)(Action,"getActionTypes",(()=>v));var k=a(783),M=a.n(k);function S(e){return e?M()(e):null}class ActionStatus{constructor(e={}){this.id=(0,j.get)(e,"id"),this.state=(0,j.get)(e,"state"),this.isAckable=(0,j.get)(e,"isAckable"),this.lastAcknowledged=S((0,j.get)(e,"lastAcknowledged")),this.lastThrottled=S((0,j.get)(e,"lastThrottled")),this.lastExecution=S((0,j.get)(e,"lastExecution")),this.isLastExecutionSuccessful=(0,j.get)(e,"isLastExecutionSuccessful"),this.lastExecutionReason=(0,j.get)(e,"lastExecutionReason"),this.lastSuccessfulExecution=S((0,j.get)(e,"lastSuccessfulExecution")),this.lastAcknowledged&&(this.lastAcknowledgedHumanized=this.lastAcknowledged.fromNow()),this.lastExecution&&(this.lastExecutionHumanized=this.lastExecution.fromNow()),this.lastThrottled&&(this.lastThrottledHumanized=this.lastThrottled.fromNow())}static fromUpstreamJson(e){return new ActionStatus(e)}}class WatchStatus{constructor(e={}){this.id=(0,j.get)(e,"id"),this.state=(0,j.get)(e,"state"),this.comment=(0,j.get)(e,"comment"),this.isActive=(0,j.get)(e,"isActive"),this.lastExecution=S((0,j.get)(e,"lastExecution")),this.lastChecked=S((0,j.get)(e,"lastChecked")),this.lastMetCondition=S((0,j.get)(e,"lastMetCondition"));const t=(0,j.get)(e,"actionStatuses",[]);this.actionStatuses=t.map((e=>ActionStatus.fromUpstreamJson(e)))}static fromUpstreamJson(e){return new WatchStatus(e)}}class WatchErrors{constructor(e={}){this.actionErrors=(0,j.get)(e,"actions")}static fromUpstreamJson(e){return new WatchErrors(e)}}function A(e,t){const a=e.map((e=>e.id));let s,i=1;for(;void 0===s;){const e=`${t}_${i}`;a.includes(e)?i++:s=e}return s}class BaseWatch{constructor(e={}){var t;(0,f.default)(this,"updateWatchStatus",(e=>{this.watchStatus=e})),(0,f.default)(this,"createAction",((e,t)=>{const a=Action.getActionTypes()[e];if(!Boolean(a))throw new Error(h.i18n.translate("xpack.watcher.models.baseWatch.createUnknownActionTypeErrorMessage",{defaultMessage:"Attempted to create unknown action type {type}.",values:{type:e}}));const s=new a({id:A(this.actions,e),type:e,...t});this.addAction(s)})),(0,f.default)(this,"addAction",(e=>{(function(e,t){const a=(0,j.find)(e,{id:t.id});return Boolean(a)})(this.actions,e)&&(e.id=A(this.actions,e.type)),this.actions.push(e)})),(0,f.default)(this,"deleteAction",(e=>{(0,j.remove)(this.actions,e)})),(0,f.default)(this,"resetActions",(()=>{this.actions=[]})),(0,f.default)(this,"isEqualTo",(e=>{const t={...this},a={...e};return(0,j.isEqual)(t,a)})),this.id=(0,j.get)(e,"id"),this.type=(0,j.get)(e,"type"),this.isNew=(0,j.get)(e,"isNew",!0),this.name=(0,j.get)(e,"name"),this.isSystemWatch=Boolean((0,j.get)(e,"isSystemWatch")),this.watchStatus=WatchStatus.fromUpstreamJson((0,j.get)(e,"watchStatus")),this.watchErrors=WatchErrors.fromUpstreamJson((0,j.get)(e,"watchErrors")),this.isActive=null===(t=this.watchStatus.isActive)||void 0===t||t;const a=(0,j.get)(e,"actions",[]);this.actions=a.map(Action.fromUpstreamJson)}get displayName(){return this.name?this.name:this.id}get searchValue(){return e=["id","name"],(0,j.values)((0,j.pick)(this,e)).join("\n");var e}get typeName(){return this.constructor.typeName}get iconClass(){return this.constructor.iconClass}get selectMessage(){return this.constructor.selectMessage}get selectSortOrder(){return this.constructor.selectSortOrder}get upstreamJson(){return{id:this.id,name:this.name,type:this.type,isNew:this.isNew,isActive:this.isActive,actions:(0,j.map)(this.actions,(e=>e.upstreamJson))}}}(0,f.default)(BaseWatch,"typeName",h.i18n.translate("xpack.watcher.models.baseWatch.typeName",{defaultMessage:"Watch"})),(0,f.default)(BaseWatch,"iconClass",""),(0,f.default)(BaseWatch,"selectMessage",h.i18n.translate("xpack.watcher.models.baseWatch.selectMessageText",{defaultMessage:"Set up a new watch."})),(0,f.default)(BaseWatch,"isCreatable",!0),(0,f.default)(BaseWatch,"selectSortOrder",0);const F={trigger:{schedule:{interval:"30m"}},input:{search:{request:{body:{size:0,query:{match_all:{}}},indices:["*"]}}},condition:{compare:{"ctx.payload.hits.total":{gte:10}}},actions:{"my-logging-action":{logging:{text:"There are {{ctx.payload.hits.total}} documents in your index. Threshold is 10."}}}};class JsonWatch extends BaseWatch{constructor(e={}){e.type=E.Yk.JSON,e.id=void 0===e.id?(0,T.v4)():e.id,super(e);const t=(0,j.get)(e,"watch");this.watch=t||F,this.watchString=(0,j.get)(e,"watchString",JSON.stringify(t||F,null,2)),this.id=e.id}validate(){const e={},t={id:[],json:[]};if(e.errors=t,this.id?/^[A-Za-z0-9\-\_.]+$/.test(this.id)||t.id.push(h.i18n.translate("xpack.watcher.sections.watchEdit.json.error.invalidIdText",{defaultMessage:"ID can only contain letters, underscores, dashes, periods and numbers."})):t.id.push(h.i18n.translate("xpack.watcher.sections.watchEdit.json.error.requiredIdText",{defaultMessage:"ID is required"})),this.watchString&&""!==this.watchString)try{const e=JSON.parse(this.watchString);if(e&&"object"==typeof e){const{actions:a}=e;if(a){const e=Object.keys(a).find((e=>{const t=Object.keys(a[e]);let s;return Object.keys(E.TH).forEach((e=>{t.includes(E.TH[e])&&!t.includes(E.TH.UNKNOWN)&&(s=E.TH[e])})),!s}));e&&t.json.push(h.i18n.translate("xpack.watcher.sections.watchEdit.json.error.invalidActionType",{defaultMessage:'Unknown action type provided for action "{action}".',values:{action:e}}))}}}catch(e){t.json.push(h.i18n.translate("xpack.watcher.sections.watchEdit.json.error.invalidJsonText",{defaultMessage:"Invalid JSON"}))}else t.json.push(h.i18n.translate("xpack.watcher.sections.watchEdit.json.error.requiredJsonText",{defaultMessage:"JSON is required"}));return e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{watch:this.watch}),e}static fromUpstreamJson(e){return new JsonWatch(e)}}function I(e=E.SY.SECOND,t="0"){switch(e){case E.SY.SECOND:return h.i18n.translate("xpack.watcher.timeUnits.secondLabel",{defaultMessage:"{timeValue, plural, one {second} other {seconds}}",values:{timeValue:t}});case E.SY.MINUTE:return h.i18n.translate("xpack.watcher.timeUnits.minuteLabel",{defaultMessage:"{timeValue, plural, one {minute} other {minutes}}",values:{timeValue:t}});case E.SY.HOUR:return h.i18n.translate("xpack.watcher.timeUnits.hourLabel",{defaultMessage:"{timeValue, plural, one {hour} other {hours}}",values:{timeValue:t}});case E.SY.DAY:return h.i18n.translate("xpack.watcher.timeUnits.dayLabel",{defaultMessage:"{timeValue, plural, one {day} other {days}}",values:{timeValue:t}})}}(0,f.default)(JsonWatch,"typeName",h.i18n.translate("xpack.watcher.models.jsonWatch.typeName",{defaultMessage:"Advanced Watch"})),(0,f.default)(JsonWatch,"iconClass",""),(0,f.default)(JsonWatch,"selectMessage",h.i18n.translate("xpack.watcher.models.jsonWatch.selectMessageText",{defaultMessage:"Set up a custom watch in raw JSON."})),(0,f.default)(JsonWatch,"isCreatable",!0),(0,f.default)(JsonWatch,"selectSortOrder",100);const J={count:{text:"count()",fieldRequired:!1,value:E.wP.COUNT,validNormalizedTypes:[]},avg:{text:"average()",fieldRequired:!0,validNormalizedTypes:["number"],value:E.wP.AVERAGE},sum:{text:"sum()",fieldRequired:!0,validNormalizedTypes:["number"],value:E.wP.SUM},min:{text:"min()",fieldRequired:!0,validNormalizedTypes:["number","date"],value:E.wP.MIN},max:{text:"max()",fieldRequired:!0,validNormalizedTypes:["number","date"],value:E.wP.MAX}},L={all:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.groupByLabel.allDocumentsLabel",{defaultMessage:"all documents"}),sizeRequired:!1,value:"all",validNormalizedTypes:[]},top:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.groupByLabel.topLabel",{defaultMessage:"top"}),sizeRequired:!0,value:"top",validNormalizedTypes:["number","date","keyword"]}},C={[E.os.GREATER_THAN]:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.comparators.isAboveLabel",{defaultMessage:"Is above"}),value:E.os.GREATER_THAN,requiredValues:1},[E.os.GREATER_THAN_OR_EQUALS]:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.comparators.isAboveOrEqualsLabel",{defaultMessage:"Is above or equals"}),value:E.os.GREATER_THAN_OR_EQUALS,requiredValues:1},[E.os.LESS_THAN]:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.comparators.isBelowLabel",{defaultMessage:"Is below"}),value:E.os.LESS_THAN,requiredValues:1},[E.os.LESS_THAN_OR_EQUALS]:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.comparators.isBelowOrEqualsLabel",{defaultMessage:"Is below or equals"}),value:E.os.LESS_THAN_OR_EQUALS,requiredValues:1},[E.os.BETWEEN]:{text:h.i18n.translate("xpack.watcher.thresholdWatchExpression.comparators.isBetweenLabel",{defaultMessage:"Is between"}),value:E.os.BETWEEN,requiredValues:2}},{BETWEEN:W}=E.os,O={AGG_TYPE:"count",TERM_SIZE:5,THRESHOLD_COMPARATOR:E.os.GREATER_THAN,TIME_WINDOW_SIZE:5,TIME_WINDOW_UNIT:"m",TRIGGER_INTERVAL_SIZE:1,TRIGGER_INTERVAL_UNIT:"m",THRESHOLD:[1e3,5e3],GROUP_BY:"all"};class ThresholdWatch extends BaseWatch{constructor(e={}){e.id=e.id||(0,T.v4)(),e.type=E.Yk.THRESHOLD,super(e),this.index=e.index,this.timeField=e.timeField,this.timeFields=e.timeFields||void 0,this.triggerIntervalSize=null==e.triggerIntervalSize?O.TRIGGER_INTERVAL_SIZE:e.triggerIntervalSize,this.triggerIntervalUnit=e.triggerIntervalUnit||O.TRIGGER_INTERVAL_UNIT,this.aggType=e.aggType||O.AGG_TYPE,this.aggField=e.aggField,this.termSize=null==e.termSize?O.TERM_SIZE:e.termSize,this.termField=e.termField,this.thresholdComparator=e.thresholdComparator||O.THRESHOLD_COMPARATOR,this.timeWindowSize=null==e.timeWindowSize?O.TIME_WINDOW_SIZE:e.timeWindowSize,this.timeWindowUnit=e.timeWindowUnit||O.TIME_WINDOW_UNIT,this.groupBy=e.groupBy||O.GROUP_BY,null!=this.termField&&(this.groupBy="top"),this.threshold=null==e.threshold?O.THRESHOLD:e.threshold}get hasTermsAgg(){return Boolean(this.termField)}get termOrder(){return this.thresholdComparator===E.os.GREATER_THAN?E.jG.DESCENDING:E.jG.ASCENDING}get titleDescription(){const e=h.i18n.translate("xpack.watcher.models.thresholdWatch.sendAlertOnSpecificConditionTitleDescription",{defaultMessage:"Send an alert when your specified condition is met."});if(isNaN(this.triggerIntervalSize))return e;const t=I(this.triggerIntervalUnit,this.triggerIntervalSize);return`${e} ${h.i18n.translate("xpack.watcher.models.thresholdWatch.thresholdWatchIntervalTitleDescription",{defaultMessage:"Your watch will run every {triggerIntervalSize} {timeUnitLabel}.",values:{triggerIntervalSize:this.triggerIntervalSize,timeUnitLabel:t}})}`}validate(){const e={},t={name:[],index:[],timeField:[],triggerIntervalSize:[],aggField:[],termSize:[],termField:[],timeWindowSize:[]};return e.errors=t,this.name||t.name.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.error.requiredNameText",{defaultMessage:"Name is required."})),void 0!==this.index&&this.index.length<1&&t.index.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.enterOneOrMoreIndicesValidationMessage",{defaultMessage:"Enter one or more indices."})),void 0!==this.index&&this.index.length>0&&void 0!==this.timeFields&&1===this.timeFields.length&&t.index.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.invalidIndexValidationMessage",{defaultMessage:"Index does not have a time field."})),this.timeField||t.timeField.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.timeFieldIsRequiredValidationText",{defaultMessage:"A time field is required."})),this.triggerIntervalSize||t.triggerIntervalSize.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.intervalSizeIsRequiredValidationMessage",{defaultMessage:"Interval size is required."})),void 0!==this.triggerIntervalSize&&this.triggerIntervalSize<0&&t.triggerIntervalSize.push(h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.intervalSizeNegativeNumberValidationMessage",{defaultMessage:"Interval size cannot be a negative number."})),J[this.aggType].fieldRequired&&!this.aggField&&t.aggField.push(h.i18n.translate("xpack.watcher.watchEdit.thresholdWatchExpression.aggType.fieldIsRequiredValidationMessage",{defaultMessage:"This field is required."})),L[this.groupBy].sizeRequired&&(this.termSize||t.termSize.push(h.i18n.translate("xpack.watcher.thresholdWatchExpression.aggType.xpack.watcher.thresholdWatchExpression.groupBy.requiredValueValidationMessage",{defaultMessage:"A value is required."})),this.termField||t.termField.push(h.i18n.translate("xpack.watcher.thresholdWatchExpression.groupBy.requiredFieldValidationMessage",{defaultMessage:"This field is required."}))),Array.from(Array(C[this.thresholdComparator].requiredValues)).forEach(((e,a)=>{const s=`threshold${a}`;t[s]=[],null!=this.threshold[a]&&""!==this.threshold[a]||t[s].push(h.i18n.translate("xpack.watcher.thresholdWatchExpression.thresholdLevel.valueIsRequiredValidationMessage",{defaultMessage:"A value is required."}))})),this.thresholdComparator!==W||!this.threshold[0]||!this.threshold[1]||this.threshold[1]>this.threshold[0]||t.threshold1.push(h.i18n.translate("xpack.watcher.thresholdWatchExpression.thresholdLevel.secondValueMustBeGreaterMessage",{defaultMessage:"Value must be greater than {lowerBound}.",values:{lowerBound:this.threshold[0]}})),this.timeWindowSize||t.timeWindowSize.push(h.i18n.translate("xpack.watcher.thresholdWatchExpression.timeWindow.durationSizeIsRequiredValidationMessage",{defaultMessage:"Window duration size is required."})),e}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{index:this.index,timeField:this.timeField,triggerIntervalSize:this.triggerIntervalSize,triggerIntervalUnit:this.triggerIntervalUnit,aggType:this.aggType,aggField:this.aggField,termSize:this.termSize,termField:this.termField,termOrder:this.termOrder,thresholdComparator:this.thresholdComparator,timeWindowSize:this.timeWindowSize,timeWindowUnit:this.timeWindowUnit,hasTermsAgg:this.hasTermsAgg,threshold:C[this.thresholdComparator].requiredValues>1?this.threshold:this.threshold[0]}),e}static fromUpstreamJson(e){return new ThresholdWatch(e)}get DEFAULT_VALUES(){return O}}(0,f.default)(ThresholdWatch,"typeName",h.i18n.translate("xpack.watcher.models.thresholdWatch.typeName",{defaultMessage:"Threshold Alert"})),(0,f.default)(ThresholdWatch,"iconClass",""),(0,f.default)(ThresholdWatch,"selectMessage",h.i18n.translate("xpack.watcher.models.thresholdWatch.selectMessageText",{defaultMessage:"Send an alert on a specific condition"})),(0,f.default)(ThresholdWatch,"isCreatable",!0),(0,f.default)(ThresholdWatch,"selectSortOrder",1);class MonitoringWatch extends BaseWatch{constructor(e={}){e.type=E.Yk.MONITORING,super(e)}get upstreamJson(){const e=super.upstreamJson;return Object.assign(e,{watch:this.watch}),e}static fromUpstreamJson(e){return new MonitoringWatch(e)}}(0,f.default)(MonitoringWatch,"isCreatable",!1);const N={};(0,y.set)(N,E.Yk.JSON,JsonWatch),(0,y.set)(N,E.Yk.THRESHOLD,ThresholdWatch),(0,y.set)(N,E.Yk.MONITORING,MonitoringWatch);class Watch{static fromUpstreamJson(e={}){const t=(0,j.get)(e,"type"),a=N[t];return Object.assign(e,{isNew:!1}),a.fromUpstreamJson(e)}}(0,f.default)(Watch,"getWatchTypes",(()=>N)),a(91);class WatchHistoryItem{constructor(e={}){this.id=e.id,this.watchId=e.watchId,this.details=e.details,this.startTime=S(e.startTime),this.watchStatus=WatchStatus.fromUpstreamJson((0,j.get)(e,"watchStatus"))}static fromUpstreamJson(e){return new WatchHistoryItem(e)}}const D=e=>(0,o.sendRequest)(R(),e),_=e=>(0,o.useRequest)(R(),e);let P;const R=()=>P,H=E.bw.API_ROOT,B=({watches:e=[]})=>e.map((e=>Watch.fromUpstreamJson(e))),z=({watch:e={}})=>Watch.fromUpstreamJson(e),U=({watchHistoryItems:e=[]})=>e.map((e=>WatchHistoryItem.fromUpstreamJson(e))),q=({watchHistoryItem:e})=>WatchHistoryItem.fromUpstreamJson(e),V=async e=>D({path:`${H}/watch/${e}/deactivate`,method:"put"}),G=async e=>D({path:`${H}/watch/${e}/activate`,method:"put"}),$=async(e,t)=>D({path:`${H}/watch/execute`,method:"put",body:JSON.stringify({executeDetails:e.upstreamJson,watch:t.upstreamJson})}),K=e=>null==e?void 0:e.visualizeData,Y=e=>Settings.fromUpstreamJson(e);let Q;const X=()=>{Q.history.push({pathname:"/watches"})},Z=()=>{Q.history.push({pathname:"/watches/new-watch/threshold"})},ee=()=>{Q.history.push({pathname:"/watches/new-watch/json"})};var te=a(791);const ae=(0,s.createContext)(null),se=({links:e})=>({putWatchApiUrl:`${e.apis.putWatch}`,executeWatchApiUrl:`${e.apis.executeWatchActionModes}`,watcherGettingStartedUrl:`${e.watcher.ui}`,watchActionsConfigurationMap:{[E.TH.SLACK]:`${e.watcher.slackAction}`,[E.TH.PAGERDUTY]:`${e.watcher.pagerDutyAction}`,[E.TH.JIRA]:`${e.watcher.jiraAction}`}}),ie=({children:e,value:t})=>{const{docLinks:a,...s}=t;return(0,te.jsx)(ae.Provider,{value:Object.freeze({...s,links:se(a)})},e)},ne=()=>{const e=(0,s.useContext)(ae);if(!e)throw new Error('"useAppContext" can only be called inside of AppContext.Provider!');return e};function re({id:e}){return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,{iconType:"warning",color:"danger",title:(0,te.jsx)("h1",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.pageErrorNotExist.title",defaultMessage:"Couldn't find watch"})),body:(0,te.jsx)("p",null,e?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.pageErrorNotExist.description",defaultMessage:"A watch with ID ''{id}'' could not be found.",values:{id:e}}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.pageErrorNotExist.noWatchIdDescription",defaultMessage:"A watch could not be found."}))})}function oe(){return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,{iconType:"warning",color:"danger",title:(0,te.jsx)("h1",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.pageErrorForbidden.title",defaultMessage:"You don't have privileges to use Watcher"}))})}function le(e){const t=(Array.isArray(e)?e:[e]).find((e=>!!e&&[403,404].includes(e.statusCode)));if(t)return t.statusCode}function ce({errorCode:e,id:t}){return 404===e?(0,te.jsx)(re,{id:t}):(0,te.jsx)(oe,null)}const ue=({watchesToDelete:e,callback:t})=>{const{toasts:a}=ne(),s=e.length,i=(0,d.useGeneratedHtmlId)({prefix:"deleteWatchModal"});if(!s)return null;const n=h.i18n.translate("xpack.watcher.deleteSelectedWatchesConfirmModal.descriptionText",{defaultMessage:"You can't recover {numWatchesToDelete, plural, one {a deleted watch} other {deleted watches}}.",values:{numWatchesToDelete:s}}),r=h.i18n.translate("xpack.watcher.deleteSelectedWatchesConfirmModal.deleteButtonLabel",{defaultMessage:"Delete {numWatchesToDelete, plural, one {watch} other {# watches}} ",values:{numWatchesToDelete:s}}),o=h.i18n.translate("xpack.watcher.deleteSelectedWatchesConfirmModal.cancelButtonLabel",{defaultMessage:"Cancel"});return(0,te.jsx)(d.EuiConfirmModal,{buttonColor:"danger","data-test-subj":"deleteWatchesConfirmation",title:r,onCancel:()=>t(),onConfirm:async()=>{const{successes:s,errors:i}=await(async e=>{const t=JSON.stringify({watchIds:e}),{results:a}=await R().post(`${H}/watches/delete`,{body:t});return a})(e),n=s.length,r=i.length;t(s),n>0&&a.addSuccess(h.i18n.translate("xpack.watcher.sections.watchList.deleteSelectedWatchesSuccessNotification.descriptionText",{defaultMessage:"Deleted {numSuccesses, number} {numSuccesses, plural, one {watch} other {watches}}",values:{numSuccesses:n}})),r>0&&a.addDanger(h.i18n.translate("xpack.watcher.sections.watchList.deleteSelectedWatchesErrorNotification.descriptionText",{defaultMessage:"Failed to delete {numErrors, number} {numErrors, plural, one {watch} other {watches}}",values:{numErrors:r}}))},cancelButtonText:o,confirmButtonText:r,"aria-labelledby":i,titleProps:{id:i}},n)};var de=a(185);const he=({errorKey:e,isShowingErrors:t,errors:a,children:i,...n})=>(0,te.jsx)(d.EuiFormRow,(0,de.default)({isInvalid:t&&a[e].length>0,error:a[e]},n),(0,te.jsx)(s.Fragment,null,s.Children.map(i,(e=>(0,s.cloneElement)(e))))),ge={[E.rQ.ACTIVE]:"success",[E.rQ.INACTIVE]:"subdued",[E.rQ.CONFIG_ERROR]:"subdued",[E.rQ.ERROR]:"subdued"},me=({state:e,size:t="s"})=>(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiIcon,{type:"dot",color:ge[e]})),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiText,{size:t},e))),pe={[E.uR.OK]:"success",[E.uR.ACKNOWLEDGED]:"success",[E.uR.THROTTLED]:"warning",[E.uR.UNKNOWN]:"subdued",[E.uR.CONFIG_ERROR]:"danger",[E.uR.ERROR]:"danger"},xe=({state:e,size:t="s"})=>(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiIcon,{type:"dot",color:pe[e]})),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiText,{size:t},e))),we=({children:e})=>(0,te.jsx)(d.EuiEmptyPrompt,{title:(0,te.jsx)(d.EuiLoadingSpinner,{size:"xl"}),body:(0,te.jsx)(d.EuiText,{color:"subdued"},e),"data-test-subj":"sectionLoading"}),fe=({title:e,error:t,...a})=>{const i=t.data||t,{error:n,cause:r,message:o}=i;return(0,te.jsx)(d.EuiCallOut,(0,de.default)({title:e,color:"danger",iconType:"warning"},a),(0,te.jsx)("div",{"data-test-subj":"sectionErrorMessage"},o||n),r&&(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiSpacer,{size:"m"}),(0,te.jsx)("ul",null,r.map(((e,t)=>(0,te.jsx)("li",{key:t},e))))))},ye=i().createContext({}),je=()=>{const{toasts:e}=ne(),{watchDetail:t}=(0,s.useContext)(ye),[a,i]=(0,s.useState)([]),[n,r]=(0,s.useState)(!1),[o,l]=(0,s.useState)(null),{id:c,watchErrors:u,watchStatus:m,isSystemWatch:p}=t,x=u&&u.actionErrors,w=m&&m.actionStatuses,f=x&&Object.keys(x).length>0;(0,s.useEffect)((()=>{const e=w&&w.map((e=>{const t=x&&x[e.id];return{...e,errors:t||[]}}));i(e)}),[t,x,w]);const y=[{field:"id",name:h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.actionHeader",{defaultMessage:"Name"}),sortable:!0,truncateText:!1},{field:"state",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.stateHeader.tooltipText",{defaultMessage:"OK, acknowledged, throttled, or error."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.stateHeader",{defaultMessage:"State"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!0,render:e=>(0,te.jsx)(xe,{state:e})},{field:"lastExecution",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchHistory.watchActionStatusTable.lastExecuted.tooltipText",{defaultMessage:"The last time this action was executed."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchHistory.watchActionStatusTable.lastExecuted",{defaultMessage:"Last executed"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!1,render:e=>{var t;return null!==(t=null==e?void 0:e.format())&&void 0!==t?t:""}}],j={field:"errors",name:h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.errorsHeader",{defaultMessage:"Errors"}),render:(e,t)=>{const{id:a}=t;return e&&e.length>0?(0,te.jsx)(d.EuiButtonEmpty,{onClick:()=>l(a),"data-test-subj":"actionErrorsButton"},h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.errorsCellText",{defaultMessage:"{total, number} {total, plural, one {error} other {errors}}",values:{total:e.length}})):(0,te.jsx)(s.Fragment,null)}},b={actions:[{available:e=>e.isAckable&&!p,render:t=>{const{id:a}=t;return(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.ackActionCellTooltipTitle",{defaultMessage:"Acknowledge watch action."})},(0,te.jsx)(d.EuiButtonEmpty,{iconType:"check",isLoading:n,"data-test-subj":"acknowledgeWatchButton",onClick:async()=>{r(!0);try{const e=await(async(e,t)=>{const{watchStatus:a}=await R().put(`${H}/watch/${e}/action/${t}/acknowledge`);return WatchStatus.fromUpstreamJson(a)})(c,a),t=e.actionStatuses.map((e=>{const t=x&&x[e.id];return{...e,errors:t||[]}}));return r(!1),i(t)}catch(a){r(!1),e.addDanger(h.i18n.translate("xpack.watcher.sections.watchDetail.watchTable.ackActionErrorMessage",{defaultMessage:"Error acknowledging action {actionId}",values:{actionId:t.id}}))}}},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchDetail.watchTable.ackActionCellTitle",defaultMessage:"Acknowledge"})))}}]},T=f?[...y,j,b]:[...y,b];return(0,te.jsx)("div",{"data-test-subj":"watchDetailSection"},o&&(0,te.jsx)(d.EuiFlyout,{size:"s","aria-labelledby":"flyoutActionErrorTitle","data-test-subj":"actionErrorsFlyout",onClose:()=>l(null)},(0,te.jsx)(d.EuiFlyoutHeader,{hasBorder:!0},(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h2",{id:"flyoutActionErrorTitle","data-test-subj":"title"},o))),(0,te.jsx)(d.EuiFlyoutBody,null,(0,te.jsx)(d.EuiCallOut,{title:h.i18n.translate("xpack.watcher.sections.watchDetail.actionErrorsCalloutTitle",{defaultMessage:"This action contains errors"}),color:"danger",iconType:"cross","data-test-subj":"errorMessage"},x[o].length>1?(0,te.jsx)("ul",null,x[o].map(((e,t)=>(0,te.jsx)("li",{key:`action-error-${t}`},e.message)))):(0,te.jsx)("p",null,x[o][0].message)))),(0,te.jsx)(d.EuiInMemoryTable,{items:a,itemId:"id",columns:T,pagination:E.Bq,sorting:!0,"data-test-subj":"watchActionStatusTable",message:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchDetail.watchTable.noWatchesMessage",defaultMessage:"No actions to show"})}))},be=[{value:"now-1h",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.1h",{defaultMessage:"Last one hour"})},{value:"now-24h",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.24h",{defaultMessage:"Last 24 hours"})},{value:"now-7d",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.7d",{defaultMessage:"Last 7 days"})},{value:"now-30d",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.30d",{defaultMessage:"Last 30 days"})},{value:"now-6M",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.6M",{defaultMessage:"Last 6 months"})},{value:"now-1y",text:h.i18n.translate("xpack.watcher.sections.watchHistory.timeSpan.1y",{defaultMessage:"Last 1 year"})}],Ee=()=>{const{watchDetail:e}=(0,s.useContext)(ye),[t,a]=(0,s.useState)(void 0),[i,n]=(0,s.useState)(void 0),[r,o]=(0,s.useState)(be[0].value);void 0===t&&a(e.watchStatus&&e.watchStatus.isActive||!1);const{error:l,data:c,isLoading:u}=(m=e.id,_({query:(p=r)?{startTime:p}:void 0,path:`${H}/watch/${m}/history`,method:"get",deserializer:U}));var m,p;const{error:x,data:w}=(e=>_({path:e?`${H}/history/${e}`:"",method:"get",deserializer:q}))(i),f=w?JSON.stringify(w.details,null,2):"",y=(0,d.useGeneratedHtmlId)({prefix:"watchFlyout"}),j=(0,d.useGeneratedHtmlId)({prefix:"watchErrorFlyout"});if(l)return(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiSpacer,{size:"s"}),(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchExecutionErrorTitle",defaultMessage:"Error loading execution history"}),error:l}));const b=[{field:"startTime",name:h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.startTimeHeader",{defaultMessage:"Trigger time"}),sortable:!0,truncateText:!1,render:(e,t)=>{const a=e.format();return(0,te.jsx)(d.EuiLink,{"data-test-subj":`watchStartTimeColumn-${a}`,onClick:()=>n(t.id)},a)}},{field:"watchStatus.state",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.stateHeader.tooltipText",{defaultMessage:"Active or error state."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.stateHeader",{defaultMessage:"State"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!0,render:e=>(0,te.jsx)(me,{state:e})},{field:"startTime",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.metConditionHeader.tooltipText",{defaultMessage:"Whether the condition was met and action taken."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.metConditionHeader",{defaultMessage:"Condition met"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!0,render:(e,t)=>{const{watchStatus:{lastExecution:a}}=t;if(e.isSame(a))return(0,te.jsx)(d.EuiIcon,{color:"green",type:"check"})}},{field:"watchStatus.comment",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.commentHeader.tooltipText",{defaultMessage:"Whether the action was throttled, acknowledged, or failed to execute."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchHistory.watchTable.commentHeader",{defaultMessage:"Comment"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!0}];let T;if(void 0!==i&&(x&&(T=(0,te.jsx)(d.EuiFlyout,{"data-test-subj":"watchHistoryErrorDetailFlyout",onClose:()=>n(void 0),"aria-labelledby":j,maxWidth:600},(0,te.jsx)(d.EuiFlyoutHeader,null,(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h3",{"data-test-subj":"title",id:j},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchHistoryDetail.errorTitle",defaultMessage:"Execution details"})))),(0,te.jsx)(d.EuiFlyoutBody,null,(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchHistoryDetailsErrorTitle",defaultMessage:"Error loading execution details"}),error:x,"data-test-subj":"errorMessage"})))),void 0!==w)){var v;const e=[{field:"id",name:h.i18n.translate("xpack.watcher.sections.watchHistory.watchActionStatusTable.id",{defaultMessage:"Name"}),sortable:!0,truncateText:!1},{field:"state",name:(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchHistory.watchActionStatusTable.state.tooltipText",{defaultMessage:"OK, acknowledged, throttled, or error."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchHistory.watchActionStatusTable.state",{defaultMessage:"State"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),sortable:!0,truncateText:!0,render:e=>(0,te.jsx)(xe,{state:e})}];T=(0,te.jsx)(d.EuiFlyout,{"data-test-subj":"watchHistoryDetailFlyout",onClose:()=>n(void 0),"aria-labelledby":y,maxWidth:600},(0,te.jsx)(d.EuiFlyoutHeader,null,(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h3",{"data-test-subj":"title",id:y},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchHistoryDetail.title",defaultMessage:"Executed on {date}",values:{date:null===(v=w.startTime)||void 0===v?void 0:v.format()}})))),(0,te.jsx)(d.EuiFlyoutBody,null,(0,te.jsx)(d.EuiTitle,{size:"xs"},(0,te.jsx)("h4",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchHistoryDetail.actionsTitle",defaultMessage:"Actions"}))),(0,te.jsx)(d.EuiInMemoryTable,{items:w.watchStatus.actionStatuses,itemId:"id",columns:e,message:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchTable.noWatchesMessage",defaultMessage:"No current status to show"}),"data-test-subj":"watchActionsTable"}),(0,te.jsx)(d.EuiSpacer,null),(0,te.jsx)(d.EuiTitle,{size:"xs"},(0,te.jsx)("h4",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchHistoryDetail.jsonTitle",defaultMessage:"JSON"}))),(0,te.jsx)(d.EuiSpacer,{size:"s"}),(0,te.jsx)(d.EuiCodeBlock,{language:"json"},f)))}return(0,te.jsx)("div",{"data-test-subj":"watchHistorySection"},(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexStart",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiSelect,{options:be,value:r,onChange:e=>{const t=e.target.value;o(t)},"aria-label":h.i18n.translate("xpack.watcher.sections.watchHistory.changeTimespanSelectAriaLabel",{defaultMessage:"Change timespan of watch history"})}))),(0,te.jsx)(d.EuiSpacer,{size:"s"}),(0,te.jsx)(d.EuiInMemoryTable,{items:c||[],columns:b,pagination:E.Bq,sorting:!0,loading:u,"data-test-subj":"watchHistoryTable",message:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchTable.noCurrentStatus",defaultMessage:"No execution history to show"})}),T)},Te=[{id:"executionHistoryTab",name:h.i18n.translate("xpack.watcher.sections.watchStatus.executionHistoryTabLabel",{defaultMessage:"Execution history"})},{id:"actionStatusesTab",name:h.i18n.translate("xpack.watcher.sections.watchStatus.actionsTabLabel",{defaultMessage:"Action statuses"})}],ve=({match:{params:{id:e}}})=>{const{setBreadcrumbs:t,toasts:a}=ne(),{error:n,data:r,isLoading:o}=(e=>_({path:`${H}/watch/${e}`,method:"get",deserializer:z}))(e),[l,c]=(0,s.useState)("executionHistoryTab"),[u,p]=(0,s.useState)(void 0),[x,f]=(0,s.useState)([]),[y,j]=(0,s.useState)(!1);(0,s.useEffect)((()=>{t([m,w])}),[e,t]);const b=le(n);if(o)return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,null,(0,te.jsx)(we,null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchStatus.loadingWatchDetailsDescription",defaultMessage:"Loading watch details…"})));if(b)return(0,te.jsx)(ce,{errorCode:b,id:e});if(r){const{isSystemWatch:e,id:t,watchStatus:s,name:m}=r;void 0===u&&p(void 0!==s.isActive&&s.isActive);const w=u?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchTable.deactivateWatchLabel",defaultMessage:"Deactivate"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.watchTable.activateWatchLabel",defaultMessage:"Activate"}),b=async()=>{const e=u?V:G;j(!0);const{error:s}=await e(t);if(j(!1),s){const e=u?h.i18n.translate("xpack.watcher.sections.watchList.toggleActivatationErrorNotification.deactivateDescriptionText",{defaultMessage:"Couldn't deactivate watch"}):h.i18n.translate("xpack.watcher.sections.watchList.toggleActivatationErrorNotification.activateDescriptionText",{defaultMessage:"Couldn't activate watch"});return a.addDanger(e)}p(!u)},E="executionHistoryTab"===l?(0,te.jsx)(Ee,null):"actionStatusesTab"===l?(0,te.jsx)(je,null):void 0;return(0,te.jsx)(ye.Provider,{value:{watchDetailError:n,watchDetail:r,isWatchDetailLoading:o}},(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiPageHeader,{pageTitle:(0,te.jsx)(i().Fragment,null,(0,te.jsx)("span",{"data-test-subj":"pageTitle"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchDetail.header",defaultMessage:"Current status for ''{watch}''",values:{watch:m||t}})),e&&(0,te.jsx)(i().Fragment,null," ",(0,te.jsx)(d.EuiToolTip,{content:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchDetail.headerBadgeToolipText",defaultMessage:"You cannot deactivate or delete a system watch."})},(0,te.jsx)(d.EuiBadge,{color:"hollow",tabIndex:0},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchDetail.headerBadgeText",defaultMessage:"System watch"}))))),bottomBorder:!0,rightSideItems:e?[]:[(0,te.jsx)(d.EuiButtonEmpty,{"data-test-subj":"toggleWatchActivationButton",onClick:()=>b(),isLoading:y},w),(0,te.jsx)(d.EuiButtonEmpty,{"data-test-subj":"deleteWatchButton",onClick:()=>{f([t])},color:"danger",disabled:!1},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchHistory.deleteWatchButtonLabel",defaultMessage:"Delete"}))],tabs:Te.map(((e,t)=>({onClick:()=>{c(e.id)},isSelected:e.id===l,key:t,"data-test-subj":"tab",label:e.name})))}),(0,te.jsx)(d.EuiSpacer,{size:"l"}),E,(0,te.jsx)(ue,{callback:e=>{e&&X(),f([])},watchesToDelete:x})))}return null},ke=i().createContext({}),Me=(e,t)=>0===t?"now":`now+${t}${e}`;class ExecuteDetails{constructor(e={}){this.triggeredTimeValue=e.triggeredTimeValue,this.triggeredTimeUnit=e.triggeredTimeUnit,this.scheduledTimeValue=e.scheduledTimeValue,this.scheduledTimeUnit=e.scheduledTimeUnit,this.ignoreCondition=e.ignoreCondition,this.alternativeInput=e.alternativeInput||"",this.actionModes=e.actionModes,this.recordExecution=e.recordExecution}validate(){const e={json:[]},t=h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.invalidJsonFieldError",{defaultMessage:"Invalid JSON"});if(""!==this.alternativeInput)try{const a=JSON.parse(this.alternativeInput);a&&"object"!=typeof a&&e.json.push(t)}catch(a){e.json.push(t)}return e}get upstreamJson(){return{triggerData:{triggeredTime:this.triggeredTimeValue&&""!==this.triggeredTimeValue?Me(this.triggeredTimeUnit,this.triggeredTimeValue):void 0,scheduledTime:this.scheduledTimeValue&&""!==this.scheduledTimeValue?Me(this.scheduledTimeUnit,this.scheduledTimeValue):void 0},ignoreCondition:this.ignoreCondition,alternativeInput:""!==this.alternativeInput?JSON.parse(this.alternativeInput):void 0,actionModes:this.actionModes,recordExecution:this.recordExecution}}}function Se(e){return(0,j.intersection)((0,j.keys)(e),(0,j.values)(E.TH))[0]||E.TH.UNKNOWN}var Ae=a(424);function Fe(e,t){const{metadata:a={}}=t,s={...t,metadata:{...a,xpack:{...a.xpack,type:E.Yk.JSON}}};return e&&(s.metadata.name=e),s}class base_action_BaseAction{constructor(e,t){this.id=e.id,this.type=e.type,this.errors=t}get downstreamJson(){return{id:this.id,type:this.type}}get upstreamJson(){return{}}static getPropsFromDownstreamJson(e){return{id:e.id}}static getPropsFromUpstreamJson(e){return{id:e.id}}}class logging_action_LoggingAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.LOGGING,super(e,t),this.text=e.text}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{text:this.text}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{text:e.text}),{action:new logging_action_LoggingAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson;return e[this.id]={logging:{text:this.text}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson);return Object.assign(t,{text:e.actionJson.logging.text}),{action:new logging_action_LoggingAction(t,a),errors:a}}static validateJson(e){const t=[];return e.logging||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.loggingAction.actionJsonLoggingPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonLogging} property",values:{actionJsonLogging:"actionJson.logging"}})}),e.logging&&!e.logging.text&&t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.loggingAction.actionJsonLoggingTextPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonLoggingText} property",values:{actionJsonLoggingText:"actionJson.logging.text"}})}),{errors:t.length?t:null}}}class email_action_EmailAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.EMAIL,super(e,t),this.to=e.to,this.subject=e.subject,this.body=e.body}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{to:this.to,subject:this.subject,body:this.body}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{to:e.to,subject:e.subject,body:e.body}),{action:new email_action_EmailAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson,t={};return this.subject&&(t.subject=this.subject),this.body&&(t.body={text:this.body}),e[this.id]={email:{profile:"standard",to:this.to,...t}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson),s={};return e.actionJson.email.subject&&(s.subject=e.actionJson.email.subject),e.actionJson.email.body&&(s.body=e.actionJson.email.body.text),Object.assign(t,{to:e.actionJson.email.to,subject:e.actionJson.email.subject,...s}),{action:new email_action_EmailAction(t,a),errors:a}}static validateJson(e){const t=[];if(!e.email){const e=h.i18n.translate("xpack.watcher.models.emailAction.actionJsonEmailPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonEmail} property",values:{actionJsonEmail:"actionJson.email"}});t.push({code:E.OQ.ERR_PROP_MISSING,message:e})}if(e.email&&!e.email.to){const e=h.i18n.translate("xpack.watcher.models.emailAction.actionJsonEmailToPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonEmailTo} property",values:{actionJsonEmailTo:"actionJson.email.to"}});t.push({code:E.OQ.ERR_PROP_MISSING,message:e})}return{errors:t.length?t:null}}}class slack_action_SlackAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.SLACK,super(e,t),this.to=e.to,this.text=e.text}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{to:this.to,text:this.text}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{to:e.to,text:e.text}),{action:new slack_action_SlackAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson;return e[this.id]={slack:{message:{to:this.to,text:this.text}}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson);return Object.assign(t,{to:e.actionJson.slack.message.to,text:e.actionJson.slack.message.text}),{action:new slack_action_SlackAction(t,a),errors:a}}static validateJson(e){const t=[];return e.slack||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.slackAction.actionJsonSlackPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonSlack} property",values:{actionJsonSlack:"actionJson.slack"}})}),e.slack&&!e.slack.message&&t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.slackAction.actionJsonSlackMessagePropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonSlackMessage} property",values:{actionJsonSlackMessage:"actionJson.slack.message"}})}),{errors:t.length?t:null}}}class index_action_IndexAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.INDEX,super(e,t),this.index=e.index}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{index:this.index}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{index:e.index}),{action:new index_action_IndexAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson;return e[this.id]={index:this.index},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson);return Object.assign(t,{index:e.actionJson.index.index}),{action:new index_action_IndexAction(t,a),errors:a}}static validateJson(e){const t=[];return e.index||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.indexAction.actionJsonIndexPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonIndex} property",values:{actionJsonIndex:"actionJson.index"}})}),{errors:t.length?t:null}}}class webhook_action_WebhookAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.WEBHOOK,super(e,t),this.method=e.method,this.host=e.host,this.port=e.port,this.scheme=e.scheme,this.path=e.path,this.body=e.body,this.contentType=e.contentType,this.username=e.username,this.password=e.password}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{method:this.method,host:this.host,port:this.port,scheme:this.scheme,path:this.path,body:this.body,contentType:this.contentType,username:this.username}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{method:e.method,host:e.host,port:e.port,scheme:e.scheme,path:e.path,body:e.body,contentType:e.contentType,username:e.username,password:e.password}),{action:new webhook_action_WebhookAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson,t={};return this.path&&(t.path=this.path),this.method&&(t.method=this.method),this.scheme&&(t.scheme=this.scheme),this.body&&(t.body=this.body),this.contentType&&(t.headers={"Content-Type":this.contentType}),this.username&&this.password&&(t.auth={basic:{username:this.username,password:this.password}}),e[this.id]={webhook:{host:this.host,port:this.port,...t}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),a=e&&e.actionJson&&e.actionJson.webhook,{errors:s}=this.validateJson(e.actionJson),{path:i,method:n,scheme:r,body:o,auth:l,headers:c}=a,u={};return i&&(u.path=i),n&&(u.method=n),r&&(u.scheme=r),o&&(u.body=o),c["Content-Type"]&&(u.contentType=c["Content-Type"]),l&&l.basic&&(u.username=l.basic.username),Object.assign(t,{host:e.actionJson.webhook.host,port:e.actionJson.webhook.port,...u}),{action:new webhook_action_WebhookAction(t,s),errors:s}}static validateJson(e){const t=[];return e.webhook&&!e.webhook.host&&t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.loggingAction.actionJsonWebhookHostPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonWebhookHost} property",values:{actionJsonWebhookHost:"actionJson.webhook.host"}})}),e.webhook&&!e.webhook.port&&t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.loggingAction.actionJsonWebhookPortPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonWebhookPort} property",values:{actionJsonWebhookPort:"actionJson.webhook.port"}})}),{errors:t.length?t:null}}}class pagerduty_action_PagerDutyAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.PAGERDUTY,super(e,t),this.description=e.description}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{description:this.description}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{description:e.description}),{action:new pagerduty_action_PagerDutyAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson;return e[this.id]={pagerduty:{description:this.description}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson);return Object.assign(t,{description:e.actionJson.pagerduty.description}),{action:new pagerduty_action_PagerDutyAction(t,a),errors:a}}static validateJson(e){const t=[];return e.pagerduty||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.pagerDutyAction.actionJsonPagerDutyPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonPagerDuty} property",values:{actionJsonPagerDuty:"actionJson.pagerduty"}})}),e.pagerduty&&!e.pagerduty.description&&t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.pagerDutyAction.actionJsonPagerDutyDescriptionPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonPagerDutyText} property",values:{actionJsonPagerDutyText:"actionJson.pagerduty.description"}})}),{errors:t.length?t:null}}}class jira_action_JiraAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.JIRA,super(e,t),this.projectKey=e.projectKey,this.issueType=e.issueType,this.summary=e.summary}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{projectKey:this.projectKey,issueType:this.issueType,summary:this.summary}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{projectKey:e.projectKey,issueType:e.issueType,summary:e.summary}),{action:new jira_action_JiraAction(t,a),errors:a}}get upstreamJson(){const e=super.upstreamJson;return e[this.id]={jira:{fields:{project:{key:this.projectKey},issuetype:{name:this.issueType},summary:this.summary}}},e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e.actionJson);return Object.assign(t,{projectKey:(0,j.get)(e,"actionJson.jira.fields.project.key"),issueType:(0,j.get)(e,"actionJson.jira.fields.issuetype.name"),summary:(0,j.get)(e,"actionJson.jira.fields.summary")}),{action:new jira_action_JiraAction(t,a),errors:a}}static validateJson(e){const t=[];return e.jira||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.jiraAction.actionJsonJiraPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonJira} property",values:{actionJsonJira:"actionJson.jira"}})}),(0,j.get)(e,"jira.fields.project.key")||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.jiraAction.actionJsonJiraProjectKeyPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonJiraProjectKey} property",values:{actionJsonJiraProjectKey:"actionJson.jira.fields.project.key"}})}),(0,j.get)(e,"jira.fields.issuetype.name")||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.jiraAction.actionJsonJiraIssueTypePropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonJiraIssueType} property",values:{actionJsonJiraIssueType:"actionJson.jira.fields.issuetype.name"}})}),(0,j.get)(e,"jira.fields.summary")||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.jiraAction.actionJsonJiraSummaryPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJsonJiraSummary} property",values:{actionJsonJiraSummary:"actionJson.jira.fields.summary"}})}),{errors:t.length?t:null}}}class unknown_action_UnknownAction extends base_action_BaseAction{constructor(e,t){e.type=E.TH.UNKNOWN,super(e,t),this.actionJson=e.actionJson}get downstreamJson(){const e=super.downstreamJson;return Object.assign(e,{actionJson:this.actionJson}),e}static fromDownstreamJson(e){const t=super.getPropsFromDownstreamJson(e);return Object.assign(t,{actionJson:e.actionJson}),new unknown_action_UnknownAction(t)}get upstreamJson(){const e=super.upstreamJson;return e[this.id]=this.actionJson,e}static fromUpstreamJson(e){const t=super.getPropsFromUpstreamJson(e),{errors:a}=this.validateJson(e);return Object.assign(t,{actionJson:e.actionJson}),{action:new unknown_action_UnknownAction(t,a),errors:a}}static validateJson(e){const t=[];return e.actionJson||t.push({code:E.OQ.ERR_PROP_MISSING,message:h.i18n.translate("xpack.watcher.models.unknownAction.actionJsonPropertyMissingBadRequestMessage",{defaultMessage:"JSON argument must contain an {actionJson} property",values:{actionJson:"actionJson"}})}),{errors:t.length?t:null}}}const Ie={};(0,y.set)(Ie,E.TH.LOGGING,logging_action_LoggingAction),(0,y.set)(Ie,E.TH.EMAIL,email_action_EmailAction),(0,y.set)(Ie,E.TH.SLACK,slack_action_SlackAction),(0,y.set)(Ie,E.TH.INDEX,index_action_IndexAction),(0,y.set)(Ie,E.TH.WEBHOOK,webhook_action_WebhookAction),(0,y.set)(Ie,E.TH.PAGERDUTY,pagerduty_action_PagerDutyAction),(0,y.set)(Ie,E.TH.JIRA,jira_action_JiraAction),(0,y.set)(Ie,E.TH.UNKNOWN,unknown_action_UnknownAction);class action_Action{static fromUpstreamJson(e){const t=Se(e.actionJson),a=Ie[t]||unknown_action_UnknownAction,{action:s}=a.fromUpstreamJson(e);return s}static fromDownstreamJson(e){const t=Ie[e.type]||unknown_action_UnknownAction,{action:a}=t.fromDownstreamJson(e);return a}}function Je(e){const t={};return(0,j.forEach)(e,(e=>{const a=action_Action.fromDownstreamJson(e);Object.assign(t,a.upstreamJson)})),t}function Le(e){return e.replace(/\s+/g," ").trim()}(0,f.default)(action_Action,"getActionTypes",(()=>Ie));const{BETWEEN:Ce}=E.os;function We(e,t,a){let s="";return"count"!==e||a||(s=t===Ce?"\n      if (ctx.payload.hits.total >= params.threshold[0] && ctx.payload.hits.total <= params.threshold[1]) {\n        return true;\n      }\n\n      return false;\n    ":`\n      if (ctx.payload.hits.total ${t} params.threshold) {\n        return true;\n      }\n\n      return false;\n    `),"count"===e&&a&&(s=t===Ce?"\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      for (int i = 0; i < arr.length; i++) {\n        if (arr[i].doc_count >= params.threshold[0] && arr[i].doc_count <= params.threshold[1]) {\n          return true;\n        }\n      }\n\n      return false;\n    ":`\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      for (int i = 0; i < arr.length; i++) {\n        if (arr[i].doc_count ${t} params.threshold) {\n          return true;\n        }\n      }\n\n      return false;\n    `),"count"===e||a||(s=t===Ce?"\n      if (ctx.payload.aggregations.metricAgg.value >= params.threshold[0]\n        && ctx.payload.aggregations.metricAgg.value <= params.threshold[1]) {\n        return true;\n      }\n\n      return false;\n    ":`\n      if (ctx.payload.aggregations.metricAgg.value ${t} params.threshold) {\n        return true;\n      }\n\n      return false;\n    `),"count"!==e&&a&&(s=t===Ce?"\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      for (int i = 0; i < arr.length; i++) {\n        if (arr[i]['metricAgg'].value >= params.threshold[0] && arr[i]['metricAgg'].value <= params.threshold[1]) {\n          return true;\n        }\n      }\n\n      return false;\n    ":`\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      for (int i = 0; i < arr.length; i++) {\n        if (arr[i]['metricAgg'].value ${t} params.threshold) {\n          return true;\n        }\n      }\n\n      return false;\n    `),Le(s)}function Oe(e){return{threshold:e}}function Ne({aggType:e,thresholdComparator:t,hasTermsAgg:a,threshold:s}){return{script:{source:We(e,t,a),params:Oe(s)}}}function De(e){return Array.isArray(e)?e:[e]}function _e(e,t,a){return{[a]:{gte:`{{ctx.trigger.scheduled_time}}||-${e}${t}`,lte:"{{ctx.trigger.scheduled_time}}",format:"strict_date_optional_time||epoch_millis"}}}function Pe(e,t,a){return{bool:{filter:{range:_e(e,t,a)}}}}function Re(e,t,a,s,i,n,r,o){const l={size:0,query:Pe(e,t,a)},c=function(e,t,a,s,i){if("count"===e&&!a)return null;if("count"===e&&a)return{bucketAgg:{terms:{field:a,size:s,order:{_count:i}}}};if("count"!==e&&!a){const a={metricAgg:{}};return(0,y.set)(a,`metricAgg.${e}`,{field:t}),a}if("count"!==e&&a){const n={bucketAgg:{terms:{field:a,size:s,order:{metricAgg:i}},aggs:{metricAgg:{}}}};return(0,y.set)(n,`bucketAgg.aggs.metricAgg.${e}`,{field:t}),n}}(s,i,n,r,o);return Boolean(c)&&(l.aggs=c),l}function He({index:e,timeWindowSize:t,timeWindowUnit:a,timeField:s,aggType:i,aggField:n,termField:r,termSize:o,termOrder:l}){return{search:{request:{body:Re(t,a,s,i,n,r,o,l),indices:De(e)}}}}function Be({index:e,timeField:t,triggerIntervalSize:a,triggerIntervalUnit:s,aggType:i,aggField:n,termSize:r,termField:o,thresholdComparator:l,timeWindowSize:c,timeWindowUnit:u,threshold:d}){return{watcherui:{index:e,time_field:t,trigger_interval_size:a,trigger_interval_unit:s,agg_type:i,agg_field:n,term_size:r,term_field:o,threshold_comparator:l,time_window_size:c,time_window_unit:u,threshold:d}}}const{BETWEEN:ze}=E.os;function Ue(e,t,a){let s="";return"count"!==e||a||(s="\n      HashMap result = new HashMap();\n      result.result = ctx.payload.hits.total;\n\n      return result;\n    "),"count"===e&&a&&(s=t===ze?"\n      HashMap result = new HashMap();\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      ArrayList filteredHits = new ArrayList();\n\n      for (int i = 0; i < arr.length; i++) {\n        HashMap filteredHit = new HashMap();\n        filteredHit.key = arr[i].key;\n        filteredHit.value = arr[i].doc_count;\n        if (filteredHit.value >= params.threshold[0] && filteredHit.value <= params.threshold[1]) {\n          filteredHits.add(filteredHit);\n        }\n      }\n      result.results = filteredHits;\n\n      return result;\n    ":`\n      HashMap result = new HashMap();\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      ArrayList filteredHits = new ArrayList();\n\n      for (int i = 0; i < arr.length; i++) {\n        HashMap filteredHit = new HashMap();\n        filteredHit.key = arr[i].key;\n        filteredHit.value = arr[i].doc_count;\n        if (filteredHit.value ${t} params.threshold) {\n          filteredHits.add(filteredHit);\n        }\n      }\n      result.results = filteredHits;\n\n      return result;\n    `),"count"===e||a||(s="\n      HashMap result = new HashMap();\n      result.result = ctx.payload.aggregations.metricAgg.value;\n\n      return result;\n    "),"count"!==e&&a&&(s=t===ze?"\n      HashMap result = new HashMap();\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      ArrayList filteredHits = new ArrayList();\n\n      for (int i = 0; i < arr.length; i++) {\n        HashMap filteredHit = new HashMap();\n        filteredHit.key = arr[i].key;\n        filteredHit.value = arr[i]['metricAgg'].value;\n        if (filteredHit.value >= params.threshold[0] && filteredHit.value <= params.threshold[1]) {\n          filteredHits.add(filteredHit);\n        }\n      }\n      result.results = filteredHits;\n\n      return result;\n    ":`\n      HashMap result = new HashMap();\n      ArrayList arr = ctx.payload.aggregations.bucketAgg.buckets;\n      ArrayList filteredHits = new ArrayList();\n\n      for (int i = 0; i < arr.length; i++) {\n        HashMap filteredHit = new HashMap();\n        filteredHit.key = arr[i].key;\n        filteredHit.value = arr[i]['metricAgg'].value;\n        if (filteredHit.value ${t} params.threshold) {\n          filteredHits.add(filteredHit);\n        }\n      }\n      result.results = filteredHits;\n\n      return result;\n    `),Le(s)}function qe(e){return{threshold:e}}function Ve({aggType:e,thresholdComparator:t,hasTermsAgg:a,threshold:s}){return{script:{source:Ue(e,t,a),params:qe(s)}}}function Ge(e,t){return{schedule:{interval:`${e}${t}`}}}function $e({name:e,triggerIntervalSize:t,triggerIntervalUnit:a,index:s,timeWindowSize:i,timeWindowUnit:n,timeField:r,aggType:o,aggField:l,termField:c,termSize:u,termOrder:d,thresholdComparator:h,hasTermsAgg:g,threshold:m,actions:p,includeMetadata:x=!0}){const w={trigger:Ge(t,a),input:He({index:s,timeWindowSize:i,timeWindowUnit:n,timeField:r,aggType:o,aggField:l,termField:c,termSize:u,termOrder:d}),condition:Ne({aggType:o,thresholdComparator:h,hasTermsAgg:g,threshold:m}),transform:Ve({aggType:o,thresholdComparator:h,hasTermsAgg:g,threshold:m}),actions:Je(p)};return x&&(w.metadata={xpack:{type:E.Yk.THRESHOLD},...Be({index:s,timeField:r,triggerIntervalSize:t,triggerIntervalUnit:a,aggType:o,aggField:l,termSize:u,termField:c,thresholdComparator:h,timeWindowSize:i,timeWindowUnit:n,threshold:m})},e&&(w.metadata.name=e)),w}function Ke(e){const t=Object.keys(e);let a;return Object.keys(E.TH).forEach((e=>{t.includes(E.TH[e])&&(a=E.TH[e])})),a||E.TH.UNKNOWN}function Ye(e,t){if(e===E.TH.SLACK)return t[e].message;if(e===E.TH.JIRA){const a={};return a.projectKey=(0,j.get)(t[e],"fields.project.key"),a.issueType=(0,j.get)(t[e],"fields.issuetype.name"),a.summary=(0,j.get)(t[e],"fields.summary"),a}return t[e]}async function Qe(e,t){try{await(async e=>await R().put(`${H}/watch/${e.id}`,{body:JSON.stringify(e.upstreamJson)}))(e),t.addSuccess(e.isNew?h.i18n.translate("xpack.watcher.sections.watchEdit.json.createSuccessNotificationText",{defaultMessage:"Created ''{watchDisplayName}''",values:{watchDisplayName:e.displayName}}):h.i18n.translate("xpack.watcher.sections.watchEdit.json.saveSuccessNotificationText",{defaultMessage:"Saved ''{watchDisplayName}''",values:{watchDisplayName:e.displayName}})),X()}catch(e){var a;return{error:null!==(a=null==e?void 0:e.response.data)&&void 0!==a?a:e.body||e}}}async function Xe(e,t){const a=e.watch&&e.watch.actions?((s=e).resetActions(),Object.keys(s.watch.actions).forEach((e=>{const t=s.watch.actions[e],a=Ke(t),i={...Ye(a,t),ignoreDefaults:!0};s.createAction(a,i)})),s):e;var s;if(a.type===E.Yk.JSON){const e=a.actions.reduce(((e,t)=>{if(t.validate){const a=t.validate(),s=Object.keys(a);if(!s.find((e=>a[e].length>=1)))return e;const i=s.map((e=>a[e])),n=i&&i.length?[].concat(...i):[];return[...e,...n]}return e}),[]);return e.length>0?{error:{data:{message:e,error:"validation"}}}:Qe(a,t)}return Qe(a,t)}class RequestFlyout extends s.PureComponent{getEsJson(e){return JSON.stringify(e,null,2)}render(){const{id:e,payload:t,close:a}=this.props,s=`PUT _watcher/watch/${e||"<watchId>"}\n${this.getEsJson(t)}`,i=(0,d.htmlIdGenerator)()("requestFlyoutTitle");return(0,te.jsx)(d.EuiFlyout,{maxWidth:480,onClose:a,"aria-labelledby":i},(0,te.jsx)(d.EuiFlyoutHeader,null,(0,te.jsx)(d.EuiTitle,null,(0,te.jsx)("h2",{id:i},e?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.requestFlyout.namedTitle",defaultMessage:"Request for ''{id}''",values:{id:e}}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.requestFlyout.unnamedTitle",defaultMessage:"Request"})))),(0,te.jsx)(d.EuiFlyoutBody,null,(0,te.jsx)(d.EuiText,null,(0,te.jsx)("p",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.requestFlyout.descriptionText",defaultMessage:"This Elasticsearch request will create or update this watch."}))),(0,te.jsx)(d.EuiSpacer,null),(0,te.jsx)(d.EuiCodeBlock,{language:"json",isCopyable:!0},s)),(0,te.jsx)(d.EuiFlyoutFooter,null,(0,te.jsx)(d.EuiButtonEmpty,{iconType:"cross",onClick:a,flush:"left"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.requestFlyout.closeButtonLabel",defaultMessage:"Close"}))))}}const{useXJsonMode:Ze}=o.XJson,et=()=>{const{links:{putWatchApiUrl:e},toasts:t}=ne(),{watch:a,setWatchProperty:i}=(0,s.useContext)(ke),{convertToJson:n,setXJson:r,xJson:o}=Ze(a.watchString),{errors:l}=a.validate(),c=!!Object.keys(l).find((e=>l[e].length>=1)),[u,m]=(0,s.useState)(null),[p,x]=(0,s.useState)(!1),[w,f]=(0,s.useState)(null),[y,j]=(0,s.useState)(!1),b=!!u,E=h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.actionValidationErrorMessage",{defaultMessage:"Invalid watch actions"}),T={...l,json:b?[...l.json,E]:[...l.json]};return(0,s.useEffect)((()=>{0===l.json.length&&i("watch",JSON.parse(a.watchString))}),[i,l,a]),(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiForm,{isInvalid:b,error:u||[],"data-test-subj":"jsonWatchForm"},w&&(0,te.jsx)(s.Fragment,null,(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.saveWatchErrorTitle",defaultMessage:"Error saving watch"}),error:w,"data-test-subj":"sectionError"}),(0,te.jsx)(d.EuiSpacer,null)),(0,te.jsx)(d.EuiFormRow,{id:"watchName",label:h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.watchNameLabel",{defaultMessage:"Name (optional)"})},(0,te.jsx)(d.EuiFieldText,{id:"watchName",name:"name",value:a.name||"","data-test-subj":"nameInput",onChange:e=>{const t=e.target.value;i("name",t)},onBlur:()=>{a.name||i("name","")}})),(0,te.jsx)(he,{id:"watchId",label:h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.watchIDLabel",{defaultMessage:"ID"}),errorKey:"id",isShowingErrors:c&&void 0!==a.id,errors:l},(0,te.jsx)(d.EuiFieldText,{id:"id",name:"id","data-test-subj":"idInput",value:a.id||"",readOnly:!a.isNew,onChange:e=>{i("id",e.target.value)},onBlur:()=>{a.id||i("id","")}})),(0,te.jsx)(d.EuiSpacer,{size:"m"}),(0,te.jsx)(he,{id:"watchJson",label:(0,te.jsx)(s.Fragment,null,h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.watchJsonLabel",{defaultMessage:"Watch JSON"})," ","(",(0,te.jsx)(d.EuiLink,{href:e,target:"_blank"},h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.watchJsonDocLink",{defaultMessage:"API syntax"})),")"),errorKey:"json",isShowingErrors:c||b,fullWidth:!0,errors:T},(0,te.jsx)(Ae.CodeEditor,{languageId:"json",value:o,"data-test-subj":"jsonEditor",height:500,options:{lineNumbers:"off",tabSize:2,automaticLayout:!0},"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.json.form.watchJsonAriaLabel",{defaultMessage:"Code editor"}),onChange:e=>{u&&m(null),r(e),i("watchString",n(e))}})),(0,te.jsx)(d.EuiSpacer,null),(0,te.jsx)(d.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButton,{"data-test-subj":"saveWatchButton",fill:!0,color:"success",type:"submit",iconType:"check",isLoading:y,isDisabled:c,onClick:async()=>{j(!0);const e=await Xe(a,t);if(e&&e.error){const{data:t}=e.error;return j(!1),t&&"validation"===t.error?m(t.message):f(e.error)}}},a.isNew?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.createButtonLabel",defaultMessage:"Create watch"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.saveButtonLabel",defaultMessage:"Save watch"}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButtonEmpty,{"data-test-subj":"btnCancelWatch",onClick:()=>X()},h.i18n.translate("xpack.watcher.sections.watchEdit.json.cancelButtonLabel",{defaultMessage:"Cancel"})))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButtonEmpty,{onClick:()=>x(!p)},p?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.hideRequestButtonLabel",defaultMessage:"Hide request"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.showRequestButtonLabel",defaultMessage:"Show request"}))))),p?(0,te.jsx)(RequestFlyout,{id:a.id,payload:Fe(a.name,a.watch),close:()=>x(!1)}):null)},tt=({executeResults:e,executeDetails:t,onCloseFlyout:a,error:n})=>{var r,o,l,c;const{watch:u}=(0,s.useContext)(ke),{actionModes:m}=t,p=e=>{switch(e){case"simulate":case"force_simulate":return h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notSimulated",{defaultMessage:"not simulated"});case"execute":case"force_execute":return h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notExecuted",{defaultMessage:"not executed"});case"skip":return h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.throttled",{defaultMessage:"throttled"});default:return""}},x=(()=>{const t=u.watch&&u.watch.actions;if(e&&t){const a=e.watchStatus&&e.watchStatus.actionStatuses;return Object.keys(t).map((s=>{var i,n,r,o,l,c;const u=a.find((e=>e.id===s)),d=null===(i=e.details)||void 0===i||null===(n=i.result)||void 0===n||null===(r=n.condition)||void 0===r?void 0:r.met;return{actionId:s,actionType:Ke(t[s]),actionMode:m[s],actionState:u&&u.state,actionReason:u&&u.lastExecutionReason,actionStatus:d&&(null===(o=e.details)||void 0===o||null===(l=o.result)||void 0===l||null===(c=l.actions.find((e=>e.id===s)))||void 0===c?void 0:c.status)||p(m[s])}}))}return[]})(),w=[{field:"actionId",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.actionColumnLabel",{defaultMessage:"ID"}),sortable:!0,truncateText:!0},{field:"actionType",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.typeColumnLabel",{defaultMessage:"Type"}),truncateText:!0},{field:"actionMode",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.modeColumnLabel",{defaultMessage:"Mode"})},{field:"actionState",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.stateColumnLabel",{defaultMessage:"State"}),dataType:"string",render:(e,t)=>(0,te.jsx)(xe,{state:e})},{field:"actionReason",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.reasonColumnLabel",{defaultMessage:"Reason"})},{field:"actionStatus",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnLabel",{defaultMessage:"Status"})}],f=(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h2",{id:"simulateResultsFlyOutTitle","data-test-subj":"simulateResultsFlyoutTitle"},h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.title",{defaultMessage:"Simulation results"})));if(n)return(0,te.jsx)(d.EuiFlyout,{onClose:()=>{a()},"aria-labelledby":"simulateResultsFlyOutTitle"},(0,te.jsx)(d.EuiFlyoutHeader,{hasBorder:!0},f),(0,te.jsx)(d.EuiFlyoutBody,null,(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.simulateResults.errorTitle",defaultMessage:"Cannot simulate watch"}),error:n})));if(!e)return null;const{details:y}=e,j=(null==y||null===(r=y.result)||void 0===r||null===(o=r.condition)||void 0===o?void 0:o.met)&&(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiIcon,{color:"green",type:"check","data-test-subj":"conditionMetStatus"})," ",(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.simulateResults.conditionMetStatus",defaultMessage:"Condition met"}))||(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiIcon,{color:"subdued",type:"cross","data-test-subj":"conditionNotMetStatus"})," ",(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.simulateResults.conditionNotMetStatus",defaultMessage:"Condition not met"}));return(0,te.jsx)(d.EuiFlyout,{onClose:()=>{a()},"data-test-subj":"simulateResultsFlyout","aria-labelledby":"simulateResultsFlyOutTitle"},(0,te.jsx)(d.EuiFlyoutHeader,{hasBorder:!0},f,null!=(null==y||null===(l=y.result)||void 0===l||null===(c=l.condition)||void 0===c?void 0:c.met)&&(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiSpacer,{size:"s"}),j)),(0,te.jsx)(d.EuiFlyoutBody,null,x&&x.length>0&&(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiText,null,(0,te.jsx)("h5",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.actionsSectionTitle",{defaultMessage:"Actions"}))),(0,te.jsx)(d.EuiSpacer,{size:"m"}),(0,te.jsx)(d.EuiBasicTable,{columns:w,items:x,"data-test-subj":"simulateResultsTable"}),(0,te.jsx)(d.EuiSpacer,{size:"l"})),(0,te.jsx)(d.EuiText,null,(0,te.jsx)("h5",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulateResults.simulationOutputSectionTitle",{defaultMessage:"Simulation output"}))),(0,te.jsx)(d.EuiSpacer,{size:"l"}),(0,te.jsx)(d.EuiCodeBlock,{language:"json"},JSON.stringify(y,null,2))))},{useXJsonMode:at}=o.XJson,st=Object.keys(E.mw).map((e=>({text:E.mw[e],value:E.mw[e]}))),it=(e="0")=>Object.entries(E.SY).filter((([e])=>e!==E.SY.DAY)).map((([t,a])=>({text:I(a,e),value:a}))),nt=({executeWatchErrors:e,hasExecuteWatchErrors:t,executeDetails:a,setExecuteDetails:i,watchActions:n})=>{const{links:{executeWatchApiUrl:r}}=ne(),{watch:o}=(0,s.useContext)(ke),[l,c]=(0,s.useState)(null),[u,m]=(0,s.useState)(!1),[p,x]=(0,s.useState)(null),{errors:w}=o.validate(),f=w.json.length>=1,{actionModes:y,scheduledTimeValue:j,scheduledTimeUnit:b,triggeredTimeValue:T,alternativeInput:v,ignoreCondition:k}=a,{setXJson:M,convertToJson:S,xJson:A}=at(v),F=[{field:"actionId",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.table.idColumnLabel",{defaultMessage:"ID"}),sortable:!0,truncateText:!0},{field:"type",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.table.typeColumnLabel",{defaultMessage:"Type"}),truncateText:!0},{field:"actionMode",name:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.table.modeColumnLabel",{defaultMessage:"Mode"}),render:({},e)=>(0,te.jsx)(d.EuiSelect,{options:st,value:y[e.actionId],"data-test-subj":"actionModesSelect",onChange:t=>{i(new ExecuteDetails({...a,actionModes:{...y,[e.actionId]:t.target.value}}))},"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.table.modeSelectLabel",{defaultMessage:"Action modes"})})}];return(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiText,null,(0,te.jsx)("p",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.pageDescription",{defaultMessage:"Use the simulator to override the watch schedule, condition, actions, and input results."}))),(0,te.jsx)(d.EuiSpacer,{size:"l"}),(0,te.jsx)(d.EuiForm,{"data-test-subj":"jsonWatchSimulateForm"},(0,te.jsx)(d.EuiDescribedFormGroup,{fullWidth:!0,title:(0,te.jsx)("h2",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.triggerOverridesTitle",{defaultMessage:"Trigger"})),description:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.triggerOverridesDescription",{defaultMessage:"Set the time and date for starting the watch."})},(0,te.jsx)(d.EuiFormRow,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.scheduledTimeFieldLabel",{defaultMessage:"Schedule every"})},(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiFieldNumber,{value:null==j||""===j?j:parseInt(j,10),min:0,"data-test-subj":"scheduledTimeInput",onChange:e=>{const t=e.target.value;i(new ExecuteDetails({...a,scheduledTimeValue:""===t?t:parseInt(t,10)}))}})),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiSelect,{value:b,options:it(j),onChange:e=>{i(new ExecuteDetails({...a,scheduledTimeUnit:e.target.value}))}})))),(0,te.jsx)(d.EuiFormRow,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.triggeredTimeFieldLabel",{defaultMessage:"Trigger after"})},(0,te.jsx)(d.EuiFieldNumber,{value:null==T||""===T?T:parseInt(T,10),min:0,"data-test-subj":"triggeredTimeInput",append:(0,te.jsx)(d.EuiText,{size:"s"},I(E.SY.SECOND,T)),onChange:e=>{const t=e.target.value;i(new ExecuteDetails({...a,triggeredTimeValue:""===t?t:parseInt(t,10),triggeredTimeUnit:E.SY.SECOND}))}}))),(0,te.jsx)(d.EuiDescribedFormGroup,{fullWidth:!0,title:(0,te.jsx)("h2",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.conditionOverridesTitle",{defaultMessage:"Condition"})),description:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.conditionOverridesDescription",{defaultMessage:"Execute the watch when the condition is met. Otherwise, ignore the condition and run the watch on a fixed schedule."})},(0,te.jsx)(d.EuiSwitch,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.ignoreConditionFieldLabel",{defaultMessage:"Ignore condition"}),checked:k,"data-test-subj":"ignoreConditionSwitch",onChange:e=>{i(new ExecuteDetails({...a,ignoreCondition:e.target.checked}))}})),(0,te.jsx)(d.EuiDescribedFormGroup,{fullWidth:!0,title:(0,te.jsx)("h2",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.actionOverridesTitle",{defaultMessage:"Actions"})),description:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.simulate.form.actionOverridesDescription",defaultMessage:"Allow the watch to execute or skip actions. {actionsLink}",values:{actionsLink:(0,te.jsx)(d.EuiLink,{href:r,target:"_blank"},h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.actionOverridesDescription.linkLabel",{defaultMessage:"Learn about actions."}))}})},(0,te.jsx)(d.EuiFormRow,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.actionModesFieldLabel",{defaultMessage:"Action modes"}),fullWidth:!0},(0,te.jsx)(d.EuiBasicTable,{items:n,itemId:"simulateExecutionActionModesTable",columns:F}))),(0,te.jsx)(d.EuiDescribedFormGroup,{fullWidth:!0,title:(0,te.jsx)("h2",null,h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.inputOverridesTitle",{defaultMessage:"Input"})),description:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.inputOverridesDescription",{defaultMessage:"Enter JSON data to override the watch payload that comes from running the input."})},(0,te.jsx)(he,{id:"executeWatchJson",label:h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.alternativeInputFieldLabel",{defaultMessage:"Alternative input"}),errorKey:"json",isShowingErrors:t,fullWidth:!0,errors:e},(0,te.jsx)(Ae.CodeEditor,{languageId:"json",value:A,"data-test-subj":"jsonEditor",height:200,options:{fontSize:12,tabSize:2,scrollBeyondLastLine:!1},"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.alternativeInputAriaLabel",{defaultMessage:"Code editor"}),onChange:e=>{M(e),i(new ExecuteDetails({...a,alternativeInput:S(e)}))}}))),(0,te.jsx)(d.EuiButton,{iconType:"play","data-test-subj":"simulateWatchButton",fill:!0,type:"submit",isLoading:u,isDisabled:t||f,onClick:async()=>{m(!0);const{data:e,error:t}=await $(a,o);if(m(!1),t)return x(t);const s=WatchHistoryItem.fromUpstreamJson(e.watchHistoryItem);c(s)}},h.i18n.translate("xpack.watcher.sections.watchEdit.simulate.form.saveButtonLabel",{defaultMessage:"Simulate watch"}))),(0,te.jsx)(tt,{executeResults:l,executeDetails:a,error:p,onCloseFlyout:()=>{c(null),x(null)}}))},rt="watchEditTab",ot="watchSimulateTab",lt=[{id:rt,name:h.i18n.translate("xpack.watcher.sections.watchEdit.json.editTabLabel",{defaultMessage:"Edit"})},{id:ot,name:h.i18n.translate("xpack.watcher.sections.watchEdit.json.simulateTabLabel",{defaultMessage:"Simulate"})}],ct={triggeredTimeValue:0,triggeredTimeUnit:E.SY.SECOND,scheduledTimeValue:0,scheduledTimeUnit:E.SY.SECOND,ignoreCondition:!1};function ut(e){return e.reduce(((e,t)=>(t.actionId&&(e[t&&t.actionId]=t.actionMode),e)),{})}const dt=({pageTitle:e})=>{const{watch:t}=(0,s.useContext)(ke),a=function(e){const t=e.watch&&e.watch.actions||{};return Object.keys(t).map((e=>({actionId:e,type:Se(t[e]),actionMode:E.mw.SIMULATE})))}(t),[i,n]=(0,s.useState)(rt),[r,o]=(0,s.useState)(new ExecuteDetails({...ct,actionModes:ut(a)})),l=r.validate(),c=!!Object.keys(l).find((e=>l[e].length>=1));return(0,te.jsx)(d.EuiPageSection,{restrictWidth:!0,style:{width:"100%"}},(0,te.jsx)(d.EuiPageHeader,{pageTitle:(0,te.jsx)("span",{"data-test-subj":"pageTitle"},e),bottomBorder:!0,tabs:lt.map(((e,t)=>({onClick:()=>{n(e.id),o(new ExecuteDetails({...r,actionModes:ut(a)}))},isSelected:e.id===i,key:t,"data-test-subj":"tab",label:e.name})))}),(0,te.jsx)(d.EuiSpacer,{size:"l"}),i===ot&&(0,te.jsx)(nt,{executeDetails:r,setExecuteDetails:e=>o(e),executeWatchErrors:l,hasExecuteWatchErrors:c,watchActions:a}),i===rt&&(0,te.jsx)(et,null))},ht=({pageTitle:e})=>{const{watch:t}=(0,s.useContext)(ke),{history:a}=ne(),i=(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.monitoring.edit.calloutDescriptionText",defaultMessage:"Watch ''{watchName}'' is a system watch and cannot be edited.",values:{watchName:t.name}});return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,{iconType:"",title:(0,te.jsx)("h1",null,e),body:(0,te.jsx)("p",null,i),actions:[(0,te.jsx)(d.EuiLink,(0,r.reactRouterNavigate)(a,`/watches/watch/${t.id}/status`),(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.monitoring.header.watchLinkTitle",defaultMessage:"View watch status"}))]})};var gt=a(59),mt=a(494),pt=a.n(mt),xt=a(488),wt=a.n(xt);class VisualizeOptions{constructor(e={}){this.rangeFrom=e.rangeFrom,this.rangeTo=e.rangeTo,this.interval=e.interval,this.timezone=e.timezone}get upstreamJson(){return{rangeFrom:this.rangeFrom,rangeTo:this.rangeTo,interval:this.interval,timezone:this.timezone}}}const ft=e=>{const t="dateFormat:tz";if(!e.isDefault(t))return e.get(t);return wt().tz.guess()||wt()().format("Z")},yt=e=>{const t=`now-${5*e.timeWindowSize}${e.timeWindowUnit}`,a=pt().parse(t),s=pt().parse("now");return{min:a?a.valueOf():0,max:s?s.valueOf():0}},jt=()=>{const{createTimeBuckets:e,chartsTheme:t,uiSettings:a}=ne(),{watch:i}=(0,s.useContext)(ke),n=t.useChartsBaseTheme(),{index:r,timeField:o,triggerIntervalSize:l,triggerIntervalUnit:c,aggType:u,aggField:m,termSize:p,termField:x,thresholdComparator:w,timeWindowSize:f,timeWindowUnit:y,groupBy:j,threshold:b}=i,E=(0,s.useMemo)((()=>yt(i)),[i]),T=e();T.setBounds(E);const v=T.getInterval().expression,k=new VisualizeOptions({rangeFrom:E.min,rangeTo:E.max,interval:v,timezone:ft(a)}),M=new ThresholdWatch({...i,actions:[]}),{isInitialRequest:S,isLoading:A,data:F,error:I,resendRequest:L}=((e,t)=>_({path:`${H}/watch/visualize`,method:"post",body:JSON.stringify({watch:e.upstreamJson,options:t.upstreamJson}),deserializer:K}))(M,k);if((0,s.useEffect)((()=>{S||L()}),[r,o,l,c,u,m,p,x,w,f,y,j,b]),S&&A)return(0,te.jsx)(d.EuiEmptyPrompt,{title:(0,te.jsx)(d.EuiLoadingChart,{size:"xl"}),body:(0,te.jsx)(d.EuiText,{color:"subdued"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.loadingWatchVisualizationDescription",defaultMessage:"Loading watch visualization…"}))});if(I)return(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiSpacer,{size:"l"}),(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.errorLoadingWatchVisualizationTitle",defaultMessage:"Cannot load watch visualization"}),error:I}),(0,te.jsx)(d.EuiSpacer,{size:"l"}));if(F){const t=Object.keys(F),s=ft(a),r=(e=>e.threshold.slice(0,C[e.thresholdComparator].requiredValues))(i);let o=r[r.length-1];Object.values(F).forEach((e=>{e.forEach((([,e])=>{e>o&&(o=e)}))}));const l=t=>wt()(t).tz(s).format(((e,t)=>{const a=yt(e);return t.setBounds(a),t})(i,e()).getScaledDateFormat()),c=J[i.aggType].text;return(0,te.jsx)("div",{"data-test-subj":"watchVisualizationChart"},(0,te.jsx)(d.EuiSpacer,{size:"l"}),t.length?(0,te.jsx)(gt.Chart,{size:["100%",300],renderer:"canvas"},(0,te.jsx)(gt.Settings,{theme:[{lineSeriesStyle:{line:{strokeWidth:3},point:{visible:"never"}}}],baseTheme:n,xDomain:E,showLegend:!!i.termField,legendValues:[gt.LegendValue.CurrentAndLastValue],legendPosition:gt.Position.Bottom,locale:h.i18n.getLocale()}),(0,te.jsx)(gt.Axis,{id:"bottom",position:gt.Position.Bottom,showOverlappingTicks:!0,tickFormat:l}),(0,te.jsx)(gt.Axis,{domain:{max:o,min:NaN},id:"left",title:c,position:gt.Position.Left}),t.map((e=>(0,te.jsx)(gt.LineSeries,{key:e,id:e,xScaleType:gt.ScaleType.Time,yScaleType:gt.ScaleType.Linear,data:F[e],xAccessor:0,yAccessors:[1],timeZone:s}))),r.map(((e,t)=>{const a=0===t?"threshold":`threshold${t}`;return(0,te.jsx)(gt.LineAnnotation,{key:a,id:a,domainType:gt.AnnotationDomainType.YDomain,dataValues:[{dataValue:i.threshold[t],details:a}]})}))):(0,te.jsx)(d.EuiCallOut,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.thresholdPreviewChart.noDataTitle",defaultMessage:"No data"}),color:"warning"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.thresholdPreviewChart.dataDoesNotExistTextMessage",defaultMessage:"Your index and condition did not return any data."})),(0,te.jsx)(d.EuiSpacer,{size:"l"}))}return null},bt={watcherTresholdActionContextMenuItem:{name:"qbt5ty",styles:"align-self:center"}},Et=h.i18n.translate("xpack.watcher.sections.watchEdit.actions.disabledOptionLabel",{defaultMessage:"Disabled. Configure your elasticsearch.yml."}),Tt=({settings:e,isLoading:t})=>{const{addAction:a}=(0,s.useContext)(ke),[i,n]=(0,s.useState)(!1),r=Action.getActionTypes(),o=Object.entries(r).map((([t,{typeName:a,iconClass:s,selectMessage:i}])=>({type:t,typeName:a,iconClass:s,selectMessage:i,isEnabled:!(e&&e.actionTypes&&e.actionTypes[t]&&void 0!==e.actionTypes[t].enabled)||e.actionTypes[t].enabled}))),l=(0,te.jsx)(d.EuiButton,{"data-test-subj":"addWatchActionButton",iconType:"arrowDown",iconSide:"right",onClick:()=>n(!i)},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.actions.addActionButtonLabel",defaultMessage:"Add action"}));return(0,te.jsx)(d.EuiPopover,{id:"watchActionPanel",button:l,isOpen:i,closePopover:()=>n(!1),panelPaddingSize:"none",anchorPosition:"downLeft"},(0,te.jsx)(d.EuiContextMenuPanel,{items:o.map(((e,t)=>{const s=e.type===E.TH.EMAIL&&!e.isEnabled,i=s?Et:e.selectMessage;return(0,te.jsx)(d.EuiContextMenuItem,{key:`${e.type}-${t}`,disabled:s,"data-test-subj":`${e.type}ActionButton`,onClick:()=>{a({type:e.type,defaults:{isNew:!0}}),n(!1)}},(0,te.jsx)(d.EuiFlexGroup,{responsive:!1},(0,te.jsx)(d.EuiFlexItem,{grow:!1,css:bt.watcherTresholdActionContextMenuItem},(0,te.jsx)(d.EuiIcon,{type:e.iconClass})),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)("strong",null,e.typeName),(0,te.jsx)(d.EuiSpacer,{size:"xs"}),(0,te.jsx)(d.EuiText,{size:"s"},(0,te.jsx)("p",null,i)))))}))}))},vt=["head","get","post","put","delete"],kt=["http","https"],Mt={[E.TH.LOGGING]:({action:e,editAction:t,errors:a,hasErrors:s})=>{const{text:i}=e;return(0,te.jsx)(he,{id:"loggingText",errorKey:"text",fullWidth:!0,errors:a,isShowingErrors:s&&void 0!==i,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.loggingAction.logTextFieldLabel",{defaultMessage:"Log text"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"text",value:i||"","data-test-subj":"loggingTextInput",onChange:e=>{t({key:"text",value:e.target.value})},onBlur:()=>{i||t({key:"text",value:""})}}))},[E.TH.SLACK]:({action:e,editAction:t,children:a})=>{const{text:i,to:n}=e,r=n?n.map((e=>({label:e}))):[];return(0,te.jsx)(s.Fragment,null,a,(0,te.jsx)(d.EuiFormRow,{fullWidth:!0,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.slackAction.recipientTextFieldLabel",{defaultMessage:"Recipient (optional)"})},(0,te.jsx)(d.EuiComboBox,{noSuggestions:!0,fullWidth:!0,selectedOptions:r,"data-test-subj":"slackRecipientComboBox",onCreateOption:e=>{const a=[...r,{label:e}];t({key:"to",value:a.map((e=>e.label))})},onChange:e=>{t({key:"to",value:e.map((e=>e.label))})}})),(0,te.jsx)(d.EuiFormRow,{fullWidth:!0,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.slackAction.messageTextAreaFieldLabel",{defaultMessage:"Message (optional)"})},(0,te.jsx)(d.EuiTextArea,{fullWidth:!0,name:"text",value:i,"data-test-subj":"slackMessageTextarea",onChange:e=>{t({key:"text",value:e.target.value})}})))},[E.TH.EMAIL]:({action:e,editAction:t,errors:a,hasErrors:i})=>{const{to:n,subject:r,body:o}=e,l=n?n.map((e=>({label:e}))):[],c=h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.emailAction.recipientTextFieldLabel",{defaultMessage:"To email address"});return(0,te.jsx)(s.Fragment,null,(0,te.jsx)(he,{id:"emailRecipient",errorKey:"to",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==n,label:c},(0,te.jsx)(d.EuiComboBox,{noSuggestions:!0,fullWidth:!0,"aria-label":c,"data-test-subj":"toEmailAddressInput",selectedOptions:l,onCreateOption:e=>{const a=[...l,{label:e}];t({key:"to",value:a.map((e=>e.label))})},onChange:e=>{t({key:"to",value:e.map((e=>e.label))})},onBlur:()=>{n||t({key:"to",value:[]})}})),(0,te.jsx)(d.EuiFormRow,{fullWidth:!0,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.emailAction.subjectTextFieldLabel",{defaultMessage:"Subject (optional)"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"subject","data-test-subj":"emailSubjectInput",value:r||"",onChange:e=>{t({key:"subject",value:e.target.value})}})),(0,te.jsx)(d.EuiFormRow,{fullWidth:!0,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.emailAction.bodyTextAreaFieldLabel",{defaultMessage:"Body"})},(0,te.jsx)(d.EuiTextArea,{fullWidth:!0,value:o||"",name:"body","data-test-subj":"emailBodyInput",onChange:e=>{t({key:"body",value:e.target.value})}})))},[E.TH.INDEX]:({action:e,editAction:t,errors:a,hasErrors:s})=>{const{index:i}=e;return(0,te.jsx)(he,{id:"indexName",errorKey:"index",fullWidth:!0,errors:a,isShowingErrors:s&&void 0!==i,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.indexAction.indexFieldLabel",{defaultMessage:"Index"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"index","data-test-subj":"indexInput",value:i||"",onChange:e=>{t({key:"index",value:e.target.value})},onBlur:()=>{i||t({key:"index",value:""})}}))},[E.TH.WEBHOOK]:({action:e,editAction:t,errors:a,hasErrors:i})=>{const{method:n,host:r,port:o,scheme:l,path:c,body:u,username:g,password:m}=e;return(0,s.useEffect)((()=>{t({key:"contentType",value:"application/json"})}),[t]),(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiFormRow,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.methodFieldLabel",{defaultMessage:"Method"})},(0,te.jsx)(d.EuiSelect,{name:"method",value:n||"get","data-test-subj":"webhookMethodSelect",options:vt.map((e=>({text:e.toUpperCase(),value:e}))),onChange:e=>{t({key:"method",value:e.target.value})}}))),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiFormRow,{label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.schemeFieldLabel",{defaultMessage:"Scheme"})},(0,te.jsx)(d.EuiSelect,{name:"scheme",value:l,"data-test-subj":"webhookSchemeSelect",options:kt.map((e=>({text:e,value:e}))),onChange:e=>{t({key:"scheme",value:e.target.value})}}))),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(he,{id:"webhookHost",errorKey:"host",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==r,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.hostFieldLabel",{defaultMessage:"Host"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"host",value:r||"","data-test-subj":"webhookHostInput",onChange:e=>{t({key:"host",value:e.target.value})},onBlur:()=>{r||t({key:"host",value:""})}}))),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(he,{id:"webhookPort",errorKey:"port",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==o,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.methodPortLabel",{defaultMessage:"Port"})},(0,te.jsx)(d.EuiFieldNumber,{prepend:":",fullWidth:!0,name:"port",value:o||"","data-test-subj":"webhookPortInput",onChange:e=>{t({key:"port",value:parseInt(e.target.value,10)})},onBlur:()=>{o||t({key:"port",value:""})}}))),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiFormRow,{fullWidth:!0,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.pathFieldLabel",{defaultMessage:"Path (optional)"})},(0,te.jsx)(d.EuiFieldText,{prepend:"/",fullWidth:!0,name:"path",value:c||"","data-test-subj":"webhookPathInput",onChange:e=>{t({key:"path",value:e.target.value})}})))),(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{id:"webhookBasicAuthUsername",errorKey:"username",isShowingErrors:i,errors:a,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.basicAuthUsername",{defaultMessage:"Username (optional)"})},(0,te.jsx)(d.EuiFieldText,{name:"username",value:g||"","data-test-subj":"webhookUsernameInput",onChange:e=>{t({key:"username",value:e.target.value})}}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{id:"webhookBasicAuthPassword",errorKey:"password",isShowingErrors:i,errors:a,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.basicAuthPassword",{defaultMessage:"Password (optional)"})},(0,te.jsx)(d.EuiFieldPassword,{name:"password",value:m||"","data-test-subj":"webhookPasswordInput",onChange:e=>{t({key:"password",value:e.target.value})}})))),(0,te.jsx)(d.EuiSpacer,{size:"s"}),(0,te.jsx)(he,{id:"webhookBody",label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.bodyFieldLabel",{defaultMessage:"Body"}),errorKey:"body",isShowingErrors:i,fullWidth:!0,errors:a},(0,te.jsx)(Ae.CodeEditor,{languageId:"json",value:u||"","data-test-subj":"webhookBodyEditor",height:200,options:{lineNumbers:"off",tabSize:2,scrollBeyondLastLine:!1},"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.webhookAction.bodyCodeEditorAriaLabel",{defaultMessage:"Code editor"}),onChange:e=>{t({key:"body",value:e})}})))},[E.TH.PAGERDUTY]:({errors:e,hasErrors:t,action:a,editAction:i,children:n})=>{const{description:r}=a;return(0,te.jsx)(s.Fragment,null,n,(0,te.jsx)(he,{id:"pagerDutyDescription",errorKey:"description",fullWidth:!0,errors:e,isShowingErrors:t&&void 0!==r,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.pagerDutyAction.descriptionFieldLabel",{defaultMessage:"Description"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"description",value:r||"","data-test-subj":"pagerdutyDescriptionInput",onChange:e=>{i({key:"description",value:e.target.value})},onBlur:()=>{r||i({key:"description",value:""})}})))},[E.TH.JIRA]:({action:e,editAction:t,errors:a,hasErrors:i,children:n})=>{const{projectKey:r,issueType:o,summary:l}=e;return(0,te.jsx)(s.Fragment,null,n,(0,te.jsx)(he,{id:"jiraProjectKey",errorKey:"projectKey",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==r,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.jiraAction.projectKeyFieldLabel",{defaultMessage:"Project key"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,name:"projectKey",value:r||"","data-test-subj":"jiraProjectKeyInput",onChange:e=>{t({key:"projectKey",value:e.target.value})},onBlur:()=>{r||t({key:"projectKey",value:""})}})),(0,te.jsx)(he,{id:"jiraIssueType",errorKey:"issueType",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==o,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.jiraAction.issueTypeFieldLabel",{defaultMessage:"Issue type"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,value:o||"",name:"issueType","data-test-subj":"jiraIssueTypeInput",onChange:e=>{t({key:"issueType",value:e.target.value})},onBlur:()=>{o||t({key:"issueType",value:""})}})),(0,te.jsx)(he,{id:"jiraSummary",errorKey:"summary",fullWidth:!0,errors:a,isShowingErrors:i&&void 0!==l,label:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.jiraAction.summaryFieldLabel",{defaultMessage:"Summary"})},(0,te.jsx)(d.EuiFieldText,{fullWidth:!0,value:l||"",name:"summary","data-test-subj":"jiraSummaryInput",onChange:e=>{t({key:"summary",value:e.target.value})},onBlur:()=>{l||t({key:"summary",value:""})}})))}};var St={name:"1bs7qd7",styles:"&:hover{text-decoration:none;}"};const At=({settings:e,actionErrors:t})=>{const a=(()=>{const{euiTheme:e}=(0,d.useEuiTheme)();return{watcherThresholdDeleteButton:(0,te.css)("opacity:0;&:focus,.euiAccordion:hover &{opacity:1;}",d.euiCanAnimate,"{transition:opacity ",e.animation.normal," ",e.animation.resistance,";}","")}})(),{links:{watchActionsConfigurationMap:i},toasts:n}=ne(),{watch:r,setWatchProperty:o}=(0,s.useContext)(ke),{actions:l}=r,[c,u]=(0,s.useState)({}),[m,p]=(0,s.useState)(null);return l&&l.length>=1?l.map((x=>{const w=Mt[x.type],f=t[x.id],y=!!Object.keys(f).find((e=>f[e].length>=1));return(0,te.jsx)(d.EuiAccordion,{initialIsOpen:x.isNew||y,key:x.id,id:x.id,borders:"horizontal",buttonProps:{paddingSize:"m",css:St},"data-test-subj":"watchActionAccordion",buttonContent:(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiIcon,{type:x.iconClass,size:"m"})),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h6",null,x.typeName)))),extraAction:(0,te.jsx)(d.EuiButtonIcon,{iconType:"cross",color:"danger",css:a.watcherThresholdDeleteButton,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.accordion.deleteIconAriaLabel",{defaultMessage:"Delete"}),onClick:()=>{const e=l.filter((e=>e.id!==x.id));o("actions",e)}}),paddingSize:"l"},m&&m[x.id]&&(0,te.jsx)(s.Fragment,null,(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.accordion.simulateResultsErrorTitle",defaultMessage:"Error testing action"}),error:m[x.id]}),(0,te.jsx)(d.EuiSpacer,{size:"s"})),(0,te.jsx)(d.EuiForm,null,(0,te.jsx)(w,{action:x,errors:f,hasErrors:y,editAction:e=>{const t=l.map((t=>{if(t.id===x.id){const t=Action.getActionTypes()[x.type],{key:a,value:s}=e;return new t({...x,[a]:s})}return t}));o("actions",t)}},e&&!1===e.actionTypes[x.type].enabled?(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiCallOut,{announceOnMount:!0,title:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningTitleText",{defaultMessage:"Account may not be configured"}),color:"warning",iconType:"question"},(0,te.jsx)(d.EuiText,null,(0,te.jsx)("p",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningDescriptionText",defaultMessage:"To create this action, you must configure at least one {accountType} account. {docLink}",values:{accountType:x.typeName,docLink:(0,te.jsx)(d.EuiLink,{href:i[x.type],target:"_blank"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.actions.actionConfigurationWarningHelpLinkText",defaultMessage:"Learn more."}))}})))),(0,te.jsx)(d.EuiSpacer,null)):null),(0,te.jsx)(d.EuiButton,{type:"submit",isDisabled:y,isLoading:c[x.id],"data-test-subj":"simulateActionButton",onClick:async()=>{const e=r.actions.filter((e=>e.id===x.id)),t=new ExecuteDetails({ignoreCondition:!0,recordExecution:!1,actionModes:{[x.id]:E.mw.FORCE_EXECUTE}}),a=new ThresholdWatch({...r,actions:e});u({[x.id]:!0}),p(null);const{data:s,error:i}=await $(t,a);if(u({[x.id]:!1}),i)return p({[x.id]:i});const o=WatchHistoryItem.fromUpstreamJson(s.watchHistoryItem).watchStatus.actionStatuses.find((e=>e.id===x.id));if(o&&!1===o.isLastExecutionSuccessful){const e=o.lastExecutionReason||x.simulateFailMessage;return n.addDanger(e)}return n.addSuccess(x.simulateMessage)}},x.simulatePrompt)))})):null},Ft={watcherThresholdActionDropdownContainer:{name:"nout15",styles:"justify-content:flex-end;flex-direction:row"}},It=({actionErrors:e})=>{const{watch:t}=(0,s.useContext)(ke),{data:a,isLoading:i}=_({path:`${H}/settings`,method:"get",deserializer:Y});return(0,te.jsx)("div",{"data-test-subj":"watchActionsPanel"},(0,te.jsx)(d.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h2",null,h.i18n.translate("xpack.watcher.sections.watchEdit.actions.title",{defaultMessage:"Perform {watchActionsCount, plural, one{# action} other {# actions}} when condition is met",values:{watchActionsCount:t.actions.length}})))),(0,te.jsx)(d.EuiFlexItem,{css:Ft.watcherThresholdActionDropdownContainer},(0,te.jsx)(Tt,{settings:a,isLoading:i}))),(0,te.jsx)(d.EuiSpacer,{size:"l"}),(0,te.jsx)(At,{settings:a,actionErrors:e}))},Jt={watcherThresholdAlertAggFieldContainer:{name:"18ji2p4",styles:"width:300px"},watcherThresholdInBetweenComparatorText:{name:"qbt5ty",styles:"align-self:center"}},Lt=["aggField","termSize","termField","threshold0","threshold1","timeWindowSize"],Ct=["aggType","aggField","termSize","termField","thresholdComparator","timeWindowSize","timeWindowUnit","triggerIntervalSize","triggerIntervalUnit","threshold","groupBy"],Wt=h.i18n.translate("xpack.watcher.thresholdWatchExpression.fixErrorInExpressionBelowValidationMessage",{defaultMessage:"Expression contains errors."}),Ot={text:h.i18n.translate("xpack.watcher.sections.watchEdit.titlePanel.timeFieldOptionLabel",{defaultMessage:"Select a field"}),value:""},Nt=e=>Object.entries(E.SY).map((([t,a])=>({text:I(a,e),value:a}))),Dt=async e=>await(async e=>{const{fields:t}=await R().post(`${H}/fields`,{body:JSON.stringify({indexes:e})});return t})(e),_t=e=>{const t=[Ot];return e.forEach((e=>{"date"===e.type&&t.push({text:e.name,value:e.name})})),t},Pt=({pageTitle:e})=>{const{toasts:t}=ne(),[a,i]=(0,s.useState)([]),[n,r]=(0,s.useState)([]),[o,l]=(0,s.useState)([]),[c,u]=(0,s.useState)([Ot]),[m,p]=(0,s.useState)(!1),[x,w]=(0,s.useState)(!1),[f,y]=(0,s.useState)(!1),[j,E]=(0,s.useState)(!1),[T,v]=(0,s.useState)(!1),[k,M]=(0,s.useState)(null),[S,A]=(0,s.useState)(!1),[F,W]=(0,s.useState)(!1),[O,N]=(0,s.useState)(!1),{watch:_,setWatchProperty:P}=(0,s.useContext)(ke);(0,s.useEffect)((()=>{(async()=>{if(_.index&&_.index.length>0){const e=await Dt(_.index),t=_t(e);r(e),u(t),P("timeFields",t)}(async()=>{const{data:e}=await(async()=>D({path:`${H}/indices/index_patterns`,method:"get"}))();i(e)})()})()}),[]);const{errors:B}=_.validate(),z=!!Object.keys(B).find((e=>B[e].length>=1)),U=_.actions.reduce(((e,t)=>{const a=t.validate();return e[t.id]=a,e}),{}),q=!!Object.keys(U).find((e=>!!Object.keys(U[e]).find((t=>U[e][t].length>=1)))),V=!!Object.keys(B).find((e=>Lt.includes(e)&&B[e].length>=1)),G=_.index&&_.index.length>0&&_.timeField,$=h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.andLabel",{defaultMessage:"AND"}),K={..._.upstreamJson,includeMetadata:!1};return(0,te.jsx)(d.EuiPageSection,{restrictWidth:!0,style:{width:"100%"}},(0,te.jsx)(d.EuiPageHeader,{pageTitle:(0,te.jsx)("span",{"data-test-subj":"pageTitle"},e),description:_.titleDescription,bottomBorder:!0}),(0,te.jsx)(d.EuiSpacer,{size:"l"}),(0,te.jsx)(d.EuiForm,{"data-test-subj":"thresholdWatchForm"},k&&(0,te.jsx)(s.Fragment,null,(0,te.jsx)(fe,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.saveWatchErrorTitle",defaultMessage:"Error saving watch"}),error:k}),(0,te.jsx)(d.EuiSpacer,null)),(0,te.jsx)(he,{id:"watchName",label:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.titlePanel.watchNameLabel",defaultMessage:"Name"}),errorKey:"name",isShowingErrors:z&&void 0!==_.name,errors:B},(0,te.jsx)(d.EuiFieldText,{name:"name","data-test-subj":"nameInput",value:_.name||"",onChange:e=>{P("name",e.target.value)},onBlur:()=>{_.name||P("name","")}})),(0,te.jsx)(d.EuiSpacer,null),(0,te.jsx)(d.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(he,{id:"indexSelectSearchBox",fullWidth:!0,label:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.titlePanel.indicesToQueryLabel",defaultMessage:"Indices to query"}),errorKey:"index",isShowingErrors:z&&void 0!==_.index,errors:B,helpText:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.titlePanel.howToBroadenSearchQueryDescription",defaultMessage:"Use * to broaden your query."})},(0,te.jsx)(d.EuiComboBox,{fullWidth:!0,async:!0,isLoading:F,noSuggestions:!o.length,options:o,"data-test-subj":"indicesComboBox",selectedOptions:(_.index||[]).map((e=>({label:e,value:e}))),onChange:async e=>{P("index",e.map((e=>e.value)));const t=e.map((e=>e.value));if(0===t.length)return u(_t([])),P("timeFields",[]),void Ct.forEach((e=>{P(e,null)}));const a=await Dt(t),s=_t(a);r(a),P("timeFields",s),u(s)},onSearchChange:async e=>{W(!0),l(await(async(e,t)=>{const a=[];if(!e)return a;const s=await(async e=>{e.startsWith("*")||(e=`*${e}`),e.endsWith("*")||(e=`${e}*`);const t=JSON.stringify({pattern:e}),{indices:a}=await R().post(`${H}/indices`,{body:t});return a})(e),i=t.filter((t=>t.includes(e)));if(s.length||i.length){const e=b().uniq([...s,...i]);a.push({label:h.i18n.translate("xpack.watcher.sections.watchEdit.titlePanel.indicesAndIndexPatternsLabel",{defaultMessage:"Based on your indices and index patterns"}),options:e.map((e=>({label:e,value:e}))).sort(((e,t)=>String(e.label).localeCompare(t.label)))})}return a.push({label:h.i18n.translate("xpack.watcher.sections.watchEdit.titlePanel.chooseLabel",{defaultMessage:"Choose…"}),options:[{key:"UNIQUE_CHOOSE_KEY",value:e,label:e}]}),a})(e,a)),W(!1)},onBlur:()=>{_.index||P("index",[])}}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{id:"timeField",fullWidth:!0,label:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.titlePanel.timeFieldLabel",defaultMessage:"Time field"}),errorKey:"timeField",isShowingErrors:z&&void 0!==_.timeField,errors:B},(0,te.jsx)(d.EuiSelect,{options:c,fullWidth:!0,name:"watchTimeField","data-test-subj":"watchTimeFieldSelect",value:_.timeField,onChange:e=>{P("timeField",e.target.value)},onBlur:()=>{void 0===_.timeField&&P("timeField","")}}))),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(he,{id:"watchInterval",fullWidth:!0,label:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.titlePanel.watchIntervalLabel",defaultMessage:"Run watch every"}),errorKey:"triggerIntervalSize",isShowingErrors:z&&void 0!==_.triggerIntervalSize,errors:B},(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiFieldNumber,{fullWidth:!0,min:1,value:_.triggerIntervalSize,"data-test-subj":"triggerIntervalSizeInput",onChange:e=>{const{value:t}=e.target,a=""!==t?parseInt(t,10):t;P("triggerIntervalSize",a)},onBlur:e=>{void 0===_.triggerIntervalSize&&P("triggerIntervalSize","")}})),(0,te.jsx)(d.EuiFlexItem,null,(0,te.jsx)(d.EuiSelect,{fullWidth:!0,value:_.triggerIntervalUnit,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.titlePanel.durationAriaLabel",{defaultMessage:"Duration time unit"}),onChange:e=>{P("triggerIntervalUnit",e.target.value)},options:Nt(_.triggerIntervalSize)})))))),(0,te.jsx)(d.EuiSpacer,null),G?(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiTitle,{size:"s"},(0,te.jsx)("h2",{"data-test-subj":"watchConditionTitle"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.watchConditionSectionTitle",defaultMessage:"Match the following condition"}))),(0,te.jsx)(d.EuiSpacer,{size:"m"}),(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"s"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiPopover,{id:"aggTypePopover",button:(0,te.jsx)(d.EuiExpression,{description:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.whenLabel",{defaultMessage:"when"}),value:J[_.aggType].text,isActive:T,onClick:()=>{v(!0)}}),isOpen:T,closePopover:()=>{v(!1)},ownFocus:!0,anchorPosition:"downLeft"},(0,te.jsx)("div",null,(0,te.jsx)(d.EuiPopoverTitle,null,h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.whenButtonLabel",{defaultMessage:"when"})),(0,te.jsx)(d.EuiSelect,{value:_.aggType,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.aggTypeSelectAriaLabel",{defaultMessage:"Aggregation type"}),onChange:e=>{P("aggType",e.target.value),v(!1)},options:Object.values(J).map((({text:e,value:t})=>({text:e,value:t})))})))),_.aggType&&J[_.aggType].fieldRequired?(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiPopover,{id:"aggFieldPopover",button:(0,te.jsx)(d.EuiExpression,{description:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.ofLabel",{defaultMessage:"of"}),value:_.aggField||Ot.text,isActive:m||!_.aggField,onClick:()=>{p(!0)},color:_.aggField?"success":"danger"}),isOpen:m,closePopover:()=>{p(!1)},anchorPosition:"downLeft"},(0,te.jsx)("div",null,(0,te.jsx)(d.EuiPopoverTitle,null,h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.ofButtonLabel",{defaultMessage:"of"})),(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1,css:Jt.watcherThresholdAlertAggFieldContainer},(0,te.jsx)(he,{errorKey:"aggField",isShowingErrors:z&&void 0!==_.aggField,errors:B},(0,te.jsx)(d.EuiComboBox,{singleSelection:{asPlainText:!0},placeholder:Ot.text,options:n.reduce(((e,t)=>(J[_.aggType].validNormalizedTypes.includes(t.normalizedType)&&e.push({label:t.name}),e)),[]),selectedOptions:_.aggField?[{label:_.aggField}]:[],onChange:e=>{P("aggField",1===e.length?e[0].label:void 0),p(!1)}}))))))):null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiPopover,{id:"groupByPopover",button:(0,te.jsx)(d.EuiExpression,{description:`${L[_.groupBy].sizeRequired?h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.groupedOverLabel",{defaultMessage:"grouped over"}):h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.overLabel",{defaultMessage:"over"})}`,value:`${L[_.groupBy].text} ${L[_.groupBy].sizeRequired?`${_.termSize||""} ${_.termField?`'${_.termField}'`:""}`:""}`,isActive:x||"top"===_.groupBy&&!(_.termSize&&_.termField),onClick:()=>{w(!0)},color:"all"===_.groupBy||_.termSize&&_.termField?"success":"danger"}),isOpen:x,closePopover:()=>{w(!1)},ownFocus:!0,anchorPosition:"downLeft"},(0,te.jsx)("div",null,(0,te.jsx)(d.EuiPopoverTitle,null,h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.overButtonLabel",{defaultMessage:"over"})),(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiSelect,{value:_.groupBy,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.groupBySelectAriaLabel",{defaultMessage:"Group by"}),onChange:e=>{P("termSize",null),P("termField",null),P("groupBy",e.target.value)},options:Object.values(L).map((({text:e,value:t})=>({text:e,value:t})))})),L[_.groupBy].sizeRequired?(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{errorKey:"termSize",isShowingErrors:z,errors:B},(0,te.jsx)(d.EuiFieldNumber,{value:_.termSize,onChange:e=>{P("termSize",e.target.value)},min:1}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{errorKey:"termField",isShowingErrors:z&&void 0!==_.termField,errors:B},(0,te.jsx)(d.EuiSelect,{value:_.termField||"",onChange:e=>{P("termField",e.target.value)},options:n.reduce(((e,t)=>(L[_.groupBy].validNormalizedTypes.includes(t.normalizedType)&&e.push({text:t.name,value:t.name}),e)),[Ot])})))):null)))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiPopover,{id:"watchThresholdPopover",button:(0,te.jsx)(d.EuiExpression,{"data-test-subj":"watchThresholdButton",description:C[_.thresholdComparator].text,value:_.threshold.slice(0,C[_.thresholdComparator].requiredValues).join(` ${$} `),isActive:Boolean(f||B.threshold0.length||B.threshold1&&B.threshold1.length),onClick:()=>{y(!0)},color:B.threshold0.length||B.threshold1&&B.threshold1.length?"danger":"success"}),isOpen:f,closePopover:()=>{y(!1)},ownFocus:!0,anchorPosition:"downLeft"},(0,te.jsx)("div",null,(0,te.jsx)(d.EuiPopoverTitle,null,C[_.thresholdComparator].text),(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiSelect,{value:_.thresholdComparator,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.comparatorSelectAriaLabel",{defaultMessage:"Comparator"}),onChange:e=>{P("thresholdComparator",e.target.value)},options:Object.values(C).map((({text:e,value:t})=>({text:e,value:t})))})),Array.from(Array(C[_.thresholdComparator].requiredValues)).map(((e,t)=>(0,te.jsx)(s.Fragment,{key:`threshold${t}`},t>0?(0,te.jsx)(d.EuiFlexItem,{grow:!1,css:Jt.watcherThresholdInBetweenComparatorText},(0,te.jsx)(d.EuiText,null,$),z&&(0,te.jsx)(d.EuiSpacer,null)):null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{errorKey:`threshold${t}`,isShowingErrors:z,errors:B},(0,te.jsx)(d.EuiFieldNumber,{"data-test-subj":"watchThresholdInput",value:null==_.threshold[t]?"":_.threshold[t],min:0,step:.1,onChange:e=>{const{value:a}=e.target,s=""!==a?parseFloat(a):a,i=[..._.threshold];i[t]=s,P("threshold",i)}})))))))))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiPopover,{id:"watchDurationPopover",button:(0,te.jsx)(d.EuiExpression,{description:h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.forTheLastLabel",{defaultMessage:"for the last"}),value:`${_.timeWindowSize} ${I(_.timeWindowUnit,parseInt(_.timeWindowSize,10).toString())}`,isActive:j||!_.timeWindowSize,onClick:()=>{E(!0)},color:_.timeWindowSize?"success":"danger"}),isOpen:j,closePopover:()=>{E(!1)},ownFocus:!0,anchorPosition:"downLeft"},(0,te.jsx)("div",null,(0,te.jsx)(d.EuiPopoverTitle,null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.forTheLastButtonLabel",defaultMessage:"For the last"})),(0,te.jsx)(d.EuiFlexGroup,null,(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(he,{errorKey:"timeWindowSize",isShowingErrors:z,errors:B},(0,te.jsx)(d.EuiFieldNumber,{min:1,value:_.timeWindowSize||"",onChange:e=>{const{value:t}=e.target,a=""!==t?parseInt(t,10):t;P("timeWindowSize",a)}}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiSelect,{value:_.timeWindowUnit,"aria-label":h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.timeWindowUnitSelectAriaLabel",{defaultMessage:"Time window unit"}),onChange:e=>{P("timeWindowUnit",e.target.value)},options:Nt(_.timeWindowSize)}))))))),V?(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiSpacer,{size:"m"}),(0,te.jsx)(d.EuiText,{color:"danger",size:"s"},Wt),(0,te.jsx)(d.EuiSpacer,{size:"m"})):null,z?null:(0,te.jsx)(s.Fragment,null,(0,te.jsx)(jt,null),(0,te.jsx)(It,{actionErrors:U})),(0,te.jsx)(d.EuiSpacer,null)):null,(0,te.jsx)(d.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButton,{fill:!0,color:"success","data-test-subj":"saveWatchButton",type:"submit",iconType:"check",disabled:z||q,isLoading:S,onClick:async()=>{A(!0);const e=await Xe(_,t);if(e&&e.error)return A(!1),M(e.error)}},_.isNew?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.createButtonLabel",defaultMessage:"Create alert"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.threshold.saveButtonLabel",defaultMessage:"Save alert"}))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButtonEmpty,{onClick:()=>X()},h.i18n.translate("xpack.watcher.sections.watchEdit.threshold.cancelButtonLabel",{defaultMessage:"Cancel"}))))),(0,te.jsx)(d.EuiFlexItem,{grow:!1},(0,te.jsx)(d.EuiButtonEmpty,{onClick:()=>N(!O)},O?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.hideRequestButtonLabel",defaultMessage:"Hide request"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.json.showRequestButtonLabel",defaultMessage:"Show request"}))))),O?(0,te.jsx)(RequestFlyout,{id:_.id,payload:$e(K),close:()=>N(!1)}):null)},Rt=(e,t)=>{const{command:a,payload:s}=t,{watch:i}=e,n=Watch.getWatchTypes(),r=i&&(0,j.has)(n,i.type)&&(0,j.isFunction)(n[i.type])?n[i.type]:null;switch(a){case"setWatch":return{...e,watch:s};case"setProperty":const{property:t,value:a}=s;return(0,j.isEqual)(i[t],a)?e:r?{...e,watch:new r({...i,[t]:a})}:e;case"addAction":const{type:n,defaults:o}=s;if(r){const t=new r(i);return t.createAction(n,o),{...e,watch:t}}return e;case"setError":return{...e,loadError:s}}},Ht=({match:{params:{id:e,type:t}}})=>{const{setBreadcrumbs:a}=ne(),[{watch:i,loadError:n},r]=(0,s.useReducer)(Rt,{watch:null});(0,s.useEffect)((()=>{(async()=>{if(e)try{const t=await(async e=>{const{watch:t}=await R().get(`${H}/watch/${e}`);return Watch.fromUpstreamJson(t)})(e);r({command:"setWatch",payload:t})}catch(e){r({command:"setError",payload:e.body})}else if(t){const e=Watch.getWatchTypes();if((0,j.has)(e,t)&&(0,j.isFunction)(e[t])){const a=e[t];r({command:"setWatch",payload:new a})}else r({command:"setError",payload:{message:"Invalid watch type"}})}})()}),[e,t]),(0,s.useEffect)((()=>{a([m,e?x:p])}),[e,a]);const l=le(n);if(l)return(0,te.jsx)(ce,{errorCode:l,id:e});if(n)return(0,te.jsx)(o.PageError,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.errorTitle",defaultMessage:"Error loading watch"}),error:n});if(!i)return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,null,(0,te.jsx)(we,null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchEdit.loadingWatchDescription",defaultMessage:"Loading watch…"})));const c=(e=>{if(e.isNew){const t=e.typeName.toLowerCase();return h.i18n.translate("xpack.watcher.sections.watchEdit.json.titlePanel.createNewTypeOfWatchTitle",{defaultMessage:"Create {typeName}",values:{typeName:t}})}return h.i18n.translate("xpack.watcher.sections.watchEdit.json.titlePanel.editWatchTitle",{defaultMessage:"Edit {watchName}",values:{watchName:e.name?e.name:e.id}})})(i);let u=null;switch(i.type){case E.Yk.THRESHOLD:u=Pt;break;case E.Yk.MONITORING:u=ht;break;case E.Yk.JSON:default:u=dt}return(0,te.jsx)(ke.Provider,{value:{watch:i,setWatchProperty:(e,t)=>{r({command:"setProperty",payload:{property:e,value:t}})},addAction:e=>{r({command:"addAction",payload:e})}}},(0,te.jsx)(u,{pageTitle:c}))},Bt=(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.stateHeader.tooltipText",{defaultMessage:"Active, inactive, or error."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchList.watchTable.stateHeader",{defaultMessage:"State"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),zt=(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.lastFiredHeader.tooltipText",{defaultMessage:"The last time the condition was met and action taken."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchList.watchTable.lastFiredHeader",{defaultMessage:"Condition last met"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),Ut=(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.lastTriggeredHeader.tooltipText",{defaultMessage:"The last time the condition was checked."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchList.watchTable.lastTriggeredHeader",{defaultMessage:"Last checked"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),qt=(0,te.jsx)(d.EuiToolTip,{content:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.commentHeader.tooltipText",{defaultMessage:"Whether any actions have been acknowledged, throttled, or failed to execute."})},(0,te.jsx)("span",{tabIndex:0},h.i18n.translate("xpack.watcher.sections.watchList.watchTable.commentHeader",{defaultMessage:"Comment"})," ",(0,te.jsx)(d.EuiIcon,{size:"s",color:"subdued",type:"question",className:"eui-alignTop"}))),Vt=()=>{const{setBreadcrumbs:e,history:t,links:{watcherGettingStartedUrl:a}}=ne(),[n,l]=(0,s.useState)(""),[c,u]=(0,s.useState)(null),[p,x]=(0,s.useState)([]),[w,f]=(0,s.useState)([]),[y,j]=(0,s.useState)([]),[b,T]=(0,s.useState)({pageIndex:0,pageSize:E.Bq.initialPageSize});(0,s.useEffect)((()=>{e([m])}),[e]);const{isLoading:v,data:k,error:M}=(S=E.$Z.WATCH_LIST,_({path:`${H}/watches`,method:"get",pollIntervalMs:S,deserializer:B}));var S;const[A,F]=(0,s.useState)(!1),I=(0,s.useMemo)((()=>k?k.filter((e=>!y.includes(e.id))):void 0),[k,y]),J=(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.subhead",defaultMessage:"Watch for changes or anomalies in your data and take action if needed."}),L=(0,te.jsx)(d.EuiPopover,{id:"createWatchPanel",button:(0,te.jsx)(d.EuiButton,{fill:!0,"data-test-subj":"createWatchButton",iconType:"arrowDown",iconSide:"right",onClick:()=>F(!A)},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.createWatchButtonLabel",defaultMessage:"Create"})),isOpen:A,closePopover:()=>F(!1),panelPaddingSize:"none",anchorPosition:"downCenter"},(0,te.jsx)(d.EuiContextMenuPanel,{items:[E.Yk.THRESHOLD,E.Yk.JSON].map((e=>(0,te.jsx)(d.EuiContextMenuItem,{key:e,"data-test-subj":`${e}WatchCreateLink`,onClick:()=>{F(!1),(e===E.Yk.THRESHOLD?Z:ee)()}},e===E.Yk.THRESHOLD?(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiText,{size:"m"},(0,te.jsx)("span",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.createThresholdAlertButtonLabel",defaultMessage:"Create threshold alert"}))),(0,te.jsx)(d.EuiText,{size:"s",color:"subdued"},(0,te.jsx)("span",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.createThresholdAlertButtonTooltip",defaultMessage:"Send an alert on a specified condition."})))):(0,te.jsx)(s.Fragment,null,(0,te.jsx)(d.EuiText,{size:"m"},(0,te.jsx)("span",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.createAdvancedWatchButtonLabel",defaultMessage:"Create advanced watch"}))),(0,te.jsx)(d.EuiText,{size:"s",color:"subdued"},(0,te.jsx)("span",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.createAdvancedWatchTooltip",defaultMessage:"Set up a custom watch in JSON."})))))))}));if(v)return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,null,(0,te.jsx)(we,null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.loadingWatchesDescription",defaultMessage:"Loading watches…"})));const C=le(M);if(C)return(0,te.jsx)(ce,{errorCode:C});if(M)return(0,te.jsx)(o.PageError,{title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.errorTitle",defaultMessage:"Error loading watches"}),error:M});if(I&&0===I.length){const e=(0,te.jsx)(d.EuiText,{color:"subdued"},(0,te.jsx)("p",null,J," ",(0,te.jsx)(d.EuiLink,{href:a,target:"_blank"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.watcherLearnMoreLinkText",defaultMessage:"Learn more."}))));return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,{iconType:"managementApp",title:(0,te.jsx)("h1",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.emptyPromptTitle",defaultMessage:"You don’t have any watches yet"})),body:e,actions:L,"data-test-subj":"emptyPrompt"})}let W;if(I){const e=[{field:"id",name:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.idHeader",{defaultMessage:"ID"}),sortable:!0,truncateText:!1,render:e=>(0,te.jsx)(d.EuiLink,(0,de.default)({"data-test-subj":`watchIdColumn-${e}`},(0,r.reactRouterNavigate)(t,`/watches/watch/${e}/status`)),e)},{field:"name",name:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.nameHeader",{defaultMessage:"Name"}),render:(e,t)=>(0,te.jsx)("span",{"data-test-subj":`watchNameColumn-${t.id}`},e),sortable:!0,truncateText:!1},{field:"watchStatus.state",name:Bt,sortable:!0,width:"130px",render:e=>(0,te.jsx)(me,{state:e})},{field:"watchStatus.lastMetCondition",name:zt,sortable:!0,truncateText:!0,width:"160px",render:e=>e?e.fromNow():e},{field:"watchStatus.lastChecked",name:Ut,sortable:!0,truncateText:!0,width:"160px",render:e=>e?e.fromNow():e},{field:"watchStatus.comment",name:qt,sortable:!0,truncateText:!0},{name:h.i18n.translate("xpack.watcher.sections.watchList.watchTable.actionHeader",{defaultMessage:"Actions"}),width:"75px",actions:[{render:e=>{const a=h.i18n.translate("xpack.watcher.sections.watchList.watchTable.actionEditTooltipLabel",{defaultMessage:"Edit"});return(0,te.jsx)(d.EuiToolTip,{content:a,delay:"long"},(0,te.jsx)(d.EuiButtonIcon,(0,de.default)({isDisabled:e.isSystemWatch,"aria-label":h.i18n.translate("xpack.watcher.sections.watchList.watchTable.actionEditAriaLabel",{defaultMessage:"Edit watch ''{name}''",values:{name:e.name}}),iconType:"pencil",color:"primary"},(0,r.reactRouterNavigate)(t,`/watches/watch/${e.id}/edit`),{"data-test-subj":"editWatchButton"})))}},{render:e=>{const t=h.i18n.translate("xpack.watcher.sections.watchList.watchTable.actionDeleteTooltipLabel",{defaultMessage:"Delete"});return(0,te.jsx)(d.EuiToolTip,{content:t,delay:"long"},(0,te.jsx)(d.EuiButtonIcon,{isDisabled:e.isSystemWatch,"aria-label":h.i18n.translate("xpack.watcher.sections.watchList.watchTable.actionDeleteAriaLabel",{defaultMessage:"Delete watch ''{name}''",values:{name:e.name}}),iconType:"trash",color:"danger",onClick:()=>{f([e.id])},"data-test-subj":"deleteWatchButton"}))}}]}],a={onSelectionChange:x,selectable:e=>!e.isSystemWatch,selectableMessage:e=>e?"":h.i18n.translate("xpack.watcher.sections.watchList.watchTable.disabledWatchTooltipText",{defaultMessage:"This watch is read-only"})},s={onChange:({queryText:e,error:t})=>{t?u(t.message):(l(e),u(null))},query:n,box:{incremental:!0},toolsLeft:p.length>0?(0,te.jsx)(d.EuiButton,{"data-test-subj":"btnDeleteWatches",onClick:()=>{f(p.map((e=>e.id)))},color:"danger"},p.length>1?(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.deleteMultipleWatchesButtonLabel",defaultMessage:"Delete watches"}):(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.deleteSingleWatchButtonLabel",defaultMessage:"Delete watch"})):void 0,toolsRight:L};W=(0,te.jsx)("div",{"data-test-subj":"watchesTableContainer"},(0,te.jsx)(d.EuiInMemoryTable,{onTableChange:({page:{index:e,size:t}})=>T({pageIndex:e,pageSize:t}),items:I,itemId:"id",columns:e,search:s,pagination:{...E.Bq,pageIndex:b.pageIndex,pageSize:b.pageSize},sorting:{sort:{field:"name",direction:"asc"}},selection:a,childrenBetween:c&&(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiCallOut,{"data-test-subj":"watcherListSearchError",iconType:"warning",color:"danger",title:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.watchTable.errorOnSearch",defaultMessage:"Invalid search: {queryError}",values:{queryError:c}})}),(0,te.jsx)(d.EuiSpacer,null)),message:(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.watchTable.noWatchesMessage",defaultMessage:"No watches to show"}),rowProps:()=>({"data-test-subj":"row"}),cellProps:()=>({"data-test-subj":"cell"}),"data-test-subj":"watchesTable"}))}return(0,te.jsx)(i().Fragment,null,(0,te.jsx)(d.EuiPageHeader,{pageTitle:(0,te.jsx)("span",{"data-test-subj":"appTitle"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.header",defaultMessage:"Watcher"})),bottomBorder:!0,rightSideItems:[(0,te.jsx)(d.EuiButtonEmpty,{href:a,target:"_blank",iconType:"question","data-test-subj":"documentationLink"},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.sections.watchList.watcherGettingStartedDocsLinkText",defaultMessage:"Watcher docs"}))],description:J}),(0,te.jsx)(ue,{callback:e=>{e&&j([...y,...w]),f([])},watchesToDelete:w}),(0,te.jsx)(d.EuiSpacer,{size:"l"}),W)},Gt=({message:e,licenseManagementLocator:t})=>{const a=null==t?void 0:t.useUrl({page:"dashboard"}),s=a?(0,te.jsx)(d.EuiLink,{href:a},(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.app.licenseErrorLinkText",defaultMessage:"Manage your license"})):void 0,n=a?(0,te.jsx)("p",null,e):(0,te.jsx)(i().Fragment,null,(0,te.jsx)("p",null,e),(0,te.jsx)("p",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.app.licenseErrorBody",defaultMessage:"Contact your administrator to change your license."})));return(0,te.jsx)(d.EuiPageTemplate.EmptyPrompt,{iconType:"warning",color:"danger",title:(0,te.jsx)("h1",null,(0,te.jsx)(g.FormattedMessage,{id:"xpack.watcher.app.licenseErrorTitle",defaultMessage:"License error"})),body:n,actions:[s]})},$t=(0,c.withRouter)((({children:e,history:t})=>(Q={history:t},e))),Kt=e=>{const[{valid:t,message:a},i]=(0,s.useState)({valid:!0});return(0,s.useEffect)((()=>{const t=e.licenseStatus$.subscribe(i);return()=>t.unsubscribe()}),[e.licenseStatus$]),t?(0,te.jsx)(u.Router,{history:e.history},(0,te.jsx)($t,null,(0,te.jsx)(ie,{value:e},(0,te.jsx)(Yt,null)))):(0,te.jsx)(Gt,{licenseManagementLocator:e.licenseManagementLocator,message:a})},Yt=()=>(0,te.jsx)(u.Routes,null,(0,te.jsx)(u.Route,{exact:!0,path:"/watches",component:Vt}),(0,te.jsx)(u.Route,{exact:!0,path:"/watches/watch/:id/status",component:ve}),(0,te.jsx)(u.Route,{exact:!0,path:"/watches/watch/:id/edit",component:Ht}),(0,te.jsx)(u.Route,{exact:!0,path:"/watches/new-watch/:type(json|threshold)",component:Ht}),(0,te.jsx)(c.Redirect,{exact:!0,from:"/",to:"/watches"}),(0,te.jsx)(c.Redirect,{exact:!0,from:"",to:"/watches"})),Qt=e=>{const{element:t,...a}=e;var s;return s=a.http,P=s,(0,n.render)((0,te.jsx)(l.KibanaRenderContextProvider,a,(0,te.jsx)(r.KibanaContextProvider,{services:{uiSettings:e.uiSettings,settings:e.settings,theme:e.theme}},(0,te.jsx)(Kt,a))),t),()=>{(0,n.unmountComponentAtNode)(t)}}},91:function(e,t,a){var s,i,n,r,o;
/*! Moment Duration Format v2.2.2
 *  https://github.com/jsmreese/moment-duration-format
 *  Date: 2018-02-16
 *
 *  Duration format plugin function for the Moment.js library
 *  http://momentjs.com/
 *
 *  Copyright 2018 John Madhavan-Reese
 *  Released under the MIT license
 */r=this,o=function(e){var t=!1,a=!1,s=!1,i=!1,n="escape years months weeks days hours minutes seconds milliseconds general".split(" "),r=[{type:"seconds",targets:[{type:"minutes",value:60},{type:"hours",value:3600},{type:"days",value:86400},{type:"weeks",value:604800},{type:"months",value:2678400},{type:"years",value:31536e3}]},{type:"minutes",targets:[{type:"hours",value:60},{type:"days",value:1440},{type:"weeks",value:10080},{type:"months",value:44640},{type:"years",value:525600}]},{type:"hours",targets:[{type:"days",value:24},{type:"weeks",value:168},{type:"months",value:744},{type:"years",value:8760}]},{type:"days",targets:[{type:"weeks",value:7},{type:"months",value:31},{type:"years",value:365}]},{type:"months",targets:[{type:"years",value:12}]}];function o(e,t){return!(t.length>e.length)&&-1!==e.indexOf(t)}function l(e){for(var t="";e;)t+="0",e-=1;return t}function c(e,t){var a=e+"+"+w(v(t).sort(),(function(e){return e+":"+t[e]})).join(",");return c.cache[a]||(c.cache[a]=Intl.NumberFormat(e,t)),c.cache[a]}function u(e,t,n){var r,o,d,h=t.useToLocaleString,g=t.useGrouping,m=g&&t.grouping.slice(),p=t.maximumSignificantDigits,x=t.minimumIntegerDigits||1,w=t.fractionDigits||0,f=t.groupingSeparator,y=t.decimalSeparator;if(h&&n){var j,b={minimumIntegerDigits:x,useGrouping:g};return w&&(b.maximumFractionDigits=w,b.minimumFractionDigits=w),p&&e>0&&(b.maximumSignificantDigits=p),s?(i||((j=T({},t)).useGrouping=!1,j.decimalSeparator=".",e=parseFloat(u(e,j),10)),c(n,b).format(e)):(a||((j=T({},t)).useGrouping=!1,j.decimalSeparator=".",e=parseFloat(u(e,j),10)),e.toLocaleString(n,b))}var E=(p?e.toPrecision(p+1):e.toFixed(w+1)).split("e");d=E[1]||"",o=(E=E[0].split("."))[1]||"";var v=(r=E[0]||"").length,k=o.length,M=v+k,S=r+o;(p&&M===p+1||!p&&k===w+1)&&((S=function(e){for(var t=e.split("").reverse(),a=0,s=!0;s&&a<t.length;)a?"9"===t[a]?t[a]="0":(t[a]=(parseInt(t[a],10)+1).toString(),s=!1):(parseInt(t[a],10)<5&&(s=!1),t[a]="0"),a+=1;return s&&t.push("1"),t.reverse().join("")}(S)).length===M+1&&(v+=1),k&&(S=S.slice(0,-1)),r=S.slice(0,v),o=S.slice(v)),p&&(o=o.replace(/0*$/,""));var A=parseInt(d,10);A>0?o.length<=A?(r+=o+=l(A-o.length),o=""):(r+=o.slice(0,A),o=o.slice(A)):A<0&&(o=l(Math.abs(A)-r.length)+r+o,r="0"),p||((o=o.slice(0,w)).length<w&&(o+=l(w-o.length)),r.length<x&&(r=l(x-r.length)+r));var F,I="";if(g)for(E=r;E.length;)m.length&&(F=m.shift()),I&&(I=f+I),I=E.slice(-F)+I,E=E.slice(0,-F);else I=r;return o&&(I=I+y+o),I}function d(e,t){return e.label.length>t.label.length?-1:e.label.length<t.label.length?1:0}c.cache={};var h={durationLabelsStandard:{S:"millisecond",SS:"milliseconds",s:"second",ss:"seconds",m:"minute",mm:"minutes",h:"hour",hh:"hours",d:"day",dd:"days",w:"week",ww:"weeks",M:"month",MM:"months",y:"year",yy:"years"},durationLabelsShort:{S:"msec",SS:"msecs",s:"sec",ss:"secs",m:"min",mm:"mins",h:"hr",hh:"hrs",d:"dy",dd:"dys",w:"wk",ww:"wks",M:"mo",MM:"mos",y:"yr",yy:"yrs"},durationTimeTemplates:{HMS:"h:mm:ss",HM:"h:mm",MS:"m:ss"},durationLabelTypes:[{type:"standard",string:"__"},{type:"short",string:"_"}],durationPluralKey:function(e,t,a){return 1===t&&null===a?e:e+e}};function g(e){return"[object Array]"===Object.prototype.toString.call(e)}function m(e){return"[object Object]"===Object.prototype.toString.call(e)}function p(e,t){var a,s=0,i=e&&e.length||0;for("function"!=typeof t&&(a=t,t=function(e){return e===a});s<i;){if(t(e[s]))return e[s];s+=1}}function x(e,t){var a=0,s=e.length;if(e&&s)for(;a<s;){if(!1===t(e[a],a))return;a+=1}}function w(e,t){var a=0,s=e.length,i=[];if(!e||!s)return i;for(;a<s;)i[a]=t(e[a],a),a+=1;return i}function f(e,t){return w(e,(function(e){return e[t]}))}function y(e){var t=[];return x(e,(function(e){e&&t.push(e)})),t}function j(e){var t=[];return x(e,(function(e){p(t,e)||t.push(e)})),t}function b(e,t){var a=[];return x(e,(function(e){x(t,(function(t){e===t&&a.push(e)}))})),j(a)}function E(e,t){var a=[];return x(e,(function(s,i){if(!t(s))return a=e.slice(i),!1})),a}function T(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a]);return e}function v(e){var t=[];for(var a in e)e.hasOwnProperty(a)&&t.push(a);return t}function k(e,t){var a=0,s=e.length;if(!e||!s)return!1;for(;a<s;){if(!0===t(e[a],a))return!0;a+=1}return!1}function M(e){return"3.6"===e(3.55,"en",{useGrouping:!1,minimumIntegerDigits:1,minimumFractionDigits:1,maximumFractionDigits:1})}function S(e){var t=!0;return!!((t=(t=(t=t&&"1"===e(1,"en",{minimumIntegerDigits:1}))&&"01"===e(1,"en",{minimumIntegerDigits:2}))&&"001"===e(1,"en",{minimumIntegerDigits:3}))&&(t=(t=(t=(t=t&&"100"===e(99.99,"en",{maximumFractionDigits:0,minimumFractionDigits:0}))&&"100.0"===e(99.99,"en",{maximumFractionDigits:1,minimumFractionDigits:1}))&&"99.99"===e(99.99,"en",{maximumFractionDigits:2,minimumFractionDigits:2}))&&"99.990"===e(99.99,"en",{maximumFractionDigits:3,minimumFractionDigits:3}))&&(t=(t=(t=(t=(t=t&&"100"===e(99.99,"en",{maximumSignificantDigits:1}))&&"100"===e(99.99,"en",{maximumSignificantDigits:2}))&&"100"===e(99.99,"en",{maximumSignificantDigits:3}))&&"99.99"===e(99.99,"en",{maximumSignificantDigits:4}))&&"99.99"===e(99.99,"en",{maximumSignificantDigits:5}))&&(t=(t=t&&"1,000"===e(1e3,"en",{useGrouping:!0}))&&"1000"===e(1e3,"en",{useGrouping:!1})))}function A(){var e,t=[].slice.call(arguments),a={};if(x(t,(function(t,s){if(!s){if(!g(t))throw"Expected array as the first argument to durationsFormat.";e=t}"string"!=typeof t&&"function"!=typeof t?"number"!=typeof t?m(t)&&T(a,t):a.precision=t:a.template=t})),!e||!e.length)return[];a.returnMomentTypes=!0;var s,i=w(e,(function(e){return e.format(a)})),r=b(n,j(f((s=[],x(i,(function(e){s=s.concat(e)})),s),"type"))),o=a.largest;return o&&(r=r.slice(0,o)),a.returnMomentTypes=!1,a.outputTypes=r,w(e,(function(e){return e.format(a)}))}function F(){var a=[].slice.call(arguments),i=T({},this.format.defaults),l=this.asMilliseconds(),c=this.asMonths();"function"==typeof this.isValid&&!1===this.isValid()&&(l=0,c=0);var M=l<0,S=e.duration(Math.abs(l),"milliseconds"),A=e.duration(Math.abs(c),"months");x(a,(function(e){"string"!=typeof e&&"function"!=typeof e?"number"!=typeof e?m(e)&&T(i,e):i.precision=e:i.template=e}));var F={years:"y",months:"M",weeks:"w",days:"d",hours:"h",minutes:"m",seconds:"s",milliseconds:"S"},I={escape:/\[(.+?)\]/,years:/\*?[Yy]+/,months:/\*?M+/,weeks:/\*?[Ww]+/,days:/\*?[Dd]+/,hours:/\*?[Hh]+/,minutes:/\*?m+/,seconds:/\*?s+/,milliseconds:/\*?S+/,general:/.+?/};i.types=n;var J=function(e){return p(n,(function(t){return I[t].test(e)}))},L=new RegExp(w(n,(function(e){return I[e].source})).join("|"),"g");i.duration=this;var C="function"==typeof i.template?i.template.apply(i):i.template,W=i.outputTypes,O=i.returnMomentTypes,N=i.largest,D=[];W||(g(i.stopTrim)&&(i.stopTrim=i.stopTrim.join("")),i.stopTrim&&x(i.stopTrim.match(L),(function(e){var t=J(e);"escape"!==t&&"general"!==t&&D.push(t)})));var _=e.localeData();_||(_={}),x(v(h),(function(e){"function"!=typeof h[e]?_["_"+e]||(_["_"+e]=h[e]):_[e]||(_[e]=h[e])})),x(v(_._durationTimeTemplates),(function(e){C=C.replace("_"+e+"_",_._durationTimeTemplates[e])}));var P=i.userLocale||e.locale(),R=i.useLeftUnits,H=i.usePlural,B=i.precision,z=i.forceLength,U=i.useGrouping,q=i.trunc,V=i.useSignificantDigits&&B>0,G=V?i.precision:0,$=G,K=i.minValue,Y=!1,Q=i.maxValue,X=!1,Z=i.useToLocaleString,ee=i.groupingSeparator,te=i.decimalSeparator,ae=i.grouping;Z=Z&&(t||s);var se=i.trim;g(se)&&(se=se.join(" ")),null===se&&(N||Q||V)&&(se="all"),null!==se&&!0!==se&&"left"!==se&&"right"!==se||(se="large"),!1===se&&(se="");var ie=function(e){return e.test(se)},ne=/both/,re=/^all|[^sm]all/,oe=N>0||k([/large/,ne,re],ie),le=k([/small/,ne,re],ie),ce=k([/mid/,re],ie),ue=k([/final/,re],ie),de=w(C.match(L),(function(e,t){var a=J(e);return"*"===e.slice(0,1)&&(e=e.slice(1),"escape"!==a&&"general"!==a&&D.push(a)),{index:t,length:e.length,text:"",token:"escape"===a?e.replace(I.escape,"$1"):e,type:"escape"===a||"general"===a?null:a}})),he={index:0,length:0,token:"",text:"",type:null},ge=[];R&&de.reverse(),x(de,(function(e){if(e.type)return(he.type||he.text)&&ge.push(he),void(he=e);R?he.text=e.token+he.text:he.text+=e.token})),(he.type||he.text)&&ge.push(he),R&&ge.reverse();var me=b(n,j(y(f(ge,"type"))));if(!me.length)return f(ge,"text").join("");me=w(me,(function(e,t){var a,s=t+1===me.length,n=!t;a="years"===e||"months"===e?A.as(e):S.as(e);var r=Math.floor(a),o=a-r,l=p(ge,(function(t){return e===t.type}));return n&&Q&&a>Q&&(X=!0),s&&K&&Math.abs(i.duration.as(e))<K&&(Y=!0),n&&null===z&&l.length>1&&(z=!0),S.subtract(r,e),A.subtract(r,e),{rawValue:a,wholeValue:r,decimalValue:s?o:0,isSmallest:s,isLargest:n,type:e,tokenLength:l.length}}));var pe,xe=q?Math.floor:Math.round,we=function(e,t){var a=Math.pow(10,t);return xe(e*a)/a},fe=!1,ye=!1,je=function(e,t){var a={useGrouping:U,groupingSeparator:ee,decimalSeparator:te,grouping:ae,useToLocaleString:Z};return V&&(G<=0?(e.rawValue=0,e.wholeValue=0,e.decimalValue=0):(a.maximumSignificantDigits=G,e.significantDigits=G)),X&&!ye&&(e.isLargest?(e.wholeValue=Q,e.decimalValue=0):(e.wholeValue=0,e.decimalValue=0)),Y&&!ye&&(e.isSmallest?(e.wholeValue=K,e.decimalValue=0):(e.wholeValue=0,e.decimalValue=0)),e.isSmallest||e.significantDigits&&e.significantDigits-e.wholeValue.toString().length<=0?B<0?e.value=we(e.wholeValue,B):0===B?e.value=xe(e.wholeValue+e.decimalValue):V?(e.value=q?we(e.rawValue,G-e.wholeValue.toString().length):e.rawValue,e.wholeValue&&(G-=e.wholeValue.toString().length)):(a.fractionDigits=B,e.value=q?e.wholeValue+we(e.decimalValue,B):e.wholeValue+e.decimalValue):V&&e.wholeValue?(e.value=Math.round(we(e.wholeValue,e.significantDigits-e.wholeValue.toString().length)),G-=e.wholeValue.toString().length):e.value=e.wholeValue,e.tokenLength>1&&(z||fe)&&(a.minimumIntegerDigits=e.tokenLength,ye&&a.maximumSignificantDigits<e.tokenLength&&delete a.maximumSignificantDigits),!fe&&(e.value>0||""===se||p(D,e.type)||p(W,e.type))&&(fe=!0),e.formattedValue=u(e.value,a,P),a.useGrouping=!1,a.decimalSeparator=".",e.formattedValueEn=u(e.value,a,"en"),2===e.tokenLength&&"milliseconds"===e.type&&(e.formattedValueMS=u(e.value,{minimumIntegerDigits:3,useGrouping:!1},"en").slice(0,2)),e};if((me=y(me=w(me,je))).length>1){var be=function(e){return p(me,(function(t){return t.type===e}))};x(r,(function(e){var t=be(e.type);t&&x(e.targets,(function(e){var a=be(e.type);a&&parseInt(t.formattedValueEn,10)===e.value&&(t.rawValue=0,t.wholeValue=0,t.decimalValue=0,a.rawValue+=1,a.wholeValue+=1,a.decimalValue=0,a.formattedValueEn=a.wholeValue.toString(),ye=!0)}))}))}return ye&&(fe=!1,G=$,me=y(me=w(me,je))),!W||X&&!i.trim?(oe&&(me=E(me,(function(e){return!e.isSmallest&&!e.wholeValue&&!p(D,e.type)}))),N&&me.length&&(me=me.slice(0,N)),le&&me.length>1&&(pe=function(e){return!e.wholeValue&&!p(D,e.type)&&!e.isLargest},me=E(me.slice().reverse(),pe).reverse()),ce&&(me=y(me=w(me,(function(e,t){return t>0&&t<me.length-1&&!e.wholeValue?null:e})))),!ue||1!==me.length||me[0].wholeValue||!q&&me[0].isSmallest&&me[0].rawValue<K||(me=[])):me=y(me=w(me,(function(e){return p(W,(function(t){return e.type===t}))?e:null}))),O?me:(x(ge,(function(e){var t=F[e.type],a=p(me,(function(t){return t.type===e.type}));if(t&&a){var s=a.formattedValueEn.split(".");s[0]=parseInt(s[0],10),s[1]?s[1]=parseFloat("0."+s[1],10):s[1]=null;var i=_.durationPluralKey(t,s[0],s[1]),n=function(e,t){var a=[];return x(v(t),(function(s){if("_durationLabels"===s.slice(0,15)){var i=s.slice(15).toLowerCase();x(v(t[s]),(function(n){n.slice(0,1)===e&&a.push({type:i,key:n,label:t[s][n]})}))}})),a}(t,_),r=!1,l={};x(_._durationLabelTypes,(function(t){var a=p(n,(function(e){return e.type===t.type&&e.key===i}));a&&(l[a.type]=a.label,o(e.text,t.string)&&(e.text=e.text.replace(t.string,a.label),r=!0))})),H&&!r&&(n.sort(d),x(n,(function(t){return l[t.type]===t.label?!o(e.text,t.label)&&void 0:o(e.text,t.label)?(e.text=e.text.replace(t.label,l[t.type]),!1):void 0})))}})),(ge=w(ge,(function(e){if(!e.type)return e.text;var t=p(me,(function(t){return t.type===e.type}));if(!t)return"";var a="";return R&&(a+=e.text),(M&&X||!M&&Y)&&(a+="< ",X=!1,Y=!1),(M&&Y||!M&&X)&&(a+="> ",X=!1,Y=!1),M&&(t.value>0||""===se||p(D,t.type)||p(W,t.type))&&(a+="-",M=!1),"milliseconds"===e.type&&t.formattedValueMS?a+=t.formattedValueMS:a+=t.formattedValue,R||(a+=e.text),a}))).join("").replace(/(,| |:|\.)*$/,"").replace(/^(,| |:|\.)*/,""))}function I(){var e=this.duration,t=function(t){return e._data[t]},a=p(this.types,t),s=function(e,t){for(var a=e.length;a-=1;)if(t(e[a]))return e[a]}(this.types,t);switch(a){case"milliseconds":return"S __";case"seconds":case"minutes":return"*_MS_";case"hours":return"_HMS_";case"days":if(a===s)return"d __";case"weeks":return a===s?"w __":(null===this.trim&&(this.trim="both"),"w __, d __, h __");case"months":if(a===s)return"M __";case"years":return a===s?"y __":(null===this.trim&&(this.trim="both"),"y __, M __, d __");default:return null===this.trim&&(this.trim="both"),"y __, d __, h __, m __, s __"}}function J(e){if(!e)throw"Moment Duration Format init cannot find moment instance.";e.duration.format=A,e.duration.fn.format=F,e.duration.fn.format.defaults={trim:null,stopTrim:null,largest:null,maxValue:null,minValue:null,precision:0,trunc:!1,forceLength:null,userLocale:null,usePlural:!0,useLeftUnits:!1,useGrouping:!0,useSignificantDigits:!1,template:I,useToLocaleString:!0,groupingSeparator:",",decimalSeparator:".",grouping:[3]},e.updateLocale("en",h)}var L=function(e,t,a){return e.toLocaleString(t,a)};t=function(){try{(0).toLocaleString("i")}catch(e){return"RangeError"===e.name}return!1}()&&S(L),a=t&&M(L);var C=function(e,t,a){if("undefined"!=typeof window&&window&&window.Intl&&window.Intl.NumberFormat)return window.Intl.NumberFormat(t,a).format(e)};return s=S(C),i=s&&M(C),J(e),J},i=[a(783)],void 0===(n="function"==typeof(s=o)?s.apply(t,i):s)||(e.exports=n),r&&(r.momentDurationFormatSetup=r.moment?o(r.moment):o)},185:(e,t,a)=>{e.exports=a(497)(51858)}}]);