"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorExecutor = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ConnectorExecutor {
  constructor(actionsClient) {
    this.actionsClient = actionsClient;
  }
  async execute(connectorType, connectorName, inputs, spaceId) {
    if (!connectorType) {
      throw new Error('Connector type is required');
    }
    return await this.runConnector(connectorName, inputs, spaceId);
  }
  async runConnector(connectorName, connectorParams, spaceId) {
    let connectorId;
    if ((0, _uuid.validate)(connectorName)) {
      connectorId = connectorName;
    } else {
      const allConnectors = await this.actionsClient.getAll('default');
      const connector = allConnectors.find(c => c.name === connectorName);
      if (!connector) {
        throw new Error(`Connector with name ${connectorName} not found`);
      }
      connectorId = connector === null || connector === void 0 ? void 0 : connector.id;
    }
    return await this.actionsClient.execute({
      id: connectorId,
      params: connectorParams,
      spaceId,
      requesterId: 'background_task' // This is a custom ID for testing purposes
    });
  }
}
exports.ConnectorExecutor = ConnectorExecutor;