"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlValidator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var url = _interopRequireWildcard(require("url"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Validates if a URL is allowed based on the allowedHosts configuration.
 * This implements the same logic as the actions plugin but without depending on it.
 */
class UrlValidator {
  constructor(config) {
    (0, _defineProperty2.default)(this, "allowedHosts", void 0);
    this.allowedHosts = new Set(config.allowedHosts);
  }

  /**
   * Checks if a URL is allowed based on the allowedHosts configuration
   */
  isUrlAllowed(uri) {
    try {
      const parsedUrl = url.parse(uri, false, true);
      const hostname = parsedUrl.hostname;
      if (!hostname) {
        return false;
      }
      return this.isHostnameAllowed(hostname);
    } catch (error) {
      return false;
    }
  }

  /**
   * Checks if a hostname is allowed
   */
  isHostnameAllowed(hostname) {
    // Check for wildcard '*' which allows any host
    if (this.allowedHosts.has('*')) {
      return true;
    }

    // Check if the specific hostname is allowed
    return this.allowedHosts.has(hostname);
  }

  /**
   * Validates a URL and throws an error if not allowed
   */
  ensureUrlAllowed(uri) {
    if (!this.isUrlAllowed(uri)) {
      throw new Error(`target url "${uri}" is not added to the Kibana config workflowsExecutionEngine.http.allowedHosts`);
    }
  }
}
exports.UrlValidator = UrlValidator;