"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseAtomicNodeImplementation = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _templating_engine = require("../templating_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Import specific step types as needed from schema
// import { evaluate } from '@marcbachmann/cel-js'

// TODO: To remove it and replace with AtomicGraphNode
// Base step interface

class BaseAtomicNodeImplementation {
  constructor(step, contextManager, connectorExecutor, workflowExecutionRuntime) {
    (0, _defineProperty2.default)(this, "step", void 0);
    (0, _defineProperty2.default)(this, "contextManager", void 0);
    (0, _defineProperty2.default)(this, "templatingEngine", void 0);
    (0, _defineProperty2.default)(this, "connectorExecutor", void 0);
    (0, _defineProperty2.default)(this, "workflowExecutionRuntime", void 0);
    this.step = step;
    this.contextManager = contextManager;
    this.templatingEngine = new _templating_engine.WorkflowTemplatingEngine();
    this.connectorExecutor = connectorExecutor;
    this.workflowExecutionRuntime = workflowExecutionRuntime;
  }
  getName() {
    return this.step.name;
  }
  getInput() {
    return {};
  }
  async run() {
    await this.workflowExecutionRuntime.startStep();
    const input = this.getInput();
    try {
      const result = await this._run(input);
      await this.workflowExecutionRuntime.setCurrentStepResult(result);
    } catch (error) {
      const result = await this.handleFailure(input, error);
      await this.workflowExecutionRuntime.setCurrentStepResult(result);
    } finally {
      await this.workflowExecutionRuntime.finishStep();
    }
    this.workflowExecutionRuntime.navigateToNextNode();
  }

  // Subclasses implement this to execute the step logic

  // Helper for handling on-failure, retries, etc.
  async handleFailure(input, error) {
    // Implement retry logic based on step['on-failure']
    return {
      input,
      output: undefined,
      error: error instanceof Error ? error.message : String(error)
    };
  }
}
exports.BaseAtomicNodeImplementation = BaseAtomicNodeImplementation;