"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterContinueNodeImpl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EnterContinueNodeImpl {
  constructor(node, workflowRuntime, workflowLogger) {
    this.node = node;
    this.workflowRuntime = workflowRuntime;
    this.workflowLogger = workflowLogger;
  }
  async run() {
    this.workflowRuntime.enterScope();
    this.workflowRuntime.navigateToNextNode();
  }
  async catchError() {
    this.workflowLogger.logDebug(`Error caught, continuing execution.`);

    // Continue step should always go to exit continue node to continue execution
    // regardless of any errors that occurred within its scope
    this.workflowRuntime.navigateToNode(this.node.exitNodeId);
    this.workflowRuntime.setWorkflowError(undefined);
  }
}
exports.EnterContinueNodeImpl = EnterContinueNodeImpl;