"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterNormalPathNodeImpl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EnterNormalPathNodeImpl {
  constructor(node, wfExecutionRuntimeManager, workflowLogger) {
    this.node = node;
    this.wfExecutionRuntimeManager = wfExecutionRuntimeManager;
    this.workflowLogger = workflowLogger;
  }
  async run() {
    this.wfExecutionRuntimeManager.enterScope();
    this.wfExecutionRuntimeManager.navigateToNextNode();
  }
  async catchError() {
    this.workflowLogger.logError('Error caught by the OnFailure zone. Redirecting to the fallback path');
    const stepState = this.wfExecutionRuntimeManager.getCurrentStepState() || {};
    await this.wfExecutionRuntimeManager.setCurrentStepState({
      ...stepState,
      error: this.wfExecutionRuntimeManager.getWorkflowExecution().error // save error to the state of the enter node
    });
    this.wfExecutionRuntimeManager.setWorkflowError(undefined); // clear workflow error to let run go
    this.wfExecutionRuntimeManager.navigateToNode(this.node.enterFailurePathNodeId);
    return Promise.resolve();
  }
}
exports.EnterNormalPathNodeImpl = EnterNormalPathNodeImpl;