"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterWorkflowTimeoutZoneNodeImpl = void 0;
var _workflows = require("@kbn/workflows");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EnterWorkflowTimeoutZoneNodeImpl {
  constructor(node, wfExecutionRuntimeManager, wfExecutionState, stepContext) {
    this.node = node;
    this.wfExecutionRuntimeManager = wfExecutionRuntimeManager;
    this.wfExecutionState = wfExecutionState;
    this.stepContext = stepContext;
  }
  async run() {
    await this.wfExecutionRuntimeManager.startStep();
    this.wfExecutionRuntimeManager.enterScope();
    this.wfExecutionRuntimeManager.navigateToNextNode();
  }
  monitor(monitoredContext) {
    const timeoutMs = (0, _utils.parseDuration)(this.node.timeout);
    const stepExecution = this.wfExecutionState.getStepExecution(this.stepContext.stepExecutionId);
    const whenStepStartedTime = new Date(stepExecution.startedAt).getTime();
    const currentTimeMs = new Date().getTime();
    const currentStepDuration = currentTimeMs - whenStepStartedTime;
    if (currentStepDuration > timeoutMs) {
      monitoredContext.abortController.abort();
      this.wfExecutionState.upsertStep({
        id: monitoredContext.stepExecutionId,
        status: _workflows.ExecutionStatus.FAILED
      });
      let stack = monitoredContext.scopeStack;
      while (!stack.isEmpty()) {
        const currentScope = stack.getCurrentScope();
        stack = stack.exitScope();
        this.wfExecutionState.upsertStep({
          id: (0, _utils.buildStepExecutionId)(this.wfExecutionState.getWorkflowExecution().id, currentScope.stepId, stack.stackFrames),
          status: _workflows.ExecutionStatus.FAILED
        });
      }
      this.wfExecutionRuntimeManager.markWorkflowTimeouted();
    }
    return Promise.resolve();
  }
}
exports.EnterWorkflowTimeoutZoneNodeImpl = EnterWorkflowTimeoutZoneNodeImpl;