"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowTemplatingEngine = void 0;
var _nunjucks = _interopRequireDefault(require("nunjucks"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class WorkflowTemplatingEngine {
  constructor() {}
  render(template, context) {
    return this.renderNunjucks(template, context);
  }
  renderNunjucks(template, context) {
    const env = _nunjucks.default.configure({
      autoescape: true
    });

    // We can add custom functions to the Nunjucks environment here.
    // In theory, this could be same as `keep.` functions
    env.addGlobal('now', function (format = 'iso') {
      const date = new Date();
      if (format === 'iso') return date.toISOString();
      if (format === 'locale') return date.toLocaleString();
      return date;
    });
    env.addFilter('json', function (value, spaces) {
      var _JSON$stringify;
      if (value instanceof _nunjucks.default.runtime.SafeString) {
        value = value.toString();
      }
      const jsonString = (_JSON$stringify = JSON.stringify(value, null, spaces)) === null || _JSON$stringify === void 0 ? void 0 : _JSON$stringify.replace(/</g, '\\u003c');
      return new _nunjucks.default.runtime.SafeString(jsonString);
    });
    return env.renderString(template, context);
  }
}
exports.WorkflowTemplatingEngine = WorkflowTemplatingEngine;