"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowValidationError = void 0;
exports.isWorkflowValidationError = isWorkflowValidationError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class WorkflowValidationError extends Error {
  constructor(message, validationErrors) {
    super(message);
    (0, _defineProperty2.default)(this, "statusCode", 400);
    (0, _defineProperty2.default)(this, "isWorkflowValidationError", true);
    this.validationErrors = validationErrors;
    this.name = 'WorkflowValidationError';
  }
  toJSON() {
    return {
      error: 'Bad Request',
      message: this.message,
      statusCode: this.statusCode,
      validationErrors: this.validationErrors
    };
  }
}
exports.WorkflowValidationError = WorkflowValidationError;
function isWorkflowValidationError(error) {
  return Boolean(error && error.isWorkflowValidationError === true);
}