"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VARIABLE_REGEX_GLOBAL = exports.UNFINISHED_VARIABLE_REGEX_GLOBAL = exports.PROPERTY_PATH_REGEX = exports.ALLOWED_KEY_REGEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const VARIABLE_REGEX_GLOBAL = exports.VARIABLE_REGEX_GLOBAL = /\{\{\s*(?<key>[\w.\s|()\[\],"']*?[\w.\s|()\[\],"'])\s*\}\}/g;
const UNFINISHED_VARIABLE_REGEX_GLOBAL = exports.UNFINISHED_VARIABLE_REGEX_GLOBAL = /\{\{\s*(?<key>[\w.\s|()\[\],"']*?[\w.\s|()\[\],"']?)\s*$/g;
const ALLOWED_KEY_REGEX = exports.ALLOWED_KEY_REGEX = /^[a-zA-Z_$][a-zA-Z0-9_$]*(?:\.[a-zA-Z_$][a-zA-Z0-9_$]*|\[\s*(?:\d+|"[^"]*"|'[^']*')\s*\])*(?:\s*\|.*)?$/;
const PROPERTY_PATH_REGEX = exports.PROPERTY_PATH_REGEX = /^[a-zA-Z_$][a-zA-Z0-9_$]*(?:\.[a-zA-Z_$][a-zA-Z0-9_$]*|\[\s*(?:\d+|"[^"]*"|'[^']*')\s*\])*$/;