"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsEmptyState = WorkflowsEmptyState;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/components/workflows_empty_state/workflows_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function WorkflowsEmptyState({
  onCreateWorkflow,
  canCreateWorkflow = false
}) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: http.basePath.prepend('/plugins/workflowsManagement/assets/empty_state.svg'),
      alt: "",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      gutterSize: "s",
      responsive: false,
      wrap: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      style: {
        whiteSpace: 'nowrap'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.title",
      defaultMessage: "Get Started with Workflows",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.emptyState.technicalPreviewBadge",
        defaultMessage: "Technical Preview",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.emptyState.technicalPreviewTooltip",
        defaultMessage: "This functionality is experimental and not supported. It may change or be removed at any time.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      tabIndex: 0,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "workflows.emptyState.technicalPreviewBadge",
        defaultMessage: "Technical Preview",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 19
        }
      }),
      title: "Technical Preview",
      size: "s",
      style: {
        alignSelf: 'center',
        verticalAlign: 'middle'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    })))),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.body.firstParagraph",
      defaultMessage: "Workflows let you automate and orchestrate security actions across your environment. Build step-by-step processes to enrich alerts, trigger responses, or streamline investigations\u2014all in one place. Start by creating a workflow to simplify repetitive tasks and improve efficiency.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }))),
    actions: canCreateWorkflow && onCreateWorkflow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onCreateWorkflow,
      iconType: "plusInCircle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.createButton",
      defaultMessage: "Create a new workflow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: "https://github.com/elastic/workflow-examples",
      target: "_blank",
      iconType: "popout",
      iconSide: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.exampleWorkflowsButton",
      defaultMessage: "Example workflows",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 17
      }
    })))) : null,
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.footer.title",
      defaultMessage: "Need help?",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "#",
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "workflows.emptyState.footer.link",
      defaultMessage: "Read documentation",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
}