"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _i18n = require("@kbn/i18n");
var _react = require("react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function getConnectorType() {
  return {
    id: '.workflows',
    // TODO: workflows icon
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.workflows.selectMessageText', {
      defaultMessage: 'Execute workflows when alerts are triggered.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.workflows.connectorTypeTitle', {
      defaultMessage: 'Workflows'
    }),
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'subActionParams.workflowId': new Array()
      };
      const validationResult = {
        errors
      };
      const workflowId = (_actionParams$subActi = actionParams.subActionParams) === null || _actionParams$subActi === void 0 ? void 0 : (_actionParams$subActi2 = _actionParams$subActi.workflowId) === null || _actionParams$subActi2 === void 0 ? void 0 : _actionParams$subActi2.trim();
      if (!workflowId || workflowId.length === 0) {
        errors['subActionParams.workflowId'].push(translations.WORKFLOW_ID_REQUIRED);
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./workflows_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./workflows_params'))))
  };
}