"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/connectors/workflows/workflows_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowsParamsFields = ({
  actionParams,
  editAction,
  index,
  errors
}) => {
  var _actionParams$subActi;
  const {
    workflowId
  } = (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {};
  const [workflows, setWorkflows] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [loadError, setLoadError] = (0, _react.useState)(null);
  const [selectedWorkflowDisabledError, setSelectedWorkflowDisabledError] = (0, _react.useState)(null);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [inputValue, setInputValue] = (0, _react.useState)('');
  const [isSearching, setIsSearching] = (0, _react.useState)(true);
  const {
    http,
    application
  } = (0, _public.useKibana)().services;

  // Custom render function for workflow options
  const renderWorkflowOption = (0, _react.useCallback)((option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, option.label), option.secondaryContent && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      className: "eui-displayBlock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }, option.secondaryContent))));
  }, []);

  // Ensure proper initialization of action parameters
  (0, _react.useEffect)(() => {
    if (!(actionParams !== null && actionParams !== void 0 && actionParams.subAction)) {
      editAction('subAction', 'run', index);
    }
    if (!(actionParams !== null && actionParams !== void 0 && actionParams.subActionParams)) {
      editAction('subActionParams', {
        workflowId: ''
      }, index);
    }
  }, [actionParams, editAction, index]);
  const editSubActionParams = (0, _react.useCallback)((key, value) => {
    var _actionParams$subActi2;
    const oldParams = (_actionParams$subActi2 = actionParams.subActionParams) !== null && _actionParams$subActi2 !== void 0 ? _actionParams$subActi2 : {};
    const updatedParams = {
      ...oldParams,
      [key]: value
    };
    editAction('subActionParams', updatedParams, index);
  }, [actionParams.subActionParams, editAction, index]);
  const onWorkflowChange = (0, _react.useCallback)((newOptions, event, changedOption) => {
    setWorkflows(newOptions);
    setIsPopoverOpen(false);
    if (changedOption.checked === 'on') {
      editSubActionParams('workflowId', changedOption.id);
      setInputValue(changedOption.name);
      setIsSearching(false);
      // Clear the disabled workflow error when a new workflow is selected
      setSelectedWorkflowDisabledError(null);
    } else {
      editSubActionParams('workflowId', '');
      setInputValue('');
      setIsSearching(true);
      // Clear the disabled workflow error when selection is cleared
      setSelectedWorkflowDisabledError(null);
    }
  }, [editSubActionParams]);
  const handlePopoverClose = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);

    // If the user cleared the input but didn't select anything new,
    // revert to the currently selected workflow
    if (workflowId && workflows.length > 0 && isSearching) {
      const selectedWorkflow = workflows.find(w => w.id === workflowId);
      if (selectedWorkflow) {
        setInputValue(selectedWorkflow.name);
        setIsSearching(false);
      }
    }
  }, [workflowId, workflows, isSearching]);
  const handleCreateNewWorkflow = (0, _react.useCallback)(() => {
    const url = application !== null && application !== void 0 && application.getUrlForApp ? application.getUrlForApp('workflows') : '/app/workflows';
    window.open(url, '_blank');
  }, [application]);
  const handleOpenWorkflow = (0, _react.useCallback)((workflowIdToOpen, event) => {
    // Prevent the click from selecting the workflow option
    event.stopPropagation();
    event.preventDefault();
    event.nativeEvent.stopImmediatePropagation();
    const url = application !== null && application !== void 0 && application.getUrlForApp ? application.getUrlForApp('workflows', {
      path: `/${workflowIdToOpen}`
    }) : `/app/workflows/${workflowIdToOpen}`;
    window.open(url, '_blank');
  }, [application]);

  // Fetch workflows from internal Kibana API
  (0, _react.useEffect)(() => {
    const fetchWorkflows = async () => {
      if (!http) {
        return;
      }
      setIsLoading(true);
      setLoadError(null);
      try {
        const response = await http.post('/api/workflows/search', {
          body: JSON.stringify({
            limit: 1000,
            page: 1,
            query: ''
          })
        });
        const workflowsMap = response;

        // Check if the currently selected workflow is disabled
        let hasSelectedWorkflowDisabled = false;
        const workflowOptionsWithSortInfo = workflowsMap.results.map(workflow => {
          var _workflow$definition$, _workflow$definition, _workflow$definition2;
          // TODO: remove this once we have a way to disable workflows
          const isDisabled = !workflow.enabled;
          const isSelected = workflow.id === workflowId;
          const wasSelectedButNowDisabled = isSelected && isDisabled;
          const hasAlertTriggerType = ((_workflow$definition$ = (_workflow$definition = workflow.definition) === null || _workflow$definition === void 0 ? void 0 : _workflow$definition.triggers) !== null && _workflow$definition$ !== void 0 ? _workflow$definition$ : []).some(trigger => trigger.type === 'alert');

          // Track if selected workflow is disabled
          if (wasSelectedButNowDisabled) {
            hasSelectedWorkflowDisabled = true;
          }

          // Determine what to show in prepend
          let prependElement;
          if (wasSelectedButNowDisabled) {
            // Show warning icon for previously selected but now disabled workflows
            prependElement = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
              type: "alert",
              color: "warning",
              "aria-label": i18n.WORKFLOW_DISABLED_WARNING,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 202,
                columnNumber: 15
              }
            });
          } else if (isDisabled) {
            // Show disabled badge for disabled workflows
            prependElement = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
              color: "default",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 206,
                columnNumber: 30
              }
            }, i18n.DISABLED_BADGE_LABEL);
          }

          // Create tags badges if workflow has tags
          const workflowTags = ((_workflow$definition2 = workflow.definition) === null || _workflow$definition2 === void 0 ? void 0 : _workflow$definition2.tags) || [];
          const tagsElement = workflowTags.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            wrap: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 213,
              columnNumber: 15
            }
          }, workflowTags.map((tag, tagIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            key: tagIndex,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 215,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 216,
              columnNumber: 21
            }
          }, tag)))) : undefined;

          // Create the append element with tags and workflow link
          const appendElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            responsive: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 224,
              columnNumber: 13
            }
          }, tagsElement && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 225,
              columnNumber: 31
            }
          }, tagsElement), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 226,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            iconType: "popout",
            "aria-label": i18n.OPEN_WORKFLOW_LINK,
            title: i18n.OPEN_WORKFLOW_LINK,
            size: "s",
            color: "text",
            style: {
              flexShrink: 0
            },
            onMouseDown: event => {
              event.stopPropagation();
              event.preventDefault();
              event.nativeEvent.stopImmediatePropagation();
            },
            onClick: event => {
              event.stopPropagation();
              event.preventDefault();
              event.nativeEvent.stopImmediatePropagation();
              handleOpenWorkflow(workflow.id, event);
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 227,
              columnNumber: 17
            }
          })));
          return {
            workflowOption: {
              id: workflow.id,
              name: workflow.name,
              description: workflow.description,
              enabled: workflow.enabled,
              tags: workflowTags,
              label: workflow.name,
              disabled: isDisabled,
              checked: isSelected ? 'on' : undefined,
              prepend: prependElement,
              append: appendElement,
              data: {
                secondaryContent: workflow.description
              }
            },
            hasAlertTriggerType
          };
        });

        // Sort workflows by hasAlertTriggerType: if they have an alert trigger type, they should be at the top
        const sortedWorkflowOptionsWithInfo = workflowOptionsWithSortInfo.sort((a, b) => {
          if (a.hasAlertTriggerType && !b.hasAlertTriggerType) return -1;
          if (!a.hasAlertTriggerType && b.hasAlertTriggerType) return 1;
          return 0;
        });

        // Extract just the workflow options for the component
        const workflowOptions = sortedWorkflowOptionsWithInfo.map(item => item.workflowOption);

        // Set error state if selected workflow is disabled
        if (hasSelectedWorkflowDisabled) {
          setSelectedWorkflowDisabledError(i18n.SELECTED_WORKFLOW_DISABLED_ERROR);
        } else {
          setSelectedWorkflowDisabledError(null);
        }
        setWorkflows(workflowOptions);
      } catch (error) {
        setLoadError(i18n.FAILED_TO_LOAD_WORKFLOWS);
      } finally {
        setIsLoading(false);
      }
    };
    fetchWorkflows();
  }, [http, workflowId, handleOpenWorkflow]);

  // Update input value when workflowId changes
  (0, _react.useEffect)(() => {
    if (workflowId && workflows.length > 0) {
      const selectedWorkflow = workflows.find(w => w.id === workflowId);
      if (selectedWorkflow) {
        setInputValue(selectedWorkflow.name);
        setIsSearching(false);
      }
    } else {
      setInputValue('');
      setIsSearching(true);
    }
  }, [workflowId, workflows]);
  const workflowOptions = workflows.length > 0 ? workflows : [{
    id: '',
    name: i18n.NO_WORKFLOWS_AVAILABLE,
    description: '',
    status: '',
    label: i18n.NO_WORKFLOWS_AVAILABLE,
    disabled: true
  }];
  const errorMessages = errors['subActionParams.workflowId'];
  const errorMessage = Array.isArray(errorMessages) ? errorMessages[0] : errorMessages;
  const validationError = typeof errorMessage === 'string' ? errorMessage : undefined;

  // Prioritize selected workflow disabled error over validation errors
  const displayError = selectedWorkflowDisabledError || validationError;
  const helpText = loadError || (isLoading ? i18n.LOADING_WORKFLOWS : undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.WORKFLOW_ID_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: handleCreateNewWorkflow,
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 9
      }
    }, i18n.CREATE_NEW_WORKFLOW, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "plusInCircle",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 38
      }
    })),
    helpText: helpText,
    error: displayError,
    isInvalid: !!displayError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": "Select workflow",
    options: workflowOptions,
    onChange: onWorkflowChange,
    singleSelection: true,
    searchable: true,
    searchProps: {
      value: inputValue,
      onChange: value => {
        setInputValue(value);
        setIsSearching(true);
      },
      onKeyDown: event => {
        if (event.key === 'Tab') return handlePopoverClose();
        if (event.key === 'Escape') return handlePopoverClose();
        if (event.key !== 'Escape') return setIsPopoverOpen(true);
      },
      onClick: () => setIsPopoverOpen(true),
      onFocus: () => setIsPopoverOpen(true),
      placeholder: i18n.SELECT_WORKFLOW_PLACEHOLDER
    },
    isPreFiltered: isSearching ? false : {
      highlightSearch: false
    },
    "data-test-subj": "workflowIdSelect",
    listProps: {
      rowHeight: 60,
      // Increased height to accommodate secondary content and tags
      showIcons: false,
      css: {
        // Hide the badge when the option is focused
        // This should be configurable in EUI, but it's not :(
        '.euiSelectableListItem__onFocusBadge': {
          display: 'none'
        }
      }
    },
    renderOption: renderWorkflowOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    closePopover: handlePopoverClose,
    disableFocusTrap: true,
    closeOnScroll: true,
    isOpen: isPopoverOpen,
    input: search,
    panelPaddingSize: "none",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 13
    }
  }, list)));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = WorkflowsParamsFields;
module.exports = exports.default;