"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflowExecutions = useWorkflowExecutions;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useWorkflowExecutions(params, options = {}) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    networkMode: 'always',
    queryKey: ['workflows', params.workflowId, 'executions', params.statuses, params.executionTypes],
    queryFn: () => http.get(`/api/workflowExecutions`, {
      query: {
        workflowId: params.workflowId,
        statuses: params.statuses,
        executionTypes: params.executionTypes
      }
    }),
    enabled: params.workflowId !== null,
    ...options
  });
}