"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsMenuPopover = ActionsMenuPopover;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _actions_menu = require("./actions_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/actions_menu_popover/ui/actions_menu_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function ActionsMenuPopover({
  onActionSelected,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    panelPaddingSize: "none",
    "aria-label": _i18n.i18n.translate('workflows.actionsMenu.modalTitle', {
      defaultMessage: 'Actions menu'
    }),
    hasArrow: false,
    display: "block",
    initialFocus: "[name='actions-menu-search']"
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_actions_menu.ActionsMenu, {
    onActionSelected: onActionSelected,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
}