"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestStepModal = TestStepModal;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _zodToJsonSchema = require("zod-to-json-schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/run_workflow/ui/test_step_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TestStepModal({
  initialcontextOverride,
  onClose,
  onSubmit
}) {
  const [overflowWidgetsDomNode, setOverflowWidgetsDomNode] = (0, _react.useState)(null);
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [inputsJson, setInputsJson] = _react.default.useState(JSON.stringify(initialcontextOverride.stepContext, null, 2));
  const [isJsonValid, setIsJsonValid] = _react.default.useState(true);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const id = 'json-editor-schema';
  const jsonSchema = (0, _react.useMemo)(() => {
    return (0, _zodToJsonSchema.zodToJsonSchema)(initialcontextOverride.schema, {
      $refStrategy: 'none'
    });
  }, [initialcontextOverride.schema]);
  const modelUri = (0, _react.useMemo)(() => `inmemory://models/${id}.json`, [id]);
  const schemaUri = (0, _react.useMemo)(() => `inmemory://schemas/${id}`, [id]);
  (0, _react.useEffect)(() => {
    const overlayElement = document.createElement('div');
    overlayElement.id = 'step-mock-data-overlay-root';
    overlayElement.style.zIndex = '6001'; // should be above modal's z-index (6000)
    overlayElement.style.position = 'fixed';
    overlayElement.classList.add('monaco-editor');
    document.body.appendChild(overlayElement);
    setOverflowWidgetsDomNode(overlayElement);
    return () => {
      document.body.removeChild(overlayElement);
    };
  }, [setOverflowWidgetsDomNode]);

  // Hook Monaco on mount to register the schema for validation + suggestions
  const mountedOnce = (0, _react.useRef)(false);
  const handleMount = (0, _react.useCallback)(editor => {
    var _editor$getValue;
    if (mountedOnce.current) return;
    mountedOnce.current = true;
    try {
      var _monaco$languages$jso, _monaco$languages$jso2;
      // First, configure the JSON language service with schema validation
      (_monaco$languages$jso = _codeEditor.monaco.languages.json) === null || _monaco$languages$jso === void 0 ? void 0 : (_monaco$languages$jso2 = _monaco$languages$jso.jsonDefaults) === null || _monaco$languages$jso2 === void 0 ? void 0 : _monaco$languages$jso2.setDiagnosticsOptions({
        validate: true,
        allowComments: false,
        enableSchemaRequest: false,
        schemas: [{
          uri: schemaUri,
          // schema URI
          fileMatch: [modelUri],
          // bind to this specific model URI
          schema: jsonSchema
        }]
      });

      // Get current editor content
      const text = editor.getValue() || JSON.stringify(initialcontextOverride.stepContext, null, 2);

      // Create model with the specific URI that matches our schema fileMatch
      const uri = _codeEditor.monaco.Uri.parse(modelUri);
      const model = _codeEditor.monaco.editor.createModel(text, 'json', uri);

      // Set the model to the editor
      editor.setModel(model);
    } catch (error) {
      // Monaco setup failed - fall back to basic JSON editing
    }

    // Optional: seed example if editor is empty
    if (!((_editor$getValue = editor.getValue()) !== null && _editor$getValue !== void 0 && _editor$getValue.trim())) {
      editor.setValue(JSON.stringify(initialcontextOverride.stepContext, null, 2));
    }
  }, [initialcontextOverride.stepContext, jsonSchema, modelUri, schemaUri]);
  (0, _react.useEffect)(() => {
    try {
      JSON.parse(inputsJson);
      setIsJsonValid(true);
    } catch (e) {
      setIsJsonValid(false);
    }
  }, [inputsJson]);
  const handleInputChange = value => {
    setInputsJson(value);
  };
  const handleSubmit = () => {
    if (onSubmit) {
      onSubmit({
        stepInputs: JSON.parse(inputsJson)
      });
    }
  };
  if (!overflowWidgetsDomNode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    maxWidth: false,
    onClose: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.testStepModal.title",
    defaultMessage: "Test step",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.description,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.testStepModal.description",
    defaultMessage: "Test run with current changes and provided payload. Will not be saved in history.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: inputsJson,
    width: 1000,
    height: 500,
    editorDidMount: handleMount,
    onChange: handleInputChange,
    dataTestSubj: 'workflow-event-json-editor',
    options: {
      language: 'json',
      overflowWidgetsDomNode,
      fixedOverflowWidgets: true,
      theme: 'workflows-subdued',
      automaticLayout: true,
      fontSize: 12,
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      alignSelf: 'flex-end'
    },
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleSubmit,
    disabled: !isJsonValid,
    color: "success",
    iconType: "play",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.testStepModal.submitRunBtn",
    defaultMessage: "Run",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }))))));
}
const componentStyles = {
  description: euiThemeContext => (0, _react2.css)({
    ...(0, _eui.euiFontSize)(euiThemeContext, 's'),
    fontWeight: 'normal'
  })
};