"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecuteEventForm = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/run_workflow/ui/workflow_execute_event_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDefaultWorkflowInput = currentUser => {
  const userEmail = (currentUser === null || currentUser === void 0 ? void 0 : currentUser.email) || 'workflow-user@gmail.com';
  const userName = (currentUser === null || currentUser === void 0 ? void 0 : currentUser.username) || 'workflow-user';
  return JSON.stringify({
    event: {
      ruleName: 'Detect vulnerabilities',
      additionalData: {
        user: userEmail,
        userName
      }
    }
  }, null, 2);
};
const getCurrentUser = async security => {
  try {
    if (security) {
      return await security.authc.getCurrentUser();
    }
  } catch (error) {
    // eslint-disable-next-line no-console
    console.error(error);
  }
  return null;
};
const WorkflowExecuteEventForm = ({
  value,
  setValue,
  errors,
  setErrors
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const [currentUser, setCurrentUser] = (0, _react.useState)(null);
  const [selectedAlert, setSelectedAlert] = (0, _react.useState)(null);
  const [alerts, setAlerts] = (0, _react.useState)([]);
  const [alertsLoading, setAlertsLoading] = (0, _react.useState)(false);
  const fetchAlerts = (0, _react.useCallback)(async () => {
    if (!services.http) {
      setErrors('HTTP service not available');
      return;
    }
    setAlertsLoading(true);
    setErrors(null);
    try {
      // Query for recent alerts (last 24 hours)
      const query = {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                gte: 'now-24h',
                lte: 'now'
              }
            }
          }]
        }
      };
      const response = await services.http.post('/api/detection_engine/signals/search', {
        body: JSON.stringify({
          query,
          size: 50,
          // Limit to 50 recent alerts
          sort: [{
            '@timestamp': {
              order: 'desc'
            }
          }],
          _source: ['@timestamp', 'kibana.alert.rule.name', 'kibana.alert.rule.uuid', 'kibana.alert.severity', 'kibana.alert.status', 'kibana.alert.reason', 'agent.name', 'host.name', 'user.name', 'process.name', 'file.name', 'source.ip', 'destination.ip']
        }),
        headers: {
          'Content-Type': 'application/json'
        },
        version: '2023-10-31'
      });
      if (response && response.hits && response.hits.hits) {
        setAlerts(response.hits.hits);
      } else {
        setAlerts([]);
      }
    } catch (err) {
      setErrors(err instanceof Error ? err.message : 'Failed to fetch alerts');
      setAlerts([]);
    } finally {
      setAlertsLoading(false);
    }
  }, [services.http, setErrors]);
  (0, _react.useEffect)(() => {
    fetchAlerts();
  }, [fetchAlerts]);

  // Get current user
  (0, _react.useEffect)(() => {
    if (!services.security) {
      setErrors('Security service not available');
      return;
    }
    getCurrentUser(services.security).then(user => {
      setCurrentUser(user);
    });
  }, [services.security, setErrors]);
  const handleAlertSelection = selectedOptions => {
    if (selectedOptions.length > 0) {
      const selectedAlertId = selectedOptions[0].value;
      const alert = alerts.find(a => a._id === selectedAlertId);
      if (!alert) return;
      setSelectedAlert(alert);

      // Create workflow event from alert data
      const alertEvent = {
        event: {
          alert: {
            id: alert._id,
            index: alert._index,
            timestamp: alert._source['@timestamp'],
            rule: {
              name: alert._source['kibana.alert.rule.name'],
              uuid: alert._source['kibana.alert.rule.uuid']
            },
            severity: alert._source['kibana.alert.severity'],
            status: alert._source['kibana.alert.status'],
            reason: alert._source['kibana.alert.reason'],
            ...(alert._source['agent.name'] && {
              agent: {
                name: alert._source['agent.name']
              }
            }),
            ...(alert._source['host.name'] && {
              host: {
                name: alert._source['host.name']
              }
            }),
            ...(alert._source['user.name'] && {
              user: {
                name: alert._source['user.name']
              }
            }),
            ...(alert._source['process.name'] && {
              process: {
                name: alert._source['process.name']
              }
            }),
            ...(alert._source['file.name'] && {
              file: {
                name: alert._source['file.name']
              }
            }),
            ...(alert._source['source.ip'] && {
              source: {
                ip: alert._source['source.ip']
              }
            }),
            ...(alert._source['destination.ip'] && {
              destination: {
                ip: alert._source['destination.ip']
              }
            })
          },
          additionalData: {
            user: (currentUser === null || currentUser === void 0 ? void 0 : currentUser.email) || 'workflow-user@gmail.com',
            userName: (currentUser === null || currentUser === void 0 ? void 0 : currentUser.username) || 'workflow-user'
          }
        }
      };
      setValue(JSON.stringify(alertEvent, null, 2));
    } else {
      setSelectedAlert(null);
      setValue(getDefaultWorkflowInput(currentUser));
    }
  };
  (0, _react.useEffect)(() => {
    if (!value && currentUser) {
      setValue(getDefaultWorkflowInput(currentUser));
    }
  }, [value, currentUser, setValue]);

  // Convert alerts to combobox options
  const alertOptions = (0, _react.useMemo)(() => {
    return alerts.map(alert => ({
      label: `${alert._source['kibana.alert.rule.name']} - ${alert._source['kibana.alert.severity']} (${new Date(alert._source['@timestamp']).toLocaleString()})`,
      value: alert._id
    }));
  }, [alerts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Select Alert (Optional)",
    helpText: "Choose a recent security alert to populate the workflow event data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, alertsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 21
    }
  }, "Loading alerts..."))) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: "Select an alert to populate event data",
    options: alertOptions,
    selectedOptions: selectedAlert ? alertOptions.filter(opt => opt.value === selectedAlert._id) : [],
    onChange: handleAlertSelection,
    singleSelection: {
      asPlainText: true
    },
    isClearable: true,
    "data-test-subj": "workflow-alert-selector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "refresh",
    onClick: fetchAlerts,
    isLoading: alertsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 15
    }
  }, "Refresh"))))), errors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Failed to load alerts",
    color: "warning",
    iconType: "help",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 13
    }
  }, errors), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }, "Make sure you have the proper permissions to access security alerts, or manually enter the event data below."))), selectedAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Alert Selected",
    color: "success",
    iconType: "check",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 15
    }
  }, selectedAlert._source['kibana.alert.rule.name']), " - Severity:", ' ', selectedAlert._source['kibana.alert.severity'], " - Status:", ' ', selectedAlert._source['kibana.alert.status']))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Event Data",
    helpText: "JSON payload that will be passed to the workflow",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: value,
    fitToContent: {
      minLines: 5,
      maxLines: 10
    },
    width: "100%",
    editorDidMount: () => {},
    onChange: setValue,
    suggestionProvider: undefined,
    dataTestSubj: 'workflow-event-json-editor',
    options: {
      language: 'json',
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }))));
};
exports.WorkflowExecuteEventForm = WorkflowExecuteEventForm;