"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowExecuteManualForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _zod = require("@kbn/zod");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/run_workflow/ui/workflow_execute_manual_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const makeWorkflowInputsValidator = inputs => {
  return _zod.z.object(inputs.reduce((acc, input) => {
    switch (input.type) {
      case 'string':
        acc[input.name] = input.required ? _zod.z.string() : _zod.z.string().optional();
        break;
      case 'number':
        acc[input.name] = input.required ? _zod.z.number() : _zod.z.number().optional();
        break;
      case 'boolean':
        acc[input.name] = input.required ? _zod.z.boolean() : _zod.z.boolean().optional();
        break;
      case 'choice':
        acc[input.name] = input.required ? _zod.z.enum(input.options) : _zod.z.enum(input.options).optional();
        break;
    }
    return acc;
  }, {}));
};
const defaultWorkflowInputsMappings = {
  string: 'Enter a string',
  number: 0,
  boolean: false,
  choice: input => `Select an option: ${input.options.join(', ')}`
};
const getDefaultWorkflowInput = definition => {
  const inputPlaceholder = {};
  if (definition.inputs) {
    definition.inputs.forEach(input => {
      let placeholder = defaultWorkflowInputsMappings[input.type];
      if (typeof placeholder === 'function') {
        placeholder = placeholder(input);
      }
      inputPlaceholder[input.name] = input.default || placeholder;
    });
  }
  return JSON.stringify(inputPlaceholder, null, 2);
};
const WorkflowExecuteManualForm = ({
  definition,
  value,
  setValue,
  errors,
  setErrors
}) => {
  const inputsValidator = (0, _react.useMemo)(() => makeWorkflowInputsValidator((definition === null || definition === void 0 ? void 0 : definition.inputs) || []), [definition === null || definition === void 0 ? void 0 : definition.inputs]);
  const handleChange = (0, _react.useCallback)(data => {
    setValue(data);
    if (definition !== null && definition !== void 0 && definition.inputs) {
      try {
        const res = inputsValidator.safeParse(JSON.parse(data));
        if (!res.success) {
          setErrors(res.error.issues.map(e => `${e.path.join('.')}: ${e.message}`).join(', '));
        } else {
          setErrors(null);
        }
      } catch (e) {
        setErrors(_i18n.i18n.translate('workflows.workflowExecuteManualForm.invalidJSONError', {
          defaultMessage: 'Invalid JSON: {message}',
          values: {
            message: e.message || e.toString()
          }
        }));
      }
    }
  }, [setValue, definition === null || definition === void 0 ? void 0 : definition.inputs, inputsValidator, setErrors]);
  (0, _react.useEffect)(() => {
    if (!value && definition) {
      handleChange(getDefaultWorkflowInput(definition));
    }
  }, [definition, value, handleChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), errors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Input data is not valid",
    color: "danger",
    iconType: "help",
    size: "s",
    announceOnMount: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, errors)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('workflows.workflowExecuteManualForm.inputDataLabel', {
      defaultMessage: 'Input Data'
    }),
    helpText: _i18n.i18n.translate('workflows.workflowExecuteManualForm.inputDataHelpText', {
      defaultMessage: 'JSON payload that will be passed to the workflow'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: value,
    fitToContent: {
      minLines: 5,
      maxLines: 10
    },
    width: "100%",
    editorDidMount: () => {},
    onChange: handleChange,
    suggestionProvider: undefined,
    dataTestSubj: 'workflow-manual-json-editor',
    options: {
      language: 'json',
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      automaticLayout: true,
      lineNumbers: 'on',
      glyphMargin: true,
      tabSize: 2,
      lineNumbersMinChars: 2,
      insertSpaces: true,
      fontSize: 14,
      renderWhitespace: 'all',
      wordWrapColumn: 80,
      wrappingIndent: 'indent',
      theme: 'vs-light',
      quickSuggestions: {
        other: true,
        comments: false,
        strings: true
      },
      formatOnType: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
};
exports.WorkflowExecuteManualForm = WorkflowExecuteManualForm;