"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextSchemaForPath = getContextSchemaForPath;
var _workflows = require("@kbn/workflows");
var _graph = require("@kbn/workflows/graph");
var _lodash = _interopRequireDefault(require("lodash"));
var _get_workflow_context_schema = require("./get_workflow_context_schema");
var _get_foreach_state_schema = require("./get_foreach_state_schema");
var _get_steps_collection_schema = require("./get_steps_collection_schema");
var _get_nearest_step_path = require("./get_nearest_step_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Implementation should be the same as in the 'WorkflowContextManager.getContext' function
// src/platform/plugins/shared/workflows_execution_engine/server/workflow_context_manager/workflow_context_manager.ts
function getContextSchemaForPath(definition, workflowGraph, path) {
  let schema = _workflows.DynamicStepContextSchema.merge((0, _get_workflow_context_schema.getWorkflowContextSchema)(definition));
  const nearestStepPath = (0, _get_nearest_step_path.getNearestStepPath)(path);
  if (!nearestStepPath) {
    return schema;
  }
  const nearestStep = _lodash.default.get(definition, nearestStepPath);
  if (!nearestStep) {
    return schema;
  }
  const stepsCollectionSchema = (0, _get_steps_collection_schema.getStepsCollectionSchema)(schema, workflowGraph, nearestStep.name);
  if (Object.keys(stepsCollectionSchema.shape).length > 0) {
    schema = schema.extend({
      steps: stepsCollectionSchema
    });
  }
  const enrichments = getStepContextSchemaEnrichmentEntries(schema, workflowGraph, nearestStep.name);
  for (const enrichment of enrichments) {
    schema = schema.extend({
      [enrichment.key]: enrichment.value
    });
  }
  return schema;
}
function getStepContextSchemaEnrichmentEntries(stepContextSchema, workflowExecutionGraph, stepId) {
  const enrichments = [];
  const predecessors = workflowExecutionGraph.getAllPredecessors(stepId);
  for (const node of predecessors) {
    if ((0, _graph.isEnterForeach)(node)) {
      enrichments.push({
        key: 'foreach',
        value: (0, _get_foreach_state_schema.getForeachStateSchema)(stepContextSchema, node.configuration)
      });
    }
  }
  return enrichments;
}