"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getForeachStateSchema = getForeachStateSchema;
var _workflows = require("@kbn/workflows");
var _zod = require("@kbn/zod");
var _zod2 = require("../../../../common/lib/zod");
var _parse_variable_path = require("../../../../common/lib/parse_variable_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getForeachStateSchema(stepContextSchema, foreachStep) {
  var _parseVariablePath;
  let itemSchema = _zod.z.unknown();
  const iterateOverPath = ((_parseVariablePath = (0, _parse_variable_path.parseVariablePath)(foreachStep.foreach)) === null || _parseVariablePath === void 0 ? void 0 : _parseVariablePath.propertyPath) || foreachStep.foreach;
  const iterableSchema = (0, _zod2.getSchemaAtPath)(stepContextSchema, iterateOverPath);
  if (!iterableSchema) {
    return _workflows.ForEachContextSchema.extend({
      item: itemSchema,
      items: _zod.z.array(itemSchema)
    });
  }
  if (iterableSchema instanceof _zod.z.ZodArray) {
    itemSchema = iterableSchema.element;
  } else {
    throw new Error(`Foreach step must iterate over an array type, but received: ${(0, _zod2.getDetailedTypeDescription)(iterableSchema)}`);
  }
  return _workflows.ForEachContextSchema.extend({
    item: itemSchema,
    items: _zod.z.array(itemSchema)
  });
}