"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepsCollectionSchema = getStepsCollectionSchema;
var _workflows = require("@kbn/workflows");
var _graph = require("@kbn/workflows/graph");
var _zod = require("@kbn/zod");
var _schema = require("../../../../common/schema");
var _get_foreach_state_schema = require("./get_foreach_state_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getStepsCollectionSchema(stepContextSchema, workflowExecutionGraph, stepName) {
  // reverse predecessors so the earliest steps are first and will be available when we reach the later ones
  const predecessors = [...workflowExecutionGraph.getAllPredecessors((0, _workflows.getStepId)(stepName))].reverse();
  if (predecessors.length === 0) {
    return _zod.z.object({});
  }
  let stepsSchema = _zod.z.object({});
  for (const node of predecessors) {
    // Excluding triggers from the context for now. Maybe they should be included under 'triggers' key?
    if (node.type === 'trigger') {
      continue;
    }
    if (!(0, _graph.isEnterForeach)(node)) {
      stepsSchema = stepsSchema.extend({
        [node.stepId]: _zod.z.object({
          output: (0, _schema.getOutputSchemaForStepType)(node.stepType).optional(),
          error: _zod.z.any().optional()
        })
      });
    } else {
      // if the step is a foreach, add the foreach schema to the step state schema
      stepsSchema = stepsSchema.extend({
        [node.stepId]: (0, _get_foreach_state_schema.getForeachStateSchema)(stepContextSchema.merge(_zod.z.object({
          steps: stepsSchema
        })), node.configuration)
      });
    }
  }
  return stepsSchema;
}